/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public final class CollisionShapeHelper {
    private static final Pattern UNR = Pattern.compile("col+ision_\\d+");
    private static final Pattern DIR = Pattern.compile("col+ision_[neswud]\\d+");
    private static final Map<String, class_265> UNR_CACHE = new ConcurrentHashMap<String, class_265>();
    private static final Map<String, Map<class_2350, class_265>> DIR_CACHE = new ConcurrentHashMap<String, Map<class_2350, class_265>>();

    private CollisionShapeHelper() {
    }

    public static class_265 loadUnrotatedCollisionFromModelJson(String namespace, String path) {
        String key = namespace + ":" + path;
        class_265 c = UNR_CACHE.get(key);
        if (c != null) {
            return c;
        }
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        JsonArray elements = CollisionShapeHelper.readElements(namespace, path);
        if (elements != null) {
            for (JsonElement element : elements) {
                class_265 s;
                String name;
                JsonObject obj = element.getAsJsonObject();
                if (!obj.has("name") || !UNR.matcher(name = obj.get("name").getAsString().toLowerCase(Locale.ROOT)).matches() || (s = CollisionShapeHelper.readCuboid(obj)) == null) continue;
                shapes.add(s);
            }
        }
        class_265 out = shapes.isEmpty() ? class_259.method_1073() : CollisionShapeHelper.combine(shapes);
        UNR_CACHE.put(key, out.method_1097());
        return out;
    }

    public static class_265 loadUnrotatedCollisionPart(String namespace, String path, String partName) {
        JsonArray elements = CollisionShapeHelper.readElements(namespace, path);
        if (elements == null) {
            return class_259.method_1073();
        }
        String want = partName.toLowerCase(Locale.ROOT);
        ArrayList<class_265> parts = new ArrayList<class_265>();
        for (JsonElement el : elements) {
            class_265 s;
            String name;
            JsonObject obj = el.getAsJsonObject();
            if (!obj.has("name") || !(name = obj.get("name").getAsString().toLowerCase(Locale.ROOT)).equals(want) || (s = CollisionShapeHelper.readCuboid(obj)) == null) continue;
            parts.add(s);
        }
        return parts.isEmpty() ? class_259.method_1073() : CollisionShapeHelper.combine(parts).method_1097();
    }

    public static Map<class_2350, class_265> loadDirectionalCollisionFromModelJson(String namespace, String path) {
        String key = namespace + ":" + path;
        Map<class_2350, class_265> cached = DIR_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        JsonArray elements = CollisionShapeHelper.readElements(namespace, path);
        EnumMap buckets = new EnumMap(class_2350.class);
        for (class_2350 d : class_2350.values()) {
            buckets.put(d, new ArrayList());
        }
        boolean foundDirectional = false;
        if (elements != null) {
            for (JsonElement element : elements) {
                class_265 s;
                class_2350 dir;
                String raw;
                JsonObject obj = element.getAsJsonObject();
                if (!obj.has("name") || !DIR.matcher(raw = obj.get("name").getAsString().toLowerCase(Locale.ROOT)).matches()) continue;
                char c = raw.charAt(raw.indexOf(95) + 1);
                if ((dir = (switch (c) {
                    case 'n' -> class_2350.field_11043;
                    case 'e' -> class_2350.field_11034;
                    case 's' -> class_2350.field_11035;
                    case 'w' -> class_2350.field_11039;
                    case 'u' -> class_2350.field_11036;
                    case 'd' -> class_2350.field_11033;
                    default -> null;
                })) == null || (s = CollisionShapeHelper.readCuboid(obj)) == null) continue;
                ((List)buckets.get(dir)).add(s);
                foundDirectional = true;
            }
        }
        EnumMap<class_2350, class_265> result = new EnumMap<class_2350, class_265>(class_2350.class);
        if (foundDirectional) {
            class_2350[] element = class_2350.values();
            int n = element.length;
            for (int raw = 0; raw < n; ++raw) {
                class_2350 d;
                List list = (List)buckets.get(d = element[raw]);
                result.put(d, list.isEmpty() ? class_259.method_1073() : CollisionShapeHelper.combine(list).method_1097());
            }
        } else {
            class_265 north = CollisionShapeHelper.loadUnrotatedCollisionFromModelJson(namespace, path);
            result.put(class_2350.field_11043, north);
            result.put(class_2350.field_11034, CollisionShapeHelper.rotateY(north, 1));
            result.put(class_2350.field_11035, CollisionShapeHelper.rotateY(north, 2));
            result.put(class_2350.field_11039, CollisionShapeHelper.rotateY(north, 3));
            result.put(class_2350.field_11036, CollisionShapeHelper.rotateX(north, 1));
            result.put(class_2350.field_11033, CollisionShapeHelper.rotateX(north, 3));
        }
        EnumMap<class_2350, class_265> simplified = new EnumMap<class_2350, class_265>(class_2350.class);
        for (Map.Entry e : result.entrySet()) {
            simplified.put((class_2350)e.getKey(), ((class_265)e.getValue()).method_1097());
        }
        DIR_CACHE.put(key, simplified);
        return simplified;
    }

    public static class_265 getDirectionalShape(String namespace, String path, class_2350 facing) {
        return CollisionShapeHelper.loadDirectionalCollisionFromModelJson(namespace, path).getOrDefault(facing, class_259.method_1073());
    }

    private static class_265 combine(List<class_265> list) {
        if (list.isEmpty()) {
            return class_259.method_1073();
        }
        class_265 out = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            out = class_259.method_1084((class_265)out, (class_265)list.get(i));
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonArray readElements(String namespace, String path) {
        class_2960 id = class_2960.method_60655((String)namespace, (String)("models/block/" + path + ".json"));
        String resPath = "assets/" + id.method_12836() + "/" + id.method_12832();
        InputStream stream = CollisionShapeHelper.tryOpen(resPath);
        if (stream == null) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!json.has("elements")) {
                JsonArray jsonArray = null;
                return jsonArray;
            }
            JsonArray jsonArray = json.getAsJsonArray("elements");
            return jsonArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InputStream tryOpen(String resourcePath) {
        InputStream in;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = in = cl != null ? cl.getResourceAsStream(resourcePath) : null;
        if (in != null) {
            return in;
        }
        return CollisionShapeHelper.class.getClassLoader().getResourceAsStream(resourcePath);
    }

    private static class_265 readCuboid(JsonObject element) {
        if (!element.has("from") || !element.has("to")) {
            return null;
        }
        JsonArray from = element.getAsJsonArray("from");
        JsonArray to = element.getAsJsonArray("to");
        if (from.size() != 3 || to.size() != 3) {
            return null;
        }
        double x1 = CollisionShapeHelper.clamp16(from.get(0).getAsDouble());
        double y1 = CollisionShapeHelper.clamp16(from.get(1).getAsDouble());
        double z1 = CollisionShapeHelper.clamp16(from.get(2).getAsDouble());
        double x2 = CollisionShapeHelper.clamp16(to.get(0).getAsDouble());
        double y2 = CollisionShapeHelper.clamp16(to.get(1).getAsDouble());
        double z2 = CollisionShapeHelper.clamp16(to.get(2).getAsDouble());
        return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    private static double clamp16(double v) {
        return class_3532.method_15350((double)v, (double)0.0, (double)16.0);
    }

    private static class_265 rotateY(class_265 shape, int quarterTurns) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        for (int i = 0; i < quarterTurns; ++i) {
            buffer[1] = class_259.method_1073();
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double nMinX = 1.0 - maxZ;
                double nMinZ = minX;
                double nMaxX = 1.0 - minZ;
                double nMaxZ = maxX;
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)nMinX, (double)minY, (double)nMinZ, (double)nMaxX, (double)maxY, (double)nMaxZ));
            });
            buffer[0] = buffer[1];
        }
        return buffer[0];
    }

    private static class_265 rotateX(class_265 shape, int quarterTurns) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        for (int i = 0; i < quarterTurns; ++i) {
            buffer[1] = class_259.method_1073();
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double nMinY = 1.0 - maxZ;
                double nMinZ = minY;
                double nMaxY = 1.0 - minZ;
                double nMaxZ = maxY;
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)minX, (double)nMinY, (double)nMinZ, (double)maxX, (double)nMaxY, (double)nMaxZ));
            });
            buffer[0] = buffer[1];
        }
        return buffer[0];
    }
}

