/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.block;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public final class SequencerRegistry {
    private static final Map<String, SequencerAction> ACTIONS = new ConcurrentHashMap<String, SequencerAction>();

    private SequencerRegistry() {
    }

    public static void register(String key, SequencerAction action) {
        ACTIONS.put(key, action);
    }

    public static boolean fire(String key, class_3218 world, class_2338 pos) {
        SequencerAction a = ACTIONS.get(key);
        if (a == null) {
            return false;
        }
        a.run(world, pos);
        return true;
    }

    public static void bootstrapDefaults() {
        SequencerRegistry.register("beep", (w, p) -> w.method_8396(null, p, (class_3414)class_3417.field_14793.comp_349(), class_3419.field_15245, 1.0f, 1.0f));
        SequencerRegistry.register("flash", (w, p) -> w.method_20290(2001, p, class_2248.method_9507((class_2680)w.method_8320(p))));
        SequencerRegistry.register("particles", (w, p) -> w.method_14199((class_2394)class_2398.field_11207, (double)p.method_10263() + 0.5, (double)p.method_10264() + 1.0, (double)p.method_10260() + 0.5, 12, 0.25, 0.25, 0.25, 0.0));
    }

    public static void init() {
        SequencerRegistry.bootstrapDefaults();
    }

    @FunctionalInterface
    public static interface SequencerAction {
        public void run(class_3218 var1, class_2338 var2);
    }
}

