/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.client.cs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public final class CutsceneRecorder {
    public static final CutsceneRecorder I = new CutsceneRecorder();
    private final class_310 MC = class_310.method_1551();
    private final Export data = new Export();
    private boolean hasOrigin = false;
    private boolean previewActive = false;
    private int previewTick = 0;
    private int previewTotalTicks = 0;
    private int currentSegment = 0;

    private CutsceneRecorder() {
    }

    public void setOriginFromPlayer() {
        if (this.MC.field_1724 == null) {
            return;
        }
        class_746 p = this.MC.field_1724;
        this.data.origin.x = p.method_23317();
        this.data.origin.y = p.method_23318();
        this.data.origin.z = p.method_23321();
        this.data.origin.yaw = p.method_36454();
        this.data.origin.pitch = p.method_36455();
        this.hasOrigin = true;
    }

    public boolean hasOrigin() {
        return this.hasOrigin;
    }

    public void clear() {
        this.data.keyframes.clear();
        this.hasOrigin = false;
    }

    public List<Keyframe> list() {
        return Collections.unmodifiableList(this.data.keyframes);
    }

    public void addKey(double durationSeconds, String easePos, String easeRot) {
        if (this.MC.field_1719 == null || !this.hasOrigin) {
            return;
        }
        class_243 cam = this.MC.field_1719.method_5836(1.0f);
        Keyframe k = new Keyframe();
        k.duration = Math.max(0.0, durationSeconds);
        k.rx = cam.field_1352 - this.data.origin.x;
        k.ry = cam.field_1351 - this.data.origin.y;
        k.rz = cam.field_1350 - this.data.origin.z;
        k.yaw = this.MC.field_1719.method_36454();
        k.pitch = this.MC.field_1719.method_36455();
        if (easePos != null && !easePos.isEmpty()) {
            k.easePos = easePos;
        }
        if (easeRot != null && !easeRot.isEmpty()) {
            k.easeRot = easeRot;
        }
        this.data.keyframes.add(k);
    }

    public Path exportJson(String name) throws IOException {
        Path dir = FabricLoader.getInstance().getConfigDir().resolve("odyssey/cutscenes");
        Files.createDirectories(dir, new FileAttribute[0]);
        Path file = dir.resolve(name + ".json");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = gson.toJson((Object)this.data);
        Files.writeString(file, (CharSequence)json, new OpenOption[0]);
        return file;
    }

    public void startPreview() {
        if (!this.hasOrigin || this.data.keyframes.isEmpty() || this.MC.field_1724 == null) {
            return;
        }
        this.previewActive = true;
        this.previewTick = 0;
        this.currentSegment = 0;
        this.previewTotalTicks = (int)Math.round(this.totalDurationSeconds() * 20.0);
        this.MC.field_1724.method_5728(false);
        this.MC.field_1724.method_18799(class_243.field_1353);
    }

    public boolean isPreviewActive() {
        return this.previewActive;
    }

    private double totalDurationSeconds() {
        double s = 0.0;
        for (Keyframe k : this.data.keyframes) {
            s += k.duration;
        }
        return s;
    }

    public void tickPreview() {
        if (!this.previewActive || this.MC.field_1724 == null) {
            return;
        }
        if (this.currentSegment >= this.data.keyframes.size()) {
            this.previewActive = false;
            return;
        }
        Keyframe target = this.data.keyframes.get(this.currentSegment);
        int segTicks = Math.max(1, (int)Math.round(target.duration * 20.0));
        int segTick = this.previewTick % segTicks;
        double t = (double)segTick / (double)segTicks;
        double ep = switch (target.easePos.toLowerCase(Locale.ROOT)) {
            case "easein", "quad_in" -> t * t;
            case "easeout", "quad_out" -> 1.0 - (1.0 - t) * (1.0 - t);
            case "cubic", "cubic_inout" -> {
                double x = t;
                yield x * x * (3.0 - 2.0 * x);
            }
            case "bounceout" -> {
                double x = t;
                if (x < 0.36363636363636365) {
                    yield 121.0 * x * x / 16.0;
                }
                if (x < 0.7272727272727273) {
                    yield 9.075 * x * x - 9.9 * x + 3.4;
                }
                if (x < 0.9) {
                    yield 12.066481994459833 * x * x - 19.63545706371191 * x + 8.898060941828255;
                }
                yield 10.8 * x * x - 20.52 * x + 10.72;
            }
            default -> t;
        };
        double er = switch (target.easeRot.toLowerCase(Locale.ROOT)) {
            case "cubic_inout" -> {
                double x = t;
                yield x * x * (3.0 - 2.0 * x);
            }
            case "easein" -> t * t;
            case "easeout" -> 1.0 - (1.0 - t) * (1.0 - t);
            default -> t;
        };
        class_243 startPos = this.getAccumulatedPosUpTo(this.currentSegment - 1);
        float startYaw = this.getAccumulatedYawUpTo(this.currentSegment - 1);
        float startPitch = this.getAccumulatedPitchUpTo(this.currentSegment - 1);
        class_243 endPos = new class_243(target.rx, target.ry, target.rz);
        float endYaw = target.yaw;
        float endPitch = target.pitch;
        class_243 interp = startPos.method_35590(endPos, ep);
        float yaw = (float)((double)startYaw + (double)(endYaw - startYaw) * er);
        float pitch = (float)((double)startPitch + (double)(endPitch - startPitch) * er);
        class_746 camEnt = this.MC.field_1724;
        camEnt.method_36456(yaw);
        camEnt.method_36457(pitch);
        camEnt.method_30634(this.data.origin.x + interp.field_1352, this.data.origin.y + interp.field_1351, this.data.origin.z + interp.field_1350);
        ++this.previewTick;
        if (segTick >= segTicks - 1) {
            ++this.currentSegment;
        }
        if (this.previewTick >= this.previewTotalTicks || this.currentSegment >= this.data.keyframes.size()) {
            this.previewActive = false;
        }
    }

    private class_243 getAccumulatedPosUpTo(int idxInclusive) {
        if (idxInclusive < 0) {
            return class_243.field_1353;
        }
        return new class_243(this.data.keyframes.get((int)idxInclusive).rx, this.data.keyframes.get((int)idxInclusive).ry, this.data.keyframes.get((int)idxInclusive).rz);
    }

    private float getAccumulatedYawUpTo(int idxInclusive) {
        if (idxInclusive < 0) {
            return this.data.origin.yaw;
        }
        return this.data.keyframes.get((int)idxInclusive).yaw;
    }

    private float getAccumulatedPitchUpTo(int idxInclusive) {
        if (idxInclusive < 0) {
            return this.data.origin.pitch;
        }
        return this.data.keyframes.get((int)idxInclusive).pitch;
    }

    public static final class Export {
        public int version = 1;
        public boolean positionRelativeToOrigin = true;
        public boolean rotationAbsolute = true;
        public Origin origin = new Origin();
        public List<Keyframe> keyframes = new ArrayList<Keyframe>();
        public String defaultEasePos = "linear";
        public String defaultEaseRot = "linear";
    }

    public static final class Origin {
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }

    public static final class Keyframe {
        public double duration = 1.0;
        public double rx;
        public double ry;
        public double rz;
        public float yaw;
        public float pitch;
        public String easePos = "linear";
        public String easeRot = "linear";
    }
}

