/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import net.kronoz.odyssey.block.SequencerRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class SequencerBlockEntity
extends class_2586 {
    private final List<Step> steps = new ArrayList<Step>();
    private final BitSet fired = new BitSet();
    private boolean running = false;
    private long startTick = 0L;
    private boolean loop = false;

    public SequencerBlockEntity(class_2338 pos, class_2680 state, class_2591<?> type) {
        super(type, pos, state);
    }

    public void setSteps(List<Step> list) {
        this.steps.clear();
        this.steps.addAll(list);
        this.steps.sort(Comparator.comparingInt(s -> s.second));
        this.fired.clear();
    }

    public void addStep(int second, String key) {
        this.steps.add(new Step(second, key));
        this.steps.sort(Comparator.comparingInt(s -> s.second));
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void start(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        this.running = true;
        this.fired.clear();
        this.startTick = world.method_8510();
        this.method_5431();
    }

    public void stop(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        this.running = false;
        this.method_5431();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SequencerBlockEntity be) {
        if (world.field_9236 || !be.running || be.steps.isEmpty()) {
            return;
        }
        long elapsedTicks = world.method_8510() - be.startTick;
        if (elapsedTicks < 0L) {
            return;
        }
        int elapsedSec = (int)(elapsedTicks / 20L);
        for (int i = 0; i < be.steps.size(); ++i) {
            if (be.fired.get(i)) continue;
            Step s = be.steps.get(i);
            if (elapsedSec < s.second) continue;
            SequencerRegistry.fire(s.key, (class_3218)world, pos);
            be.fired.set(i);
        }
        if (be.fired.nextClearBit(0) >= be.steps.size()) {
            if (be.loop) {
                be.startTick = world.method_8510();
                be.fired.clear();
            } else {
                be.running = false;
            }
            be.method_5431();
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.steps.clear();
        class_2499 list = nbt.method_10554("steps", 10);
        for (class_2520 e : list) {
            class_2487 c = (class_2487)e;
            this.steps.add(new Step(c.method_10550("sec"), c.method_10558("key")));
        }
        this.running = nbt.method_10577("running");
        this.startTick = nbt.method_10537("start");
        this.loop = nbt.method_10577("loop");
        this.fired.clear();
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 list = new class_2499();
        for (Step s : this.steps) {
            class_2487 c = new class_2487();
            c.method_10569("sec", s.second);
            c.method_10582("key", s.key);
            list.add((Object)c);
        }
        nbt.method_10566("steps", (class_2520)list);
        nbt.method_10556("running", this.running);
        nbt.method_10544("start", this.startTick);
        nbt.method_10556("loop", this.loop);
    }

    public static class Step {
        public int second;
        public String key;

        public Step(int s, String k) {
            this.second = s;
            this.key = k;
        }
    }
}

