/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kronoz.odyssey.entity.SlidePartColliderEntity;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class SlidePlatformEntity
extends class_1297 {
    public static final class_2940<Float> CX = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> CY = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> CZ = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> VX = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> VZ = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> DW = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> DL = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> DH = class_2945.method_12791(SlidePlatformEntity.class, (class_2941)class_2943.field_13327);
    private final List<Part> parts = new ArrayList<Part>();
    private final Map<class_2338, UUID> displayIds = new HashMap<class_2338, UUID>();
    private final Map<class_2338, UUID> colliderIds = new HashMap<class_2338, UUID>();
    private class_243 base = class_243.field_1353;
    private double speed = 0.03;
    private int stepX = 1;
    private int stepZ = 0;
    private boolean infinite = false;
    private class_2338 target = null;
    private double movedAccum = 0.0;

    public SlidePlatformEntity(class_1299<? extends class_1297> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
    }

    protected void method_5693(class_2945.class_9222 b) {
        b.method_56912(CX, (Object)Float.valueOf(0.0f));
        b.method_56912(CY, (Object)Float.valueOf(0.0f));
        b.method_56912(CZ, (Object)Float.valueOf(0.0f));
        b.method_56912(VX, (Object)Float.valueOf(0.0f));
        b.method_56912(VZ, (Object)Float.valueOf(0.0f));
        b.method_56912(DW, (Object)1);
        b.method_56912(DL, (Object)1);
        b.method_56912(DH, (Object)1);
    }

    public void configureHorizontalInfinite(class_2338 originBlock, List<Part> p, double spd, int dx, int dz) {
        this.initCommon(originBlock, p, spd, dx, dz);
        this.infinite = true;
        this.target = null;
    }

    public void configureHorizontalToTarget(class_2338 originBlock, List<Part> p, double spd, int dx, int dz, class_2338 targetCell) {
        this.initCommon(originBlock, p, spd, dx, dz);
        this.infinite = false;
        this.target = targetCell;
    }

    private void initCommon(class_2338 originBlock, List<Part> p, double spd, int dx, int dz) {
        this.base = new class_243((double)originBlock.method_10263(), (double)originBlock.method_10264(), (double)originBlock.method_10260());
        this.method_23327(this.base.field_1352 + 0.5, this.base.field_1351, this.base.field_1350 + 0.5);
        this.clearDisplays();
        this.clearColliders();
        this.parts.clear();
        this.parts.addAll(p);
        this.speed = Math.abs(spd);
        this.stepX = Integer.signum(dx);
        this.stepZ = Integer.signum(dz);
        this.movedAccum = 0.0;
        this.recalcAABB();
        this.ensureDisplays();
        this.ensureColliders();
        this.updateAll(true, 0.0, 0.0);
        if (!this.method_37908().field_9236) {
            int[] d = this.dims();
            class_2945 dt = this.method_5841();
            dt.method_12778(CX, (Object)Float.valueOf((float)(this.base.field_1352 + 0.5)));
            dt.method_12778(CY, (Object)Float.valueOf((float)this.base.field_1351));
            dt.method_12778(CZ, (Object)Float.valueOf((float)(this.base.field_1350 + 0.5)));
            dt.method_12778(VX, (Object)Float.valueOf((float)((double)this.stepX * this.speed)));
            dt.method_12778(VZ, (Object)Float.valueOf((float)((double)this.stepZ * this.speed)));
            dt.method_12778(DW, (Object)d[0]);
            dt.method_12778(DL, (Object)d[1]);
            dt.method_12778(DH, (Object)d[2]);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        double mvx = (double)this.stepX * this.speed;
        double mvz = (double)this.stepZ * this.speed;
        if (this.willHitSolidAhead(mvx, mvz)) {
            this.reifyAndDiscard();
            return;
        }
        class_243 step = new class_243(mvx, 0.0, mvz);
        class_238 nextBB = this.method_5829().method_997(step).method_1009(-0.01, 0.0, -0.01);
        boolean blocked = this.method_37908().method_20812((class_1297)this, nextBB).iterator().hasNext();
        if (blocked) {
            this.reifyAndDiscard();
            return;
        }
        this.base = this.base.method_1019(step);
        this.method_23327(this.base.field_1352 + 0.5, this.base.field_1351, this.base.field_1350 + 0.5);
        this.recalcAABB();
        this.updateAll(false, mvx, mvz);
        this.movedAccum += Math.abs(mvx) + Math.abs(mvz);
        if (this.target != null) {
            if (this.stepX != 0) {
                if (this.stepX > 0 && this.base.field_1352 >= (double)this.target.method_10263()) {
                    this.reifyAndDiscard();
                    return;
                }
                if (this.stepX < 0 && this.base.field_1352 <= (double)this.target.method_10263()) {
                    this.reifyAndDiscard();
                    return;
                }
            } else if (this.stepZ != 0) {
                if (this.stepZ > 0 && this.base.field_1350 >= (double)this.target.method_10260()) {
                    this.reifyAndDiscard();
                    return;
                }
                if (this.stepZ < 0 && this.base.field_1350 <= (double)this.target.method_10260()) {
                    this.reifyAndDiscard();
                    return;
                }
            }
        }
        int[] d = this.dims();
        class_2945 dt = this.method_5841();
        dt.method_12778(CX, (Object)Float.valueOf((float)(this.base.field_1352 + 0.5)));
        dt.method_12778(CY, (Object)Float.valueOf((float)this.base.field_1351));
        dt.method_12778(CZ, (Object)Float.valueOf((float)(this.base.field_1350 + 0.5)));
        dt.method_12778(VX, (Object)Float.valueOf((float)((double)this.stepX * this.speed)));
        dt.method_12778(VZ, (Object)Float.valueOf((float)((double)this.stepZ * this.speed)));
        dt.method_12778(DW, (Object)d[0]);
        dt.method_12778(DL, (Object)d[1]);
        dt.method_12778(DH, (Object)d[2]);
    }

    private boolean willHitSolidAhead(double mvx, double mvz) {
        double ahead = 0.51;
        for (Part p : this.parts) {
            double nx = this.base.field_1352 + (double)p.off.method_10263() + (mvx > 0.0 ? 0.51 : (mvx < 0.0 ? -0.51 : 0.0));
            double nz = this.base.field_1350 + (double)p.off.method_10260() + (mvz > 0.0 ? 0.51 : (mvz < 0.0 ? -0.51 : 0.0));
            int bx = (int)Math.floor(nx);
            int by = (int)Math.floor(this.base.field_1351 + (double)p.off.method_10264());
            int bz = (int)Math.floor(nz);
            class_2680 st = this.method_37908().method_8320(new class_2338(bx, by, bz));
            if (st.method_26215() || st.method_26220((class_1922)this.method_37908(), new class_2338(bx, by, bz)).method_1110()) continue;
            return true;
        }
        return false;
    }

    private int[] dims() {
        if (this.parts.isEmpty()) {
            return new int[]{1, 1, 1};
        }
        int minX = 999999;
        int minY = 999999;
        int minZ = 999999;
        int maxX = -999999;
        int maxY = -999999;
        int maxZ = -999999;
        for (Part p : this.parts) {
            int x = p.off.method_10263();
            int y = p.off.method_10264();
            int z = p.off.method_10260();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        int w = maxX - minX + 1;
        int l = maxZ - minZ + 1;
        int h = maxY - minY + 1;
        if (w < 1) {
            w = 1;
        }
        if (l < 1) {
            l = 1;
        }
        if (h < 1) {
            h = 1;
        }
        return new int[]{w, l, h};
    }

    private void ensureDisplays() {
        if (this.method_37908().field_9236) {
            return;
        }
        for (Part p : this.parts) {
            if (this.displayIds.containsKey(p.off)) continue;
            class_8113.class_8115 disp = new class_8113.class_8115(class_1299.field_42460, this.method_37908());
            disp.method_48883(p.state == null ? class_2246.field_10085.method_9564() : p.state);
            double x = this.base.field_1352 + (double)p.off.method_10263();
            double y = this.base.field_1351 + (double)p.off.method_10264();
            double z = this.base.field_1350 + (double)p.off.method_10260();
            disp.method_5808(x, y, z, 0.0f, 0.0f);
            this.method_37908().method_8649((class_1297)disp);
            this.displayIds.put(p.off, disp.method_5667());
        }
    }

    private void ensureColliders() {
        if (this.method_37908().field_9236) {
            return;
        }
        for (Part p : this.parts) {
            SlidePartColliderEntity col;
            if (this.colliderIds.containsKey(p.off) || (col = (SlidePartColliderEntity)ModEntities.SLIDE_PART_COLLIDER.method_5883((class_1937)((class_3218)this.method_37908()))) == null) continue;
            double x = this.base.field_1352 + (double)p.off.method_10263();
            double y = this.base.field_1351 + (double)p.off.method_10264();
            double z = this.base.field_1350 + (double)p.off.method_10260();
            col.method_5808(x + 0.5, y + 0.5, z + 0.5, 0.0f, 0.0f);
            double eps = 0.025;
            col.method_5857(new class_238(x + eps, y, z + eps, x + 1.0 - eps, y + 1.0, z + 1.0 - eps));
            ((class_3218)this.method_37908()).method_8649((class_1297)col);
            this.colliderIds.put(p.off, col.method_5667());
        }
    }

    private void updateAll(boolean snap, double vx, double vz) {
        if (this.method_37908().field_9236) {
            return;
        }
        for (Part p : this.parts) {
            class_1297 e;
            UUID cid;
            class_1297 e2;
            UUID id = this.displayIds.get(p.off);
            if (id != null && (e2 = ((class_3218)this.method_37908()).method_14190(id)) instanceof class_8113.class_8115) {
                class_8113.class_8115 d = (class_8113.class_8115)e2;
                double x = this.base.field_1352 + (double)p.off.method_10263();
                double y = this.base.field_1351 + (double)p.off.method_10264();
                double z = this.base.field_1350 + (double)p.off.method_10260();
                d.method_23327(x, y, z);
            }
            if ((cid = this.colliderIds.get(p.off)) == null || !((e = ((class_3218)this.method_37908()).method_14190(cid)) instanceof SlidePartColliderEntity)) continue;
            SlidePartColliderEntity c = (SlidePartColliderEntity)e;
            double x = this.base.field_1352 + (double)p.off.method_10263();
            double y = this.base.field_1351 + (double)p.off.method_10264();
            double z = this.base.field_1350 + (double)p.off.method_10260();
            c.method_23327(x + 0.5, y + 0.5, z + 0.5);
            double eps = 0.025;
            c.method_5857(new class_238(x + eps, y, z + eps, x + 1.0 - eps, y + 1.0, z + 1.0 - eps));
            c.setStep(vx, vz);
        }
        SlidePlatformEntity.prune(this.parts, this.displayIds);
        SlidePlatformEntity.prune(this.parts, this.colliderIds);
    }

    private static void prune(List<Part> parts, Map<class_2338, UUID> map) {
        HashSet<class_2338> keep = new HashSet<class_2338>();
        for (Part p : parts) {
            keep.add(p.off);
        }
        map.entrySet().removeIf(e -> !keep.contains(e.getKey()));
    }

    private void clearDisplays() {
        if (this.method_37908().field_9236) {
            return;
        }
        for (UUID id : this.displayIds.values()) {
            class_1297 e = ((class_3218)this.method_37908()).method_14190(id);
            if (e == null) continue;
            e.method_31472();
        }
        this.displayIds.clear();
    }

    private void clearColliders() {
        if (this.method_37908().field_9236) {
            return;
        }
        for (UUID id : this.colliderIds.values()) {
            class_1297 e = ((class_3218)this.method_37908()).method_14190(id);
            if (e == null) continue;
            e.method_31472();
        }
        this.colliderIds.clear();
    }

    private void recalcAABB() {
        if (this.parts.isEmpty()) {
            this.method_5857(new class_238(this.base.field_1352, this.base.field_1351, this.base.field_1350, this.base.field_1352 + 1.0, this.base.field_1351 + 1.0, this.base.field_1350 + 1.0));
            this.method_5808(this.base.field_1352 + 0.5, this.base.field_1351, this.base.field_1350 + 0.5, 0.0f, 0.0f);
            return;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Part p : this.parts) {
            double x1 = this.base.field_1352 + (double)p.off.method_10263();
            double y1 = this.base.field_1351 + (double)p.off.method_10264();
            double z1 = this.base.field_1350 + (double)p.off.method_10260();
            if (x1 < minX) {
                minX = x1;
            }
            if (y1 < minY) {
                minY = y1;
            }
            if (z1 < minZ) {
                minZ = z1;
            }
            if (x1 + 1.0 > maxX) {
                maxX = x1 + 1.0;
            }
            if (y1 + 1.0 > maxY) {
                maxY = y1 + 1.0;
            }
            if (!(z1 + 1.0 > maxZ)) continue;
            maxZ = z1 + 1.0;
        }
        this.method_5857(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
        this.method_5808(this.base.field_1352 + 0.5, this.base.field_1351, this.base.field_1350 + 0.5, 0.0f, 0.0f);
    }

    private void reifyAndDiscard() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            this.method_31472();
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        for (Part p : this.parts) {
            class_2338 at = new class_2338((int)Math.floor(this.base.field_1352 + (double)p.off.method_10263()), (int)Math.floor(this.base.field_1351 + (double)p.off.method_10264()), (int)Math.floor(this.base.field_1350 + (double)p.off.method_10260()));
            sw.method_8652(at, p.state == null ? class_2246.field_10085.method_9564() : p.state, 3);
        }
        this.clearDisplays();
        this.clearColliders();
        this.method_31472();
    }

    protected void method_5749(class_2487 nbt) {
        this.base = new class_243(nbt.method_10574("bx"), nbt.method_10574("by"), nbt.method_10574("bz"));
        this.speed = nbt.method_10574("spd");
        this.stepX = nbt.method_10550("sx");
        this.stepZ = nbt.method_10550("sz");
        this.method_23327(this.base.field_1352 + 0.5, this.base.field_1351, this.base.field_1350 + 0.5);
        this.ensureDisplays();
        this.ensureColliders();
        this.updateAll(true, 0.0, 0.0);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10549("bx", this.base.field_1352);
        nbt.method_10549("by", this.base.field_1351);
        nbt.method_10549("bz", this.base.field_1350);
        nbt.method_10549("spd", this.speed);
        nbt.method_10569("sx", this.stepX);
        nbt.method_10569("sz", this.stepZ);
    }

    public static class Part {
        public class_2338 off;
        public class_2680 state;

        public Part(class_2338 o, class_2680 s) {
            this.off = o;
            this.state = s;
        }
    }
}

