/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.apostasy;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.kronoz.odyssey.entity.DebrisBlockEntity;
import net.kronoz.odyssey.entity.GroundDecalEntity;
import net.kronoz.odyssey.entity.ShockwaveEntity;
import net.kronoz.odyssey.entity.projectile.LaserProjectileEntity;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ApostasyEntity
extends class_1314
implements GeoEntity {
    private static final double RING1_R = 2.4;
    private static final double RING2_R = 3.1;
    private static final double RING3_R = 3.8;
    private static final double RINGS_Y = 1.6;
    private static final int RING_SHOT_INTERVAL = 20;
    private static final int HUGE_LASER_INTERVAL = 65;
    private static final double HUGE_LASER_SPEED = 2.75;
    private static final double SMALL_LASER_SPEED = 2.15;
    private static final double EYE_ALIGN_DEG = 22.5;
    private int eyeBurstShotsLeft = 0;
    private int glowShotCooldown = 0;
    private int glowMuzzleIndex = 0;
    private static final int TELEGRAPH_TICKS = 20;
    private static final int P2_SINGLE_COOLDOWN = 60;
    private static final int P3_ZONE_COOLDOWN = 150;
    private static final int PHASE3_BURST = 20;
    private static final int PHASE3_MIN_R = 10;
    private static final int PHASE3_MAX_R = 50;
    private static final double KEEP_OUT_RADIUS = 20.0;
    private static final double KEEP_OUT_PUSH = 20.4;
    private static final double LINE_TRIGGER_RANGE = 20.0;
    private static final double HOVER_OFFSET = 8.0;
    private static final double HOVER_K = 0.35;
    private static final double HOVER_D = 0.5;
    private static final double HOVER_MAX_VY = 0.5;
    private static final double HOVER_SAMPLE_UP = 24.0;
    private static final double HOVER_SAMPLE_DOWN = 64.0;
    private int ringShotCooldown = 10;
    private int hugeLaserCooldown = 40;
    private int lightningCooldown = 40;
    private int shockwaveCooldown = 0;
    private static final int SHOCKWAVE_COOLDOWN_P1 = 120;
    private static final int SHOCKWAVE_COOLDOWN_P2 = 90;
    private static final int SHOCKWAVE_COOLDOWN_P3 = 70;
    private Phase phase = Phase.P1;
    private double hoverVy = 0.0;
    private double lastTargetY = Double.NaN;
    private final List<PendingStrike> pendingStrikes = new ArrayList<PendingStrike>();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int duration = 40;
    private boolean lightSpawned = false;
    private PointLightData bodyLight;
    private LightRenderHandle<PointLightData> bodyLightHandle;
    private boolean cutsceneActive = false;

    public ApostasyEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 50;
        this.field_5985 = true;
        this.method_5875(true);
        this.field_5960 = false;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 900.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 64.0);
    }

    private void updatePhase() {
        Phase newPhase;
        float pct = this.method_6032() / this.method_6063();
        Phase phase = pct > 0.75f ? Phase.P1 : (pct > 0.5f ? Phase.P2 : (newPhase = pct > 0.25f ? Phase.P3 : Phase.P4));
        if (newPhase != this.phase) {
            this.phase = newPhase;
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BrainGoal());
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.method_31472();
        } else {
            this.field_6278 = 0;
        }
    }

    private void tickBrain() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.updatePhase();
        this.repulsePlayers();
        this.tickPendingStrikes();
        this.tickGlowHoming();
        class_1657 target = this.getClosestTarget();
        if (target == null) {
            return;
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.handlePhase1(target);
                break;
            }
            case 1: {
                this.handlePhase2(target);
                break;
            }
            case 2: 
            case 3: {
                this.handlePhase3(target);
            }
        }
        if (this.shockwaveCooldown > 0) {
            --this.shockwaveCooldown;
        }
    }

    private void repulsePlayers() {
        class_238 box = this.method_5829().method_1014(20.0);
        List players = this.method_37908().method_8390(class_1657.class, box, p -> p.method_5805() && !p.method_7325());
        for (class_1657 p2 : players) {
            class_243 d = p2.method_19538().method_1020(this.method_19538());
            double dist = Math.max(0.2, d.method_1033());
            double t = Math.max(0.0, 20.0 - dist) / 20.0;
            class_243 n = d.method_1021(1.0 / dist);
            double push = 20.4 * (0.6 + 0.4 * t);
            p2.method_5762(n.field_1352 * push, 0.35, n.field_1350 * push);
            p2.field_6007 = true;
            p2.method_5844(p2.method_37908().method_8320(p2.method_24515()), new class_243(0.2, 1.0, 0.2));
        }
    }

    @Nullable
    private class_1657 getClosestTarget() {
        return this.method_37908().method_18460((class_1297)this, 64.0);
    }

    private void handlePhase1(class_1657 target) {
        if (this.ringShotCooldown-- <= 0) {
            this.ringShotCooldown = 20;
            this.fireRingsBurst(target);
        }
        if (this.field_5974.method_43057() < 0.1f) {
            this.tryStartEyeBurst(target, 6);
        }
        if (this.field_5974.method_43057() < 0.04f) {
            this.tryShockwave(target);
        }
    }

    private void handlePhase2(class_1657 target) {
        boolean near;
        if (this.hugeLaserCooldown-- <= 0) {
            this.hugeLaserCooldown = 65;
            this.fireEyeHugeLaser(target);
        }
        if (this.field_5974.method_43057() < 0.14f) {
            this.tryStartEyeBurst(target, 8);
        }
        if (this.lightningCooldown-- <= 0) {
            this.lightningCooldown = 60;
            class_2338 strikePos = this.safeStrikeNear(target.method_24515());
            this.scheduleLightning(strikePos, 20);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 sw = (class_3218)class_19372;
                List<class_2680> pulled = this.pullDownColumnBlocks(sw, strikePos, 8, 4);
                this.spawnDebrisCloud(sw, strikePos, pulled, 4);
            }
        }
        if (this.field_5974.method_43057() < 0.06f) {
            this.tryShockwave(target);
        }
        boolean bl = near = this.method_5858((class_1297)target) <= 400.0;
        if (near && this.field_5974.method_43057() < 0.05f) {
            this.scheduleLightningLineTowards(target, 8, 5);
        }
        if (this.field_5974.method_43057() < 0.03f && this.hugeLaserCooldown <= 0) {
            this.hugeLaserCooldown = 45;
            this.fireEyeHugeLaser(target);
        } else if (this.hugeLaserCooldown > 0) {
            --this.hugeLaserCooldown;
        }
    }

    private void handlePhase3(class_1657 target) {
        boolean near;
        if (this.hugeLaserCooldown-- <= 0) {
            this.hugeLaserCooldown = 65;
            this.fireEyeHugeLaser(target);
        }
        if (this.field_5974.method_43057() < 0.14f) {
            this.tryStartEyeBurst(target, 8);
        }
        if (this.lightningCooldown-- <= 0) {
            this.lightningCooldown = 150;
            int delay = 0;
            for (int i = 0; i < 20; ++i) {
                class_2338 around = this.randomPosAround();
                class_2338 safe = this.safeStrikeAt(around);
                this.scheduleLightning(safe, 20 + delay);
                delay += 6;
            }
        }
        if (this.field_5974.method_43057() < 0.08f) {
            this.tryShockwave(target);
        }
        boolean bl = near = this.method_5858((class_1297)target) <= 400.0;
        if (near && this.field_5974.method_43057() < 0.07f) {
            this.scheduleLightningLineTowards(target, 12, 4);
        }
    }

    private boolean isEyeAlignedWith(class_1657 target) {
        float headYaw = this.method_5791();
        double dx = target.method_23317() - this.method_23317();
        double dz = target.method_23321() - this.method_23321();
        double bearingDeg = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
        double d = class_3532.method_15338((double)(bearingDeg - (double)headYaw));
        return Math.abs(d) <= 22.5;
    }

    private void tryStartEyeBurst(class_1657 target, int shots) {
        if (this.eyeBurstShotsLeft > 0) {
            return;
        }
        if (!this.isEyeAlignedWith(target)) {
            return;
        }
        this.eyeBurstShotsLeft = Math.max(1, shots);
    }

    private void tryShockwave(class_1657 target) {
        if (this.shockwaveCooldown > 0) {
            return;
        }
        this.spawnShockwaveAtPlayerY(target);
        this.shockwaveCooldown = switch (this.phase.ordinal()) {
            case 0 -> 120;
            case 1 -> 90;
            default -> 70;
        };
    }

    private void spawnShockwaveAtPlayerY(class_1657 target) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        ShockwaveEntity e = (ShockwaveEntity)ModEntities.SHOCKWAVE.method_5883((class_1937)sw);
        if (e == null) {
            return;
        }
        double py = Math.floor(target.method_23318()) + 0.05;
        e.method_5808(this.method_23317(), py, this.method_23321(), 0.0f, 0.0f);
        e.setup(50.0f, 40, false);
        sw.method_8649((class_1297)e);
    }

    public boolean method_5655() {
        return false;
    }

    public boolean method_5679(class_1282 source) {
        return false;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 e) {
    }

    public void method_6005(double s, double x, double z) {
    }

    public void method_5762(double x, double y, double z) {
    }

    private class_2338 randomPosAround() {
        double a = this.field_5974.method_43058() * Math.PI * 2.0;
        int r = this.field_5974.method_39332(10, 50);
        int x = class_3532.method_15357((double)(this.method_23317() + Math.cos(a) * (double)r));
        int z = class_3532.method_15357((double)(this.method_23321() + Math.sin(a) * (double)r));
        return new class_2338(x, this.method_31478(), z);
    }

    private void spawnVeilLight() {
        class_243 pos = this.method_19538();
        this.bodyLight = new PointLightData().setPosition(pos.field_1352, pos.field_1351, pos.field_1350).setRadius(200.0f).setBrightness((float)(2 * this.field_6012 * 200)).setColor(1.0f, 0.8f, 0.1f);
        this.bodyLightHandle = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)this.bodyLight);
        if (this.field_6012 > this.duration) {
            this.freeLight();
        }
    }

    private boolean playerOn(class_2338 pos) {
        return !this.method_37908().method_8390(class_1657.class, new class_238(pos).method_1014(1.5), p -> p.method_5805() && !p.method_7325()).isEmpty();
    }

    private class_2338 safeStrikeNear(class_2338 center) {
        for (int tries = 0; tries < 16; ++tries) {
            double a = this.field_5974.method_43058() * Math.PI * 2.0;
            int r = this.field_5974.method_39332(2, 5);
            class_2338 candidate = center.method_10069(class_3532.method_15357((double)(Math.cos(a) * (double)r)), 0, class_3532.method_15357((double)(Math.sin(a) * (double)r)));
            class_2338 safe = this.safeStrikeAt(candidate);
            if (this.playerOn(safe)) continue;
            return safe;
        }
        return this.safeStrikeAt(center);
    }

    private class_2338 safeStrikeAt(class_2338 approx) {
        double x = (double)approx.method_10263() + 0.5;
        double z = (double)approx.method_10260() + 0.5;
        double yStart = this.method_23318() + 16.0;
        double yEnd = this.method_23318() - 64.0;
        class_3965 hit = this.method_37908().method_17742(new class_3959(new class_243(x, yStart, z), new class_243(x, yEnd, z), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        double y = hit.method_17783() == class_239.class_240.field_1332 ? hit.method_17784().field_1351 : (double)(this.method_37908().method_31607() + 1);
        return class_2338.method_49637((double)x, (double)y, (double)z);
    }

    private void scheduleLightning(class_2338 pos, int delay) {
        this.pendingStrikes.add(new PendingStrike(pos, delay));
    }

    private void tickPendingStrikes() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        ArrayList<PendingStrike> next = new ArrayList<PendingStrike>(this.pendingStrikes.size());
        for (PendingStrike ps : this.pendingStrikes) {
            this.spawnGroundTelegraph(sw, ps.pos);
            --ps.ticks;
            if (ps.ticks <= 0) {
                class_1538 bolt;
                class_2338 strikePos = ps.pos;
                if (this.playerOn(strikePos) || (bolt = (class_1538)class_1299.field_6112.method_5883((class_1937)sw)) == null) continue;
                bolt.method_29498(true);
                bolt.method_29495(class_243.method_24955((class_2382)strikePos));
                sw.method_8649((class_1297)bolt);
                sw.method_43276((class_6880)class_5712.field_28152, strikePos, class_5712.class_7397.method_43285((class_1297)this));
                this.causeDebrisOnLightning(sw, strikePos);
                continue;
            }
            next.add(ps);
        }
        this.pendingStrikes.clear();
        this.pendingStrikes.addAll(next);
    }

    private void scheduleLightningLineTowards(class_1657 target, int nodes, int tickDelayStep) {
        class_2338 start = this.safeStrikeAt(class_2338.method_49637((double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321()));
        class_243 startV = new class_243((double)start.method_10263() + 0.5, (double)start.method_10264(), (double)start.method_10260() + 0.5);
        class_2338 tgt = this.safeStrikeAt(target.method_24515());
        class_243 dir = new class_243((double)tgt.method_10263() + 0.5 - startV.field_1352, 0.0, (double)tgt.method_10260() + 0.5 - startV.field_1350).method_1029();
        int delay = 0;
        for (int i = 0; i < nodes; ++i) {
            class_243 p = startV.method_1019(dir.method_1021(4.0 * (double)i));
            class_2338 pos = this.safeStrikeAt(class_2338.method_49637((double)p.field_1352, (double)this.method_23318(), (double)p.field_1350));
            if (this.playerOn(pos)) continue;
            this.scheduleLightning(pos, 20 + delay);
            delay += tickDelayStep;
        }
    }

    private void causeDebrisOnLightning(class_3218 sw, class_2338 strikePos) {
        ArrayList<class_2680> list = new ArrayList<class_2680>();
        class_2680 ground = this.groundStateAt(sw, strikePos);
        if (ground != null) {
            list.add(ground);
        }
        list.addAll(this.pullDownColumnBlocks(sw, strikePos, 12, 6));
        this.spawnDebrisCloud(sw, strikePos, list, 6);
    }

    private class_2680 groundStateAt(class_3218 sw, class_2338 pos) {
        class_2338 p = pos;
        for (int i = 0; i < 3; ++i) {
            class_2680 st = sw.method_8320(p);
            if (!st.method_26215()) {
                return st;
            }
            p = p.method_10074();
        }
        return class_2246.field_10124.method_9564();
    }

    private List<class_2680> pullDownColumnBlocks(class_3218 sw, class_2338 pos, int scanUp, int maxPull) {
        ArrayList<class_2680> grabbed = new ArrayList<class_2680>();
        int pulled = 0;
        class_2338.class_2339 m = new class_2338.class_2339();
        for (int dy = 1; dy <= scanUp && pulled < maxPull; ++dy) {
            class_2248 blk;
            m.method_10103(pos.method_10263(), pos.method_10264() + dy, pos.method_10260());
            class_2680 st = sw.method_8320((class_2338)m);
            if (st.method_26215() || (blk = st.method_26204()) == class_2246.field_9987 || blk == class_2246.field_10499 || st.method_26220((class_1922)sw, (class_2338)m).method_1110()) continue;
            sw.method_8652((class_2338)m, class_2246.field_10124.method_9564(), 3);
            class_1540 f = class_1540.method_40005((class_1937)sw, (class_2338)m, (class_2680)st);
            f.field_7193 = false;
            try {
                f.method_49181();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            double spread = 0.35;
            f.method_18800((this.field_5974.method_43058() - 0.5) * spread, -0.2 - this.field_5974.method_43058() * 0.2, (this.field_5974.method_43058() - 0.5) * spread);
            grabbed.add(st);
            ++pulled;
        }
        return grabbed;
    }

    private void spawnDebrisCloud(class_3218 sw, class_2338 pos, List<class_2680> states, int count) {
        for (int i = 0; i < count; ++i) {
            DebrisBlockEntity e = (DebrisBlockEntity)ModEntities.DEBRIS_BLOCK.method_5883((class_1937)sw);
            if (e == null) continue;
            class_2680 st = states != null && !states.isEmpty() ? states.get(this.field_5974.method_43048(states.size())) : class_2246.field_10445.method_9564();
            e.init(st, 40 + this.field_5974.method_39332(0, 20));
            double ox = (this.field_5974.method_43058() - 0.5) * 1.8;
            double oz = (this.field_5974.method_43058() - 0.5) * 1.8;
            double oy = 0.4 + this.field_5974.method_43058() * 0.4;
            e.method_5808((double)pos.method_10263() + 0.5 + ox, (double)pos.method_10264() + 0.6, (double)pos.method_10260() + 0.5 + oz, 0.0f, 0.0f);
            e.method_18800(ox * 0.6, oy, oz * 0.6);
            float avx = (float)((this.field_5974.method_43058() - 0.5) * 20.0);
            float avy = (float)((this.field_5974.method_43058() - 0.5) * 20.0);
            float avz = (float)((this.field_5974.method_43058() - 0.5) * 20.0);
            e.setAngularVelocity(avx, avy, avz);
            sw.method_8649((class_1297)e);
        }
    }

    private void spawnGroundTelegraph(class_3218 sw, class_2338 pos) {
        GroundDecalEntity e = (GroundDecalEntity)ModEntities.GROUND_DECAL.method_5883((class_1937)sw);
        if (e == null) {
            return;
        }
        e.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.01, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        e.setup(0.95, 20);
        sw.method_8649((class_1297)e);
    }

    private void tickGlowHoming() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        if (this.glowShotCooldown > 0) {
            --this.glowShotCooldown;
            return;
        }
        class_1657 target = this.getClosestTarget();
        if (target == null) {
            return;
        }
        List<class_243> muzzles = this.getGlowMuzzles();
        if (muzzles.isEmpty()) {
            return;
        }
        if (this.glowMuzzleIndex >= muzzles.size()) {
            this.glowMuzzleIndex = 0;
        }
        class_243 mCenter = muzzles.get(this.glowMuzzleIndex++);
        LaserProjectileEntity rocket = (LaserProjectileEntity)ModEntities.LASER_PROJECTILE.method_5883((class_1937)sw);
        if (rocket != null) {
            rocket.initHoming((class_1309)this, (class_1297)target, mCenter, 0.6);
            rocket.setOdysseyDamage(1.0f);
            sw.method_8649((class_1297)rocket);
        }
        this.glowShotCooldown = 10;
    }

    private List<class_243> getGlowMuzzles() {
        double yawRad = (float)Math.PI / 180 * (this.method_36454() % 360.0f);
        ArrayList<class_243> out = new ArrayList<class_243>(24);
        out.addAll(this.buildRingMuzzles(2.4, yawRad));
        out.addAll(this.buildRingMuzzles(3.1, yawRad * 0.97));
        out.addAll(this.buildRingMuzzles(3.8, yawRad * 0.94));
        return out;
    }

    private void fireEyeHugeLaser(class_1657 target) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        class_243 eye = this.getEyeMuzzleCenter();
        class_243 aim = target.method_19538().method_1031(0.0, (double)target.method_5751(), 0.0);
        class_243 dir = aim.method_1020(eye).method_1029();
        class_243 muzzle = eye.method_1019(dir.method_1021(0.6));
        LaserProjectileEntity beam = (LaserProjectileEntity)ModEntities.LASER_PROJECTILE.method_5883((class_1937)sw);
        if (beam == null) {
            return;
        }
        beam.method_5808(muzzle.field_1352, muzzle.field_1351, muzzle.field_1350, 0.0f, 0.0f);
        beam.method_7432((class_1297)this);
        beam.method_18799(dir.method_1021(2.75));
        beam.setOdysseyDamage(10.0f);
        sw.method_8649((class_1297)beam);
    }

    private void fireRingsBurst(class_1657 target) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        List<class_243> muzzles = this.getRingsMuzzles();
        class_243 aim = target.method_19538().method_1031(0.0, (double)target.method_5751() * 0.6, 0.0);
        for (class_243 mCenter : muzzles) {
            class_243 dir = aim.method_1020(mCenter).method_1029();
            class_243 m = mCenter.method_1019(dir.method_1021(0.35));
            LaserProjectileEntity laser = (LaserProjectileEntity)ModEntities.LASER_PROJECTILE.method_5883((class_1937)sw);
            if (laser == null) continue;
            laser.method_5808(m.field_1352, m.field_1351, m.field_1350, 0.0f, 0.0f);
            laser.method_7432((class_1297)this);
            laser.method_18799(dir.method_1021(2.15));
            laser.setOdysseyDamage(3.0f);
            sw.method_8649((class_1297)laser);
        }
    }

    private class_243 getEyeMuzzleCenter() {
        return this.method_19538().method_1031(0.0, (double)this.method_5751() + 0.4, 0.0);
    }

    private List<class_243> getRingsMuzzles() {
        double yawRad = (float)Math.PI / 180 * (this.method_36454() % 360.0f);
        ArrayList<class_243> out = new ArrayList<class_243>(24);
        out.addAll(this.buildRingMuzzles(2.4, yawRad));
        out.addAll(this.buildRingMuzzles(3.1, yawRad * 0.97));
        out.addAll(this.buildRingMuzzles(3.8, yawRad * 0.94));
        return out;
    }

    private List<class_243> buildRingMuzzles(double radius, double yawRad) {
        ArrayList<class_243> list = new ArrayList<class_243>(8);
        class_243 center = this.method_19538().method_1031(0.0, 1.6, 0.0);
        for (int i = 0; i < 8; ++i) {
            double a = yawRad + Math.PI * 2 * ((double)i / 8.0);
            double x = center.field_1352 + (double)class_3532.method_15362((float)((float)a)) * radius;
            double z = center.field_1350 + (double)class_3532.method_15374((float)((float)a)) * radius;
            list.add(new class_243(x, center.field_1351, z));
        }
        return list;
    }

    public void method_5773() {
        super.method_5773();
        double targetY = this.groundYAt(this.method_23317(), this.method_23318(), this.method_23321()) + 8.0;
        double err = targetY - this.method_23318();
        this.hoverVy += 0.35 * err - 0.5 * this.hoverVy;
        this.hoverVy = class_3532.method_15350((double)this.hoverVy, (double)-0.5, (double)0.5);
        double vx = this.method_18798().field_1352 * 0.9;
        double vz = this.method_18798().field_1350 * 0.9;
        this.method_18800(vx, this.hoverVy, vz);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.field_5992 && this.hoverVy < 0.0) {
            this.hoverVy = 0.0;
        }
        this.field_6017 = 0.0f;
        this.method_5875(true);
        this.field_5960 = false;
        this.lastTargetY = targetY;
        if (this.method_37908().field_9236) {
            class_1657 target;
            if (!this.lightSpawned) {
                this.spawnVeilLight();
                DeathUICutscene.start();
                target = this.getClosestTarget();
                if (target != null) {
                    this.cutsceneActive = true;
                }
                this.lightSpawned = true;
            }
            ++this.field_6012;
            if (this.cutsceneActive && this.field_6012 >= this.duration) {
                target = this.getClosestTarget();
                this.cutsceneActive = false;
                this.freeLight();
            }
        }
    }

    public void method_36209() {
        super.method_36209();
        this.freeLight();
    }

    private void freeLight() {
        if (this.bodyLightHandle != null && this.bodyLightHandle.isValid()) {
            this.bodyLightHandle.free();
        }
        this.bodyLightHandle = null;
        this.bodyLight = null;
    }

    private double groundYAt(double x, double yRef, double z) {
        class_243 start = new class_243(x, yRef + 24.0, z);
        class_243 end = new class_243(x, yRef - 64.0, z);
        class_3965 hit = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            return hit.method_17784().field_1351;
        }
        return (double)this.method_37908().method_31607() + 1.0;
    }

    public void method_5768() {
        super.method_5768();
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42336)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10582("Phase", this.phase.name());
        nbt.method_10569("cdRing", this.ringShotCooldown);
        nbt.method_10569("cdHuge", this.hugeLaserCooldown);
        nbt.method_10569("cdBolt", this.lightningCooldown);
        nbt.method_10569("cdShock", this.shockwaveCooldown);
        nbt.method_10549("hvVy", this.hoverVy);
        nbt.method_10549("lastTY", this.lastTargetY);
    }

    public void method_5749(class_2487 nbt) {
        try {
            this.phase = Phase.valueOf(nbt.method_10558("Phase"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ringShotCooldown = nbt.method_10550("cdRing");
        this.hugeLaserCooldown = nbt.method_10550("cdHuge");
        this.lightningCooldown = nbt.method_10550("cdBolt");
        if (nbt.method_10545("cdShock")) {
            this.shockwaveCooldown = nbt.method_10550("cdShock");
        }
        if (nbt.method_10545("hvVy")) {
            this.hoverVy = nbt.method_10574("hvVy");
        }
        if (nbt.method_10545("lastTY")) {
            this.lastTargetY = nbt.method_10574("lastTY");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum Phase {
        P1,
        P2,
        P3,
        P4;

    }

    private class BrainGoal
    extends class_1352 {
        BrainGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            ApostasyEntity.this.tickBrain();
        }
    }

    private static final class PendingStrike {
        final class_2338 pos;
        int ticks;

        PendingStrike(class_2338 pos, int ticks) {
            this.pos = pos;
            this.ticks = ticks;
        }
    }
}

