/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.apostasy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ApostasyThemeClient {
    private static final Map<Integer, Loop> ACTIVE = new HashMap<Integer, Loop>();
    private static class_3414 THEME;

    public static void init(class_3414 themeEvent) {
        THEME = themeEvent;
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc.field_1687 == null || mc.field_1724 == null || THEME == null) {
                ApostasyThemeClient.stopAll();
                return;
            }
            for (class_1297 e : mc.field_1687.method_18112()) {
                if (!ApostasyThemeClient.isApostasy(e) || !e.method_5805()) continue;
                Loop loop = ACTIVE.get(e.method_5628());
                if (loop == null || loop.method_4793()) {
                    loop = new Loop(THEME, e.method_5628());
                    ACTIVE.put(e.method_5628(), loop);
                    mc.method_1483().method_4873((class_1113)loop);
                    continue;
                }
                loop.ensureFollowingEntity(e.method_5628());
            }
            Iterator<Map.Entry<Integer, Loop>> it = ACTIVE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Loop> entry = it.next();
                int id = entry.getKey();
                Loop loop = entry.getValue();
                class_1297 e = mc.field_1687.method_8469(id);
                if (e != null && e.method_5805()) continue;
                loop.requestStop();
                it.remove();
            }
        });
    }

    private static boolean isApostasy(class_1297 e) {
        return e.getClass().getSimpleName().equals("ApostasyEntity") || e.method_5864().toString().toLowerCase().contains("apostasy");
    }

    private static void stopAll() {
        for (Loop s : ACTIVE.values()) {
            s.requestStop();
        }
        ACTIVE.clear();
    }

    private ApostasyThemeClient() {
    }

    private static final class Loop
    implements class_1117 {
        private final class_3414 event;
        private final class_3419 category = class_3419.field_15253;
        private int entityId;
        private boolean done = false;
        private boolean repeat = true;
        private int repeatDelay = 0;
        private boolean relative = false;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;
        private class_1113.class_1114 attenuation = class_1113.class_1114.field_5476;

        Loop(class_3414 event, int entityId) {
            this.event = event;
            this.entityId = entityId;
        }

        void requestStop() {
            this.done = true;
        }

        void ensureFollowingEntity(int id) {
            this.entityId = id;
        }

        public void method_16896() {
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null || mc.field_1724 == null) {
                this.done = true;
                return;
            }
            class_1297 e = mc.field_1687.method_8469(this.entityId);
            if (e == null || !e.method_5805()) {
                this.done = true;
                return;
            }
            this.x = e.method_23317();
            this.y = e.method_23318();
            this.z = e.method_23321();
            double maxDist = 64.0;
            double t = 1.0 - Math.min(1.0, (double)e.method_5739((class_1297)mc.field_1724) / maxDist);
            float vol = (float)(0.25 + 0.75 * t);
            this.volume = class_3532.method_15363((float)vol, (float)0.0f, (float)1.0f);
        }

        public boolean method_4793() {
            return this.done;
        }

        public class_2960 method_4775() {
            return this.event.method_14833();
        }

        @Nullable
        public class_1146 method_4783(class_1144 sm) {
            class_1146 set = sm.method_4869(this.method_4775());
            if (set == null) {
                this.done = true;
            }
            return set;
        }

        @Nullable
        public class_1111 method_4776() {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return null;
            }
            class_1144 sm = mc.method_1483();
            class_1146 set = sm.method_4869(this.method_4775());
            if (set == null) {
                this.done = true;
                return null;
            }
            return set.method_4887(class_5819.method_43047());
        }

        public class_3419 method_4774() {
            return this.category;
        }

        public boolean method_4786() {
            return this.repeat;
        }

        public boolean method_4787() {
            return this.relative;
        }

        public int method_4780() {
            return this.repeatDelay;
        }

        public float method_4781() {
            return this.volume;
        }

        public float method_4782() {
            return this.pitch;
        }

        public double method_4784() {
            return this.x;
        }

        public double method_4779() {
            return this.y;
        }

        public double method_4778() {
            return this.z;
        }

        public class_1113.class_1114 method_4777() {
            return this.attenuation;
        }
    }
}

