/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.arcangel;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.kronoz.odyssey.entity.apostasy.ApostasyEntity;
import net.kronoz.odyssey.init.ModSounds;
import net.kronoz.odyssey.systems.cam.ClientFx;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcangelEntity
extends class_1314
implements GeoEntity {
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(ArcangelEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> BLOOD = class_2945.method_12791(ArcangelEntity.class, (class_2941)class_2943.field_13327);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private boolean prevShootingClient;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int SHAKE_DELAY_TICKS = 40;
    private int shakeDelayClient = -1;
    private boolean shakeFiredThisShot = false;
    private static final int SHOOT_DURATION_TICKS = 80;
    private static final int DAMAGE_HIT_TICKS = 60;
    private static final float ARCANGEL_DAMAGE = 150.0f;
    private int shootingTicks;
    private boolean playedShootSfx;
    @Nullable
    private UUID lockedTarget;
    private float fullBodyYawDeg;
    private float headPitchDeg;
    private float recoilRad;
    private float bodyYawTargetDeg;
    private float headPitchTargetDeg;

    public ArcangelEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
        this.method_5971();
        this.method_5977(true);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26827().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 32.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHOOTING, (Object)false);
        builder.method_56912(BLOOD, (Object)0);
    }

    public void addBlood(int amount) {
        if (this.method_37908().field_9236) {
            this.field_6011.method_12789(BLOOD);
            return;
        }
        int cur = class_3532.method_15340((int)((Integer)this.field_6011.method_12789(BLOOD) + amount), (int)0, (int)100);
        this.field_6011.method_12778(BLOOD, (Object)cur);
        if (cur >= 100) {
            this.startShooting();
            this.field_6011.method_12778(BLOOD, (Object)0);
        }
        this.field_6011.method_12789(BLOOD);
    }

    public void startShooting() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (!((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue()) {
            this.field_6011.method_12778(SHOOTING, (Object)true);
            this.shootingTicks = 80;
            this.playedShootSfx = false;
            ApostasyEntity target = this.findNearestApostasyUnlimited();
            this.lockedTarget = target != null ? target.method_5667() : null;
            this.updateAimTargets(target);
            this.recoilRad = 0.35f;
        }
    }

    public void method_5773() {
        super.method_5773();
        this.method_18799(class_243.field_1353);
        this.field_6017 = 0.0f;
        ApostasyEntity visibleTarget = this.resolveLockedTarget();
        if (visibleTarget == null) {
            visibleTarget = this.findNearestApostasyUnlimited();
        }
        this.updateAimTargets(visibleTarget);
        this.fullBodyYawDeg = ArcangelEntity.approachAngleDeg(this.fullBodyYawDeg, this.bodyYawTargetDeg);
        this.headPitchDeg = class_3532.method_16439((float)0.2f, (float)this.headPitchDeg, (float)this.headPitchTargetDeg);
        if (this.recoilRad > 0.0f) {
            this.recoilRad *= 0.88f;
            if (this.recoilRad < 0.005f) {
                this.recoilRad = 0.0f;
            }
        }
        if (this.method_37908().field_9236) {
            boolean now = (Boolean)this.field_6011.method_12789(SHOOTING);
            if (now && !this.prevShootingClient) {
                this.shakeDelayClient = 40;
                this.shakeFiredThisShot = false;
            }
            if (now && this.shakeDelayClient >= 0 && this.shakeDelayClient-- == 0 && !this.shakeFiredThisShot) {
                ClientFx.rapidShakeStart(200.75f, 40);
                this.shakeFiredThisShot = true;
            }
            if (!now) {
                this.shakeDelayClient = -1;
                this.shakeFiredThisShot = false;
            }
            this.prevShootingClient = now;
        }
        if (!this.method_37908().field_9236 && ((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue() && this.shootingTicks == 60) {
            ApostasyEntity target = this.resolveLockedTarget();
            if (target == null) {
                target = this.findNearestApostasyUnlimited();
            }
            if (target != null && target.method_5805()) {
                target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), 150.0f);
            }
        }
        if (!this.method_37908().field_9236 && ((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue()) {
            if (!this.playedShootSfx) {
                this.playedShootSfx = true;
                class_3414 sound = ModSounds.ARC_SHOOT != null ? ModSounds.ARC_SHOOT : class_3417.field_14880;
                this.method_37908().method_8396(null, this.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.shootingTicks == 60) {
                ApostasyEntity target = this.resolveLockedTarget();
                if (target == null) {
                    target = this.findNearestApostasyUnlimited();
                }
                if (target != null && target.method_5805()) {
                    target.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), 150.0f);
                }
            }
            if (--this.shootingTicks <= 0) {
                this.field_6011.method_12778(SHOOTING, (Object)false);
                this.lockedTarget = null;
            }
        }
    }

    @Nullable
    private ApostasyEntity resolveLockedTarget() {
        if (this.lockedTarget == null) {
            return null;
        }
        List list = this.method_37908().method_8390(ApostasyEntity.class, this.method_5829().method_1014(1000000.0), e -> e.method_5667().equals(this.lockedTarget) && e.method_5805());
        return list.isEmpty() ? null : (ApostasyEntity)((Object)list.getFirst());
    }

    private static float approachAngleDeg(float current, float target) {
        float delta = class_3532.method_15393((float)(target - current));
        if (delta > 6.0f) {
            delta = 6.0f;
        }
        if (delta < -6.0f) {
            delta = -6.0f;
        }
        return current + delta;
    }

    private void updateAimTargets(@Nullable ApostasyEntity t) {
        if (t == null) {
            return;
        }
        class_243 d = t.method_33571().method_1020(this.method_33571());
        this.bodyYawTargetDeg = (float)Math.toDegrees(Math.atan2(-d.field_1352, d.field_1350));
        this.headPitchTargetDeg = (float)(-Math.toDegrees(Math.atan2(d.field_1351, Math.sqrt(d.field_1352 * d.field_1352 + d.field_1350 * d.field_1350))));
    }

    @Nullable
    private ApostasyEntity findNearestApostasyUnlimited() {
        class_238 huge = this.method_5829().method_1014(1000000.0);
        List list = this.method_37908().method_8390(ApostasyEntity.class, huge, class_1309::method_5805);
        return list.stream().min(Comparator.comparingDouble(arg_0 -> ((ArcangelEntity)this).method_5858(arg_0))).orElse(null);
    }

    private <E extends ArcangelEntity> PlayState controller(AnimationState<E> state) {
        if (((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue()) {
            state.setAnimation(SHOOT);
            return PlayState.CONTINUE;
        }
        state.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 0, this::controller));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.field_6012;
    }

    public float getFullBodyYaw() {
        return this.fullBodyYawDeg;
    }

    public float getHeadPitchDeg() {
        return this.headPitchDeg;
    }

    public float getRecoilRad() {
        return this.recoilRad;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.shootingTicks = nbt.method_10550("ShootingTicks");
        this.field_6011.method_12778(SHOOTING, (Object)nbt.method_10577("Shooting"));
        this.field_6011.method_12778(BLOOD, (Object)class_3532.method_15340((int)nbt.method_10550("Blood"), (int)0, (int)100));
        this.playedShootSfx = nbt.method_10577("PlayedShootSfx");
        this.fullBodyYawDeg = nbt.method_10583("FullBodyYawDeg");
        this.headPitchDeg = nbt.method_10583("HeadPitchDeg");
        this.recoilRad = nbt.method_10583("RecoilRad");
        this.bodyYawTargetDeg = nbt.method_10583("BodyYawTargetDeg");
        this.headPitchTargetDeg = nbt.method_10583("HeadPitchTargetDeg");
        this.lockedTarget = nbt.method_25928("LockedTarget") ? nbt.method_25926("LockedTarget") : null;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("ShootingTicks", this.shootingTicks);
        nbt.method_10556("Shooting", ((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue());
        nbt.method_10569("Blood", ((Integer)this.field_6011.method_12789(BLOOD)).intValue());
        nbt.method_10556("PlayedShootSfx", this.playedShootSfx);
        nbt.method_10548("FullBodyYawDeg", this.fullBodyYawDeg);
        nbt.method_10548("HeadPitchDeg", this.headPitchDeg);
        nbt.method_10548("RecoilRad", this.recoilRad);
        nbt.method_10548("BodyYawTargetDeg", this.bodyYawTargetDeg);
        nbt.method_10548("HeadPitchTargetDeg", this.headPitchTargetDeg);
        if (this.lockedTarget != null) {
            nbt.method_25927("LockedTarget", this.lockedTarget);
        }
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public void method_6005(double s, double x, double z) {
    }

    public void method_6091(class_243 in) {
        this.method_18799(class_243.field_1353);
    }

    public boolean method_17326() {
        return true;
    }

    protected boolean method_23734() {
        return false;
    }

    public boolean method_5947() {
        return true;
    }
}

