/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.sentinel;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.kronoz.odyssey.entity.sentinel.SentinelEntity;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class SentinelLightClient {
    private static final float AL_BRIGHTNESS_VISIBLE = 7.5f;
    private static final float AL_BRIGHTNESS_HIDDEN = 2.5f;
    private static final float AL_ANGLE = (float)Math.toRadians(40.0);
    private static final float AL_DISTANCE = 40.0f;
    private static final float AL_SIZE_X = 0.2f;
    private static final float AL_SIZE_Y = 0.2f;
    private static final float PL_BRIGHTNESS_VISIBLE = 7.5f;
    private static final float PL_BRIGHTNESS_HIDDEN = 2.5f;
    private static final float PL_RADIUS = 3.0f;
    private static final float CLR_R = 0.658f;
    private static final float CLR_G = 0.0f;
    private static final float CLR_B = 1.0f;
    private static final float EYE_FORWARD_OFFSET = 0.35f;
    private static final float EYE_UP_OFFSET = 1.2f;
    private static final float EYE_SIDE_OFFSET = 0.0f;
    private static final Int2ObjectOpenHashMap<Pair> HANDLES = new Int2ObjectOpenHashMap();

    private SentinelLightClient() {
    }

    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> SentinelLightClient.reset());
        ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> SentinelLightClient.reset());
        WorldRenderEvents.START.register(ctx -> {
            int id;
            SentinelEntity e2;
            if (!RenderSystem.isOnRenderThread()) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return;
            }
            class_638 w = mc.field_1687;
            if (w == null) {
                SentinelLightClient.reset();
                return;
            }
            if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) {
                return;
            }
            for (SentinelEntity e2 : w.method_8390(SentinelEntity.class, mc.field_1724 != null ? mc.field_1724.method_5829().method_1014(256.0) : null, x -> true)) {
                id = e2.method_5628();
                if (HANDLES.containsKey(id)) continue;
                SentinelLightClient.addFor(e2);
            }
            IntArrayList toRemove = new IntArrayList();
            e2 = HANDLES.keySet().iterator();
            while (e2.hasNext()) {
                id = (Integer)e2.next();
                SentinelEntity e3 = (SentinelEntity)w.method_8469(id);
                if (e3 != null && !e3.method_31481()) continue;
                toRemove.add(id);
            }
            for (int i = 0; i < toRemove.size(); ++i) {
                SentinelLightClient.removeFor(toRemove.getInt(i));
            }
        });
        WorldRenderEvents.BEFORE_ENTITIES.register(ctx -> {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return;
            }
            class_638 w = mc.field_1687;
            if (w == null) {
                return;
            }
            for (SentinelEntity e : w.method_8390(SentinelEntity.class, mc.field_1724 != null ? mc.field_1724.method_5829().method_1014(256.0) : null, x -> true)) {
                float brightnessPL;
                Pair p = (Pair)HANDLES.get(e.method_5628());
                if (p == null) continue;
                float bodyYawRad = (float)Math.toRadians(e.method_36454());
                float eyeYawRadWorld = bodyYawRad + -e.getEyeYaw();
                float eyePitchRadWorld = e.getEyePitch();
                float fx = (float)(Math.cos(eyePitchRadWorld) * -Math.sin(eyeYawRadWorld));
                float fy = (float)Math.sin(eyePitchRadWorld);
                float fz = (float)(Math.cos(eyePitchRadWorld) * Math.cos(eyeYawRadWorld));
                float sx = (float)Math.cos(bodyYawRad);
                float sz = (float)Math.sin(bodyYawRad);
                float px = (float)(-Math.sin(bodyYawRad));
                float pz = (float)Math.cos(bodyYawRad);
                class_243 base = e.method_19538().method_1031(0.0, (double)1.2f, 0.0);
                class_243 eyePos = base.method_1031((double)(px * 0.35f), 0.0, (double)(pz * 0.35f)).method_1031((double)(sx * 0.0f), 0.0, (double)(sz * 0.0f));
                Quaternionf q = new Quaternionf().rotateY(eyeYawRadWorld).rotateX(-eyePitchRadWorld);
                float brightnessAL = e.isSpotted() ? 7.5f : 2.5f;
                float f = brightnessPL = e.isSpotted() ? 7.5f : 2.5f;
                if (p.areaD != null) {
                    p.areaD.setBrightness(brightnessAL).setColor(0.658f, 0.0f, 1.0f).setSize((double)0.2f, (double)0.2f).setAngle(AL_ANGLE).setDistance(40.0f);
                    p.areaD.getPosition().set((double)((float)eyePos.field_1352), (double)((float)eyePos.field_1351), (double)((float)eyePos.field_1350));
                    p.areaD.getOrientation().set((Quaternionfc)q);
                    if (p.areaH != null && p.areaH.isValid()) {
                        p.areaH.markDirty();
                    }
                }
                if (p.pointD == null) continue;
                p.pointD.setBrightness(brightnessPL).setColor(0.658f, 0.0f, 1.0f).setRadius(3.0f);
                p.pointD.setPosition((double)((float)eyePos.field_1352), (double)((float)eyePos.field_1351), (double)((float)eyePos.field_1350));
                if (p.pointH == null || !p.pointH.isValid()) continue;
                p.pointH.markDirty();
            }
        });
    }

    private static void addFor(SentinelEntity e) {
        if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) {
            return;
        }
        Pair p = new Pair();
        AreaLightData al = new AreaLightData().setBrightness(2.5f).setColor(0.658f, 0.0f, 1.0f).setSize((double)0.2f, (double)0.2f).setAngle(AL_ANGLE).setDistance(40.0f);
        LightRenderHandle ah = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)al);
        PointLightData pl = new PointLightData().setBrightness(2.5f).setColor(0.658f, 0.0f, 1.0f).setRadius(3.0f);
        LightRenderHandle ph = VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)pl);
        p.areaD = al;
        p.areaH = ah;
        p.pointD = pl;
        p.pointH = ph;
        HANDLES.put(e.method_5628(), (Object)p);
    }

    private static void removeFor(int id) {
        Pair p = (Pair)HANDLES.remove(id);
        if (p == null) {
            return;
        }
        if (p.areaH != null && p.areaH.isValid()) {
            p.areaH.close();
        }
        if (p.pointH != null && p.pointH.isValid()) {
            p.pointH.close();
        }
    }

    private static void reset() {
        for (Pair p : HANDLES.values()) {
            if (p.areaH != null && p.areaH.isValid()) {
                p.areaH.close();
            }
            if (p.pointH == null || !p.pointH.isValid()) continue;
            p.pointH.close();
        }
        HANDLES.clear();
    }

    private static final class Pair {
        LightRenderHandle<AreaLightData> areaH;
        AreaLightData areaD;
        LightRenderHandle<PointLightData> pointH;
        PointLightData pointD;

        private Pair() {
        }
    }
}

