/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.sentinel;

import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.kronoz.odyssey.entity.sentinel.SentinelEntity;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class SentinelLookGoal
extends class_1352 {
    private final SentinelEntity mob;
    private static final float HEAD_SMOOTH = 0.18f;
    private static final float EYE_SMOOTH = 0.2f;
    private static final float PITCH_DEADZONE = (float)Math.toRadians(1.0);
    private float scanEyeYaw = 0.0f;
    private float scanEyePitch = 0.0f;
    private int scanTicksLeft = 0;

    public SentinelLookGoal(SentinelEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return true;
    }

    public void method_6268() {
        class_1657 p = this.mob.getTrackedPlayer();
        boolean visible = p != null && this.mob.canSeePlayerInCone(p);
        this.mob.setSpotted(visible);
        if (visible && p != null) {
            float curHead;
            class_243 from = this.mob.method_33571();
            class_243 to = p.method_33571().method_1031(0.0, 0.2, 0.0);
            class_243 d = to.method_1020(from);
            double dx = d.field_1352;
            double dy = d.field_1351;
            double dz = d.field_1350;
            double flat = Math.sqrt(dx * dx + dz * dz);
            float targetHeadPitch = (float)Math.atan2(dy, flat);
            float diff = (targetHeadPitch = class_3532.method_15363((float)targetHeadPitch, (float)SentinelEntity.HEAD_PITCH_MIN, (float)SentinelEntity.HEAD_PITCH_MAX)) - (curHead = this.mob.getHeadPitch());
            if (Math.abs(diff) > PITCH_DEADZONE) {
                this.mob.setHeadPitch(curHead + diff * 0.18f);
            }
            float bodyYawDeg = this.mob.method_36454();
            float targetYawDeg = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
            float localYawDeg = class_3532.method_15393((float)(targetYawDeg - bodyYawDeg));
            float eyeYaw = (float)Math.toRadians(localYawDeg);
            eyeYaw = class_3532.method_15363((float)eyeYaw, (float)SentinelEntity.EYE_YAW_MIN, (float)SentinelEntity.EYE_YAW_MAX);
            float eyePitch = (float)Math.atan2(dy, flat);
            eyePitch = class_3532.method_15363((float)eyePitch, (float)SentinelEntity.EYE_PITCH_MIN, (float)SentinelEntity.EYE_PITCH_MAX);
            float curY = this.mob.getEyeYaw();
            float curP = this.mob.getEyePitch();
            this.mob.setEye(curY + (eyeYaw - curY) * 0.2f, curP + (eyePitch - curP) * 0.2f);
            this.scanTicksLeft = 0;
        } else {
            if (this.scanTicksLeft <= 0) {
                ThreadLocalRandom r = ThreadLocalRandom.current();
                float yawRange = (SentinelEntity.EYE_YAW_MAX - SentinelEntity.EYE_YAW_MIN) * 0.6f;
                float pitchRange = (SentinelEntity.EYE_PITCH_MAX - SentinelEntity.EYE_PITCH_MIN) * 0.6f;
                float yawCenter = (SentinelEntity.EYE_YAW_MAX + SentinelEntity.EYE_YAW_MIN) * 0.5f;
                float pitchCenter = (SentinelEntity.EYE_PITCH_MAX + SentinelEntity.EYE_PITCH_MIN) * 0.5f;
                this.scanEyeYaw = yawCenter + (float)((r.nextDouble() - 0.5) * (double)yawRange);
                this.scanEyePitch = pitchCenter + (float)((r.nextDouble() - 0.5) * (double)pitchRange);
                this.scanTicksLeft = r.nextInt(40, 71);
            } else {
                --this.scanTicksLeft;
            }
            float hp = this.mob.getHeadPitch();
            this.mob.setHeadPitch(hp + (0.0f - hp) * 0.12f);
            float curY = this.mob.getEyeYaw();
            float curP = this.mob.getEyePitch();
            this.mob.setEye(curY + (this.scanEyeYaw - curY) * 0.12f, curP + (this.scanEyePitch - curP) * 0.12f);
        }
    }
}

