/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.sentry;

import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.kronoz.odyssey.entity.sentry.SentryEntity;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class SentryLookGoal
extends class_1352 {
    private final SentryEntity mob;
    private static final float HEAD_SMOOTH = 0.18f;
    private static final float EYE_SMOOTH = 0.2f;
    private static final float PITCH_DEADZONE = (float)Math.toRadians(1.0);
    private float scanEyeYaw = 0.0f;
    private float scanEyePitch = 0.0f;
    private int scanTicksLeft = 0;

    public SentryLookGoal(SentryEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return true;
    }

    public void method_6268() {
        class_1657 nearest = this.mob.method_37908().method_18460((class_1297)this.mob, 32.0);
        if (nearest != null && !nearest.method_7325() && !nearest.method_7337()) {
            boolean hasWeakness = nearest.method_6059(class_1294.field_5911);
            this.lookAt(nearest, hasWeakness);
        } else {
            this.scan();
        }
    }

    private void lookAt(class_1657 p, boolean aggressive) {
        float curHead;
        class_243 from = this.mob.method_33571();
        class_243 to = p.method_33571();
        class_243 d = to.method_1020(from);
        double dx = d.field_1352;
        double dy = d.field_1351;
        double dz = d.field_1350;
        double flat = Math.sqrt(dx * dx + dz * dz);
        float targetHeadPitch = (float)Math.atan2(dy, flat);
        float diff = (targetHeadPitch = class_3532.method_15363((float)targetHeadPitch, (float)SentryEntity.HEAD_PITCH_MIN, (float)SentryEntity.HEAD_PITCH_MAX)) - (curHead = this.mob.getHeadPitch());
        if (Math.abs(diff) > PITCH_DEADZONE) {
            this.mob.setHeadPitch(curHead + diff * 0.18f);
        }
        float bodyYawDeg = this.mob.method_36454();
        float targetYawDeg = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        float localYawDeg = class_3532.method_15393((float)(targetYawDeg - bodyYawDeg));
        float eyeYaw = (float)Math.toRadians(localYawDeg);
        eyeYaw = class_3532.method_15363((float)eyeYaw, (float)SentryEntity.EYE_YAW_MIN, (float)SentryEntity.EYE_YAW_MAX);
        float eyePitch = (float)Math.atan2(dy, flat);
        eyePitch = class_3532.method_15363((float)eyePitch, (float)SentryEntity.EYE_PITCH_MIN, (float)SentryEntity.EYE_PITCH_MAX);
        float curY = this.mob.getEyeYaw();
        float curP = this.mob.getEyePitch();
        float s = aggressive ? 0.2f : 0.18f;
        this.mob.setEye(curY + (eyeYaw - curY) * s, curP + (eyePitch - curP) * s);
    }

    private void scan() {
        if (this.scanTicksLeft <= 0) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            float yawRange = (SentryEntity.EYE_YAW_MAX - SentryEntity.EYE_YAW_MIN) * 0.6f;
            float pitchRange = (SentryEntity.EYE_PITCH_MAX - SentryEntity.EYE_PITCH_MIN) * 0.6f;
            float yawCenter = (SentryEntity.EYE_YAW_MAX + SentryEntity.EYE_YAW_MIN) * 0.5f;
            float pitchCenter = (SentryEntity.EYE_PITCH_MAX + SentryEntity.EYE_PITCH_MIN) * 0.5f;
            this.scanEyeYaw = yawCenter + (float)((r.nextDouble() - 0.5) * (double)yawRange);
            this.scanEyePitch = pitchCenter + (float)((r.nextDouble() - 0.5) * (double)pitchRange);
            this.scanTicksLeft = r.nextInt(40, 71);
        } else {
            --this.scanTicksLeft;
        }
        float hp = this.mob.getHeadPitch();
        this.mob.setHeadPitch(hp + (0.0f - hp) * 0.12f);
        float curY = this.mob.getEyeYaw();
        float curP = this.mob.getEyePitch();
        this.mob.setEye(curY + (this.scanEyeYaw - curY) * 0.12f, curP + (this.scanEyePitch - curP) * 0.12f);
    }
}

