/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.entity.thrasher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kronoz.odyssey.entity.thrasher.SliceWave;
import net.kronoz.odyssey.entity.thrasher.ThrasherEntity;
import net.kronoz.odyssey.net.SliceAttackC2SPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class SliceAttackHandler {
    private static final Map<UUID, PlayerHeat> PLAYER_HEAT = new HashMap<UUID, PlayerHeat>();
    private static final List<SliceWave> ACTIVE_WAVES = new ArrayList<SliceWave>();
    private static final float BASE_INCREMENT = 1.0f;
    private static final float SCALING_FACTOR = 0.3f;
    private static final float DECAY_RATE = 0.05f;
    private static final float OVERHEAT_THRESHOLD_BASE = 8.0f;
    private static final float THRESHOLD_RECOVERY = 0.01f;
    private static final float MIN_RESIDUAL_HEAT = 1.0f;

    public static void onSlicePacket(class_3222 player, SliceAttackC2SPayload payload) {
        if (player.method_5854() == null) {
            return;
        }
        class_3218 world = (class_3218)player.method_37908();
        class_243 direction = player.method_5828(1.0f);
        SliceAttackHandler.tryStartSlice(world, (class_1657)player, direction);
    }

    private static void tryStartSlice(class_3218 world, class_1657 player, class_243 direction) {
        UUID id = player.method_5667();
        long now = world.method_8510();
        PlayerHeat heat = PLAYER_HEAT.computeIfAbsent(id, u -> new PlayerHeat());
        if (heat.overheated) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOverheated! Wait for cooldown."), true);
            return;
        }
        float increment = 1.0f * (1.0f + heat.currentHeat / heat.overheatThreshold * 0.3f);
        heat.currentHeat += increment;
        heat.lastClickTick = now;
        if (heat.currentHeat >= heat.overheatThreshold) {
            heat.overheated = true;
            heat.currentHeat = heat.overheatThreshold;
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOVERHEATED!"), true);
            return;
        }
        SliceWave wave = SliceWave.start(world, player, direction);
        ACTIVE_WAVES.add(wave);
        class_1297 ridden = player.method_5854();
        if (ridden instanceof ThrasherEntity) {
            ThrasherEntity thrasher = (ThrasherEntity)ridden;
            thrasher.triggerSliceAnimation();
            thrasher.syncAnimationToClients();
        }
        int sliceNumber = Math.round(heat.currentHeat);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bSlice unleashed! Heat: " + sliceNumber + "/" + Math.round(heat.overheatThreshold))), true);
    }

    public static void registerTickHandler() {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 sw = world;
            Iterator<SliceWave> it = ACTIVE_WAVES.iterator();
            while (it.hasNext()) {
                SliceWave wave = it.next();
                if (wave.tick()) continue;
                it.remove();
            }
            for (PlayerHeat heat : PLAYER_HEAT.values()) {
                if (heat.overheated) {
                    heat.currentHeat -= 0.1f;
                    if (!(heat.currentHeat <= 1.0f)) continue;
                    heat.overheated = false;
                    heat.currentHeat = 1.0f;
                    heat.overheatThreshold = Math.min(8.0f, heat.overheatThreshold + 0.01f);
                    continue;
                }
                heat.currentHeat -= 0.05f;
                if (heat.currentHeat < 1.0f) {
                    heat.currentHeat = 1.0f;
                }
                heat.overheatThreshold = Math.min(8.0f, heat.overheatThreshold + 0.01f);
            }
        });
    }

    private static class PlayerHeat {
        float currentHeat = 0.0f;
        float overheatThreshold = 8.0f;
        boolean overheated = false;
        long lastClickTick = 0L;

        private PlayerHeat() {
        }
    }
}

