/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.hud.death;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

public final class DeathUICutscene
implements HudRenderCallback {
    private static boolean active = false;
    private static long startMs;
    private static boolean hudWasHidden;
    private static boolean savedHudHidden;
    private static final int FRAME_COUNT = 21;
    private static final class_2960[] FRAMES;
    private static final float FADE_WHITE_IN = 2.0f;
    private static final float A_LOOP_DURATION = 3.0f;
    private static final float A_LOOP_PERIOD = 0.08f;
    private static final float TO_BLACK = 1.2f;
    private static final float TO_WHITE = 1.2f;
    private static final float FRAME_DURATION = 0.1f;

    private static float time() {
        return (float)(class_156.method_658() - startMs) / 1000.0f;
    }

    private static float tW1() {
        return 2.0f;
    }

    private static float tA0() {
        return DeathUICutscene.tW1();
    }

    private static float tA1() {
        return DeathUICutscene.tA0() + 3.0f;
    }

    private static float tBLK1() {
        return DeathUICutscene.tA1() + 1.2f;
    }

    private static float tW2() {
        return DeathUICutscene.tBLK1() + 1.2f;
    }

    private static float tSEQ() {
        return DeathUICutscene.tW2() + 1.8000001f;
    }

    private DeathUICutscene() {
    }

    public static void register() {
        HudRenderCallback.EVENT.register((Object)new DeathUICutscene());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!active) {
                return;
            }
            if (client.field_1690 != null) {
                client.field_1690.field_1842 = true;
            }
            if (client.field_1755 != null) {
                client.method_1507(null);
            }
        });
    }

    public static void start() {
        active = true;
        startMs = class_156.method_658();
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1690 != null) {
            if (!savedHudHidden) {
                hudWasHidden = mc.field_1690.field_1842;
                savedHudHidden = true;
            }
            mc.field_1690.field_1842 = true;
            if (mc.field_1755 != null) {
                mc.method_1507(null);
            }
        }
    }

    private static void finish() {
        active = false;
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1690 != null && savedHudHidden) {
            mc.field_1690.field_1842 = hudWasHidden;
        }
        savedHudHidden = false;
        if (mc != null && mc.field_1755 != null) {
            mc.method_1507(null);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public void onHudRender(class_332 ctx, class_9779 renderTickCounter) {
        if (!active) {
            return;
        }
        float t = DeathUICutscene.time();
        int sw = ctx.method_51421();
        int sh = ctx.method_51443();
        if (t <= DeathUICutscene.tW1()) {
            float a = DeathUICutscene.ease(t / 2.0f);
            ctx.method_25294(0, 0, sw, sh, (int)(a * 255.0f) << 24 | 0xFFFFFF);
        } else if (t <= DeathUICutscene.tA1()) {
            ctx.method_25294(0, 0, sw, sh, -1);
            float loopT = t - DeathUICutscene.tA0();
            int toggles = (int)Math.floor(loopT / 0.08f);
            int frame = toggles % 2 == 0 ? 18 : 19;
            DeathUICutscene.drawCentered(ctx, FRAMES[frame], sw, sh, 0.2f);
        } else if (t <= DeathUICutscene.tBLK1()) {
            ctx.method_25294(0, 0, sw, sh, -1);
            float a = DeathUICutscene.ease((t - DeathUICutscene.tA1()) / 1.2f);
            ctx.method_25294(0, 0, sw, sh, (int)(a * 255.0f) << 24);
        } else if (t <= DeathUICutscene.tW2()) {
            ctx.method_25294(0, 0, sw, sh, -16777216);
            float a = DeathUICutscene.ease((t - DeathUICutscene.tBLK1()) / 1.2f);
            ctx.method_25294(0, 0, sw, sh, (int)(a * 255.0f) << 24 | 0xFFFFFF);
        } else if (t <= DeathUICutscene.tSEQ()) {
            ctx.method_25294(0, 0, sw, sh, -1);
            float local = t - DeathUICutscene.tW2();
            int idx = class_3532.method_15340((int)((int)Math.floor(local / 0.1f)), (int)0, (int)17);
            DeathUICutscene.drawCentered(ctx, FRAMES[idx], sw, sh, 0.2f);
        } else {
            DeathUICutscene.finish();
        }
    }

    private static void drawCentered(class_332 ctx, class_2960 tex, int sw, int sh, float baseScale) {
        float base;
        int SRC_W = 256;
        int SRC_H = 80;
        float aspect = 3.2f;
        float desiredH = base = baseScale * (float)Math.min(sw, sh);
        float desiredW = base * 3.2f;
        if (desiredW > (float)sw * 0.75f) {
            desiredW = (float)sw * 0.75f;
            desiredH = desiredW / 3.2f;
        }
        if (desiredH > (float)sh * 0.75f) {
            desiredH = (float)sh * 0.75f;
            desiredW = desiredH * 3.2f;
        }
        int scaleByH = Math.max(1, (int)Math.floor(desiredH / 80.0f));
        int scaleByW = Math.max(1, (int)Math.floor(desiredW / 256.0f));
        int scale = Math.max(1, Math.min(scaleByH, scaleByW));
        int fw = 256 * scale;
        int fh = 80 * scale;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        ctx.method_25290(tex, x, y, 0.0f, 0.0f, fw, fh, fw, fh);
    }

    private static float ease(float x) {
        x = class_3532.method_15363((float)x, (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    static {
        hudWasHidden = false;
        savedHudHidden = false;
        FRAMES = new class_2960[21];
        for (int i = 0; i < 21; ++i) {
            DeathUICutscene.FRAMES[i] = class_2960.method_60655((String)"odyssey", (String)("textures/gui/death/ui_of_death" + i + ".png"));
        }
    }
}

