/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.kronoz.odyssey.cca.BodyModComponent;
import net.kronoz.odyssey.client.cs.CutsceneRecorder;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.kronoz.odyssey.init.ModComponents;
import net.kronoz.odyssey.systems.data.BodyPartRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class ModCommands {
    private static final List<String> EASINGS = List.of("linear", "quad_in", "quad_out", "cubic_inout", "smoothstep", "sine_in", "sine_out", "expo_in", "expo_out", "back_inout", "bounce_out");
    private static final SuggestionProvider<?> EASING_SUGGESTIONS = (context, builder) -> {
        for (String e : EASINGS) {
            builder.suggest(e);
        }
        return builder.buildFuture();
    };

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, env) -> ModCommands.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void register(CommandDispatcher<class_2168> d) {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"csrec").then(ClientCommandManager.literal((String)"origin").then(ClientCommandManager.literal((String)"set").executes(ctx -> {
            CutsceneRecorder.I.setOriginFromPlayer();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Origin set (player position & rotation)."));
            return 1;
        })))).then(ClientCommandManager.literal((String)"key").then(ClientCommandManager.literal((String)"add").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"duration", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            double dur = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"duration");
            CutsceneRecorder.I.addKey(dur, "linear", "linear");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Keyframe added (duration=" + dur + "s, easePos=linear, easeRot=linear).")));
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"easePos", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            double dur = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"duration");
            String ep = StringArgumentType.getString((CommandContext)ctx, (String)"easePos");
            CutsceneRecorder.I.addKey(dur, ep, "linear");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Keyframe added (duration=" + dur + "s, easePos=" + ep + ", easeRot=linear).")));
            return 1;
        })).then(ClientCommandManager.argument((String)"easeRot", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            double dur = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"duration");
            String ep = StringArgumentType.getString((CommandContext)ctx, (String)"easePos");
            String er = StringArgumentType.getString((CommandContext)ctx, (String)"easeRot");
            CutsceneRecorder.I.addKey(dur, ep, er);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Keyframe added (duration=" + dur + "s, easePos=" + ep + ", easeRot=" + er + ").")));
            return 1;
        }))))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            List<CutsceneRecorder.Keyframe> list = CutsceneRecorder.I.list();
            if (list.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No keyframes."));
            } else {
                StringBuilder sb = new StringBuilder("Keyframes:\n");
                for (int i = 0; i < list.size(); ++i) {
                    CutsceneRecorder.Keyframe k = list.get(i);
                    sb.append("#").append(i).append(" dur=").append(k.duration).append(" pos=(").append(String.format("%.3f,%.3f,%.3f", k.rx, k.ry, k.rz)).append(")").append(" rot=(").append(String.format("%.1f,%.1f", Float.valueOf(k.yaw), Float.valueOf(k.pitch))).append(")").append(" easePos=").append(k.easePos).append(" easeRot=").append(k.easeRot).append("\n");
                }
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)sb.toString()));
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"clear").executes(ctx -> {
            CutsceneRecorder.I.clear();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Recorder cleared."));
            return 1;
        }))).then(ClientCommandManager.literal((String)"export").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            try {
                Path path = CutsceneRecorder.I.exportJson(name);
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Exported to: " + String.valueOf(path))));
                return 1;
            }
            catch (Exception e) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("Export failed: " + e.getMessage())));
                return 0;
            }
        })))).then(ClientCommandManager.literal((String)"play").executes(ctx -> {
            CutsceneRecorder.I.startPreview();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Preview started."));
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bodymod").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"slot", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(BodyPartRegistry.all().keySet(), (SuggestionsBuilder)b)).executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            String slot = StringArgumentType.getString((CommandContext)ctx, (String)"slot");
            class_2960 id = class_2232.method_9443((CommandContext)ctx, (String)"id");
            BodyPartRegistry.Part def = BodyPartRegistry.get(id);
            if (def == null) {
                return 0;
            }
            ((BodyModComponent)ModComponents.BODY.get((Object)p)).setPart(slot, id);
            ((BodyModComponent)ModComponents.BODY.get((Object)p)).sync((class_1657)p);
            return 1;
        }))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"slot", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            String slot = StringArgumentType.getString((CommandContext)ctx, (String)"slot");
            ((BodyModComponent)ModComponents.BODY.get((Object)p)).clearSlot(slot);
            ((BodyModComponent)ModComponents.BODY.get((Object)p)).sync((class_1657)p);
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)class_2170.method_9247((String)"deathui").executes(ctx -> {
            DeathUICutscene.start();
            return 1;
        }));
    }
}

