/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.item.custom;

import java.util.UUID;
import net.kronoz.odyssey.systems.physics.wire.WireAnchor;
import net.kronoz.odyssey.systems.physics.wire.WireDef;
import net.kronoz.odyssey.systems.physics.wire.WireManager;
import net.kronoz.odyssey.systems.physics.wire.WireRecord;
import net.kronoz.odyssey.systems.physics.wire.WireSim;
import net.kronoz.odyssey.systems.physics.wire.WireStorage;
import net.kronoz.odyssey.systems.physics.wire.WireToolMath;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class WireCutterItem
extends class_1792 {
    public WireCutterItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(world instanceof class_3218)) {
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        class_3218 sw = (class_3218)world;
        double reach = 6.5;
        class_239 hr = user.method_5745(reach, 1.0f, false);
        class_243 hit = hr.method_17784();
        WireRecord victim = null;
        double bestD = Double.MAX_VALUE;
        for (WireRecord r : WireStorage.get(sw).all()) {
            class_243 a = WireToolMath.anchorCenter(r.a);
            class_243 b = WireToolMath.anchorCenter(r.b);
            double d = WireCutterItem.pointSegmentDistance(hit, a, b);
            double radius = 0.15;
            WireSim sim = WireManager.get(r.id);
            if (sim != null) {
                radius = Math.max(radius, sim.getHalfWidth() * 1.75);
            }
            if (!(d < bestD) || !(d <= radius)) continue;
            bestD = d;
            victim = r;
        }
        if (victim == null) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_243 A = WireToolMath.anchorCenter(victim.a);
        class_243 B = WireToolMath.anchorCenter(victim.b);
        double t = WireCutterItem.clamp01(WireCutterItem.projectParam(hit, A, B));
        class_243 mid = A.method_35590(B, t);
        WireAnchor ghost = WireToolMath.ghostAt(mid);
        UUID id1 = UUID.randomUUID();
        UUID id2 = UUID.randomUUID();
        WireRecord r1 = new WireRecord(id1, victim.defId, victim.a, victim.aPinned, ghost, false);
        WireRecord r2 = new WireRecord(id2, victim.defId, ghost, false, victim.b, victim.bPinned);
        WireStorage st = WireStorage.get(sw);
        st.remove(victim.id);
        st.put(r1);
        st.put(r2);
        class_243 pA = WireToolMath.anchorCenter(r1.a);
        class_243 pG = WireToolMath.anchorCenter(r1.b);
        WireManager.remove(victim.id);
        WireManager.ensure(r1.id, WireDef.defaultCable(victim.defId), pA, pG);
        WireManager.get(r1.id).setPinned(r1.aPinned, r1.bPinned);
        class_243 pG2 = WireToolMath.anchorCenter(r2.a);
        class_243 pB = WireToolMath.anchorCenter(r2.b);
        WireManager.ensure(r2.id, WireDef.defaultCable(victim.defId), pG2, pB);
        WireManager.get(r2.id).setPinned(r2.aPinned, r2.bPinned);
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    private static double clamp01(double x) {
        return x < 0.0 ? 0.0 : (x > 1.0 ? 1.0 : x);
    }

    private static double projectParam(class_243 p, class_243 a, class_243 b) {
        class_243 ab = b.method_1020(a);
        double len2 = ab.method_1027();
        if (len2 < 1.0E-12) {
            return 0.0;
        }
        return p.method_1020(a).method_1026(ab) / len2;
    }

    private static double pointSegmentDistance(class_243 p, class_243 a, class_243 b) {
        double t = WireCutterItem.clamp01(WireCutterItem.projectParam(p, a, b));
        class_243 c = a.method_35590(b, t);
        return p.method_1022(c);
    }
}

