/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cam;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_742;

public final class CameraSway {
    private static final float GAIT_HZ = 0.4f;
    private static final double GAIT_STEP_PER_TICK = 0.12566370801612686;
    private static final int RESET_AFTER_IDLE_TICKS = 8;
    private static final float GAIT_ROLL_MAX_DEG = 4.2f;
    private static final float GAIT_SPEED_TO_AMPL = 0.26f;
    private static final float GAIT_SIDE_WEIGHT = 0.85f;
    private static final float GAIT_AIR_DAMP = 0.35f;
    private static final float PITCH_FACTOR = 13.0f;
    private static final float ROLL_FACTOR = 18.0f;
    private static final float PITCH_CLAMP = 3.6f;
    private static final float ROLL_CLAMP = 7.0f;
    private static final float JUMP_PITCH_KICK = -2.4f;
    private static final float LAND_PITCH_KICK = 3.2f;
    private static final float JUMP_ROLL_KICK = 1.1f;
    private static final float LAND_ROLL_KICK = -1.3f;
    private static final float J_DAMP = 0.86f;
    private static final float LOOK_SMOOTH_ALPHA = 0.2f;
    private static final float LOOK_DEADZONE_DPS = 10.0f;
    private static final float LOOK_MAX_DPS = 1080.0f;
    private static final float LOOK_ROLL_GAIN = 0.024f;
    private static final float LOOK_PITCH_GAIN = 0.018f;
    private static final float EASE_PITCH_FREQ = 5.0f;
    private static final float EASE_ROLL_FREQ = 5.0f;
    private static final float EASE_ZETA = 0.7f;
    private static final float DT = 0.05f;
    private static final Map<Integer, State> STATES = new HashMap<Integer, State>();
    private static int pruneTicker = 0;

    private static State st(class_1297 e) {
        return STATES.computeIfAbsent(e.method_5628(), k -> new State());
    }

    public static void update(class_1297 e, float tickDelta) {
        boolean movingHoriz;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || e == null) {
            return;
        }
        if ((++pruneTicker & 0x4F) == 0) {
            HashSet<Integer> keep = new HashSet<Integer>();
            for (class_742 p : mc.field_1687.method_18456()) {
                keep.add(p.method_5628());
            }
            STATES.keySet().removeIf(id -> !keep.contains(id));
        }
        State s = CameraSway.st(e);
        long tick = mc.field_1687.method_8510();
        if (tick == s.lastTick) {
            return;
        }
        s.lastTick = tick;
        class_243 v = e.method_18798();
        double speedXZ = Math.sqrt(v.field_1352 * v.field_1352 + v.field_1350 * v.field_1350);
        class_243 lookPrevTick = e.method_5828(0.0f);
        class_243 fwd2D = new class_243(lookPrevTick.field_1352, 0.0, lookPrevTick.field_1350);
        fwd2D = fwd2D.method_1027() < 1.0E-6 ? new class_243(0.0, 0.0, 1.0) : fwd2D.method_1029();
        class_243 right = new class_243(-fwd2D.field_1350, 0.0, fwd2D.field_1352);
        float forward = (float)v.method_1026(fwd2D);
        float strafe = (float)v.method_1026(right);
        float yawNow = e.method_36454();
        float pitchNow = e.method_36455();
        if (Float.isNaN(s.lastYawSnap)) {
            s.lastYawSnap = yawNow;
        }
        if (Float.isNaN(s.lastPitchSnap)) {
            s.lastPitchSnap = pitchNow;
        }
        float dYawDeg = class_3532.method_15393((float)(yawNow - s.lastYawSnap));
        float dPitchDeg = class_3532.method_15393((float)(pitchNow - s.lastPitchSnap));
        s.lastYawSnap = yawNow;
        s.lastPitchSnap = pitchNow;
        float yawDpsRaw = class_3532.method_15363((float)(dYawDeg * 20.0f), (float)-1080.0f, (float)1080.0f);
        float pitchDpsRaw = class_3532.method_15363((float)(dPitchDeg * 20.0f), (float)-1080.0f, (float)1080.0f);
        s.lsYawDps += 0.2f * (yawDpsRaw - s.lsYawDps);
        s.lsPitchDps += 0.2f * (pitchDpsRaw - s.lsPitchDps);
        float yawAtten = CameraSway.softDeadzoneAtten(Math.abs(s.lsYawDps), 10.0f);
        float pitchAtten = CameraSway.softDeadzoneAtten(Math.abs(s.lsPitchDps), 10.0f);
        float lookRoll = -(s.lsYawDps * yawAtten) * 0.024f;
        float lookPitch = -(s.lsPitchDps * pitchAtten) * 0.018f;
        float sprintBoost = e.method_5624() ? 1.2f : 1.0f;
        float p_base = -forward * 13.0f * sprintBoost + lookPitch;
        float r_base = strafe * 18.0f * sprintBoost + lookRoll;
        boolean onGround = e.method_24828();
        boolean bl = movingHoriz = speedXZ > (double)0.01f;
        if (movingHoriz && onGround) {
            s.idleTicks = 0;
            s.gaitPhase += 0.12566370801612686;
            if (s.gaitPhase >= Math.PI * 2) {
                s.gaitPhase -= Math.PI * 2;
            }
        } else {
            ++s.idleTicks;
            if (s.idleTicks >= 8) {
                s.gaitPhase = 0.0;
                s.idleTicks = 8;
            }
        }
        float speedBps = (float)(speedXZ * 20.0);
        float ampl01 = class_3532.method_15363((float)(speedBps * 0.26f), (float)0.0f, (float)1.0f);
        float moveSum = Math.abs(forward) + Math.abs(strafe);
        float dirW = moveSum < 1.0E-4f ? 0.0f : (Math.abs(forward) + 0.85f * Math.abs(strafe)) / moveSum;
        float gaitAmpDeg = 4.2f * ampl01 * dirW * (onGround ? 1.0f : 0.35f);
        float s1 = (float)Math.sin(s.gaitPhase);
        float s2 = (float)Math.sin(2.0 * s.gaitPhase) * 0.12f;
        float r_gait = (s1 + s2) * gaitAmpDeg;
        if (s.wasOnGround && !onGround) {
            s.jumpPitch += -2.4f;
            s.jumpRoll += 1.1f * Math.signum(strafe + 1.0E-6f);
        }
        if (!s.wasOnGround && onGround) {
            s.jumpPitch += 3.2f;
            s.jumpRoll += -1.3f * Math.signum(strafe + 1.0E-6f);
        }
        s.wasOnGround = onGround;
        s.jumpPitch *= 0.86f;
        s.jumpRoll *= 0.86f;
        float pitchTarget = p_base + s.jumpPitch;
        float rollTarget = r_base + r_gait + s.jumpRoll;
        pitchTarget = class_3532.method_15363((float)pitchTarget, (float)-3.6f, (float)3.6f);
        rollTarget = class_3532.method_15363((float)rollTarget, (float)-7.0f, (float)7.0f);
        float[] easedP = CameraSway.springStep(s.easedPitch, s.easedPitchVel, pitchTarget, 5.0f, 0.7f, 0.05f);
        s.easedPitch = easedP[0];
        s.easedPitchVel = easedP[1];
        float[] easedR = CameraSway.springStep(s.easedRoll, s.easedRollVel, rollTarget, 5.0f, 0.7f, 0.05f);
        s.easedRoll = easedR[0];
        s.easedRollVel = easedR[1];
        s.outPitchDeg = s.easedPitch;
        s.outRollDeg = s.easedRoll;
        s.outActive = Math.abs(s.outPitchDeg) > 0.02f || Math.abs(s.outRollDeg) > 0.02f;
    }

    private static float[] springStep(float x, float v, float target, float omega, float zeta, float dt) {
        float ax = -2.0f * zeta * omega * v - omega * omega * (x - target);
        return new float[]{x += (v += ax * dt) * dt, v};
    }

    private static float softDeadzoneAtten(float value, float deadzone) {
        if (value <= deadzone) {
            return 0.0f;
        }
        float t = class_3532.method_15363((float)((value - deadzone) / deadzone), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    public static float getPitchDegFor(class_1297 e) {
        return e == null ? 0.0f : CameraSway.st((class_1297)e).outPitchDeg;
    }

    public static float getRollDegFor(class_1297 e) {
        return e == null ? 0.0f : CameraSway.st((class_1297)e).outRollDeg;
    }

    public static boolean isActiveFor(class_1297 e) {
        return e != null && CameraSway.st((class_1297)e).outActive;
    }

    public static float getPitchDeg() {
        class_310 mc = class_310.method_1551();
        return mc == null ? 0.0f : CameraSway.getPitchDegFor(mc.method_1560());
    }

    public static float getRollDeg() {
        class_310 mc = class_310.method_1551();
        return mc == null ? 0.0f : CameraSway.getRollDegFor(mc.method_1560());
    }

    public static boolean isActive() {
        class_310 mc = class_310.method_1551();
        return mc != null && CameraSway.isActiveFor(mc.method_1560());
    }

    public static void reset() {
        STATES.clear();
        pruneTicker = 0;
    }

    private CameraSway() {
    }

    private static final class State {
        long lastTick = Long.MIN_VALUE;
        float outPitchDeg = 0.0f;
        float outRollDeg = 0.0f;
        boolean outActive = false;
        double gaitPhase = 0.0;
        int idleTicks = 0;
        boolean wasOnGround = true;
        float lastYawSnap = Float.NaN;
        float lastPitchSnap = Float.NaN;
        float lsYawDps = 0.0f;
        float lsPitchDps = 0.0f;
        float jumpPitch = 0.0f;
        float jumpRoll = 0.0f;
        float easedPitch = 0.0f;
        float easedPitchVel = 0.0f;
        float easedRoll = 0.0f;
        float easedRollVel = 0.0f;

        private State() {
        }
    }
}

