/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cam;

import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public final class RapidShake {
    private static final class_5819 RNG = class_5819.method_43047();
    private static boolean enabled = false;
    private static float baseIntensity = 0.6f;
    private static float freqHz = 12.0f;
    private static float maxHoriz = 0.1f;
    private static float maxVert = 0.02f;
    private static float maxRollDeg = 1.0f;
    private static float snappiness = 0.55f;
    private static float outSmooth = 0.3f;
    private static long lastWorldTick = Long.MIN_VALUE;
    private static int sampleTicks = 1;
    private static int sampleCountdown = 0;
    private static float tgtX = 0.0f;
    private static float curX = 0.0f;
    private static float tgtY = 0.0f;
    private static float curY = 0.0f;
    private static float tgtR = 0.0f;
    private static float curR = 0.0f;
    private static float outX = 0.0f;
    private static float outY = 0.0f;
    private static float outR = 0.0f;
    private static boolean active = false;
    private static float pulseIntensity = 0.0f;
    private static int pulseTicksLeft = 0;
    private static int baseTicksLeft = 0;

    public static void enable(boolean on) {
        enabled = on;
    }

    public static void configure(float baseIntensity01, float hz, float maxHorizBlocks, float maxVertBlocks, float maxRollDegrees, float snappiness01) {
        baseIntensity = class_3532.method_15363((float)baseIntensity01, (float)0.0f, (float)1.0f);
        freqHz = class_3532.method_15363((float)hz, (float)1.0f, (float)60.0f);
        maxHoriz = Math.max(0.0f, maxHorizBlocks);
        maxVert = Math.max(0.0f, maxVertBlocks);
        maxRollDeg = Math.max(0.0f, maxRollDegrees);
        snappiness = class_3532.method_15363((float)snappiness01, (float)0.05f, (float)0.95f);
        sampleTicks = Math.max(1, Math.round(20.0f / freqHz));
        sampleCountdown = 0;
    }

    public static void setOutputSmoothing(float smooth01) {
        outSmooth = class_3532.method_15363((float)smooth01, (float)0.0f, (float)0.95f);
    }

    public static void pulse(float addIntensity01, int durationTicks) {
        pulseIntensity = Math.max(pulseIntensity, class_3532.method_15363((float)addIntensity01, (float)0.0f, (float)1.0f));
        pulseTicksLeft = Math.max(pulseTicksLeft, Math.max(1, durationTicks));
    }

    public static void update() {
        float eff;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            RapidShake.reset();
            return;
        }
        long wt = mc.field_1687.method_8510();
        if (wt == lastWorldTick) {
            return;
        }
        lastWorldTick = wt;
        if (pulseTicksLeft > 0 && --pulseTicksLeft <= 0) {
            pulseIntensity = 0.0f;
        }
        float f = eff = enabled ? class_3532.method_15363((float)(baseIntensity + pulseIntensity), (float)0.0f, (float)1.0f) : 0.0f;
        if (baseTicksLeft > 0 && --baseTicksLeft == 0) {
            baseIntensity = 0.0f;
        }
        if (eff <= 0.0f) {
            curX = RapidShake.lerp(curX, 0.0f, 0.6f);
            curY = RapidShake.lerp(curY, 0.0f, 0.6f);
            curR = RapidShake.lerp(curR, 0.0f, 0.6f);
            outX = RapidShake.lerp(outX, 0.0f, 0.5f);
            outY = RapidShake.lerp(outY, 0.0f, 0.5f);
            outR = RapidShake.lerp(outR, 0.0f, 0.5f);
            active = Math.abs(outX) > 8.0E-4f || Math.abs(outY) > 8.0E-4f || Math.abs(outR) > 0.02f;
            return;
        }
        if (--sampleCountdown <= 0) {
            sampleCountdown = sampleTicks;
            float dirX = RNG.method_43057() * 2.0f - 1.0f;
            float dirY = RNG.method_43057() * 2.0f - 1.0f;
            float len = Math.max(1.0E-5f, class_3532.method_15355((float)(dirX * dirX + dirY * dirY)));
            float mag = 0.5f + 0.5f * RNG.method_43057();
            tgtX = (dirX /= len) * (maxHoriz * eff * mag);
            tgtY = (dirY /= len) * (maxVert * eff * mag);
            tgtR = (RNG.method_43057() * 2.0f - 1.0f) * (maxRollDeg * eff * 0.85f);
        }
        curX = RapidShake.lerp(curX, tgtX, snappiness);
        curY = RapidShake.lerp(curY, tgtY, snappiness);
        curR = RapidShake.lerp(curR, tgtR, snappiness);
        outX = RapidShake.lerp(outX, curX, outSmooth);
        outY = RapidShake.lerp(outY, curY, outSmooth);
        outR = RapidShake.lerp(outR, curR, outSmooth);
        outX = class_3532.method_15363((float)outX, (float)(-maxHoriz), (float)maxHoriz);
        outY = class_3532.method_15363((float)outY, (float)(-maxVert), (float)maxVert);
        outR = class_3532.method_15363((float)outR, (float)(-maxRollDeg), (float)maxRollDeg);
        active = Math.abs(outX) > 8.0E-4f || Math.abs(outY) > 8.0E-4f || Math.abs(outR) > 0.02f;
    }

    public static void enableTimed(float intensity01, int durationTicks) {
        RapidShake.enable(true);
        baseIntensity = class_3532.method_15363((float)intensity01, (float)0.0f, (float)1.0f);
        baseTicksLeft = Math.max(1, durationTicks);
    }

    public static boolean isActive() {
        return active;
    }

    public static float getX() {
        return outX;
    }

    public static float getY() {
        return outY;
    }

    public static float getRollDeg() {
        return outR;
    }

    public static void reset() {
        lastWorldTick = Long.MIN_VALUE;
        sampleCountdown = 0;
        tgtR = 0.0f;
        tgtY = 0.0f;
        tgtX = 0.0f;
        curR = 0.0f;
        curY = 0.0f;
        curX = 0.0f;
        outR = 0.0f;
        outY = 0.0f;
        outX = 0.0f;
        pulseIntensity = 0.0f;
        pulseTicksLeft = 0;
        active = false;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private RapidShake() {
    }
}

