/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cam;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public final class ScreenShake {
    private static final class_5819 RNG = class_5819.method_43047();
    private static long lastWorldTick = Long.MIN_VALUE;
    private static float outX = 0.0f;
    private static float outY = 0.0f;
    private static float outRollDeg = 0.0f;
    private static boolean active = false;
    private static float rollDeg = 0.0f;
    private static float rollVel = 0.0f;
    private static final float POS_X_MAX_PER_INTENSITY = 0.1f;
    private static final float POS_Y_MAX_PER_INTENSITY = 0.015f;
    private static final float ROLL_MAX_PER_INTENSITY = 1.2f;
    private static final float OUT_SMOOTH = 0.35f;
    private static final float ROLL_VEL_DAMP = 0.88f;
    private static final float ROLL_POS_DAMP = 0.9f;
    private static final List<Kick> KICKS = new ArrayList<Kick>(4);

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static void update() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            ScreenShake.reset();
            return;
        }
        long wt = mc.field_1687.method_8510();
        if (wt == lastWorldTick) {
            return;
        }
        lastWorldTick = wt;
        Accumulator acc = new Accumulator();
        Iterator<Kick> it = KICKS.iterator();
        while (it.hasNext()) {
            if (it.next().tickAndAccumulate(acc)) continue;
            it.remove();
        }
        rollDeg += (rollVel *= 0.88f);
        rollDeg *= 0.9f;
        if (Math.abs(rollDeg = class_3532.method_15363((float)rollDeg, (float)-6.0f, (float)6.0f)) < 0.01f && Math.abs(rollVel) < 0.01f) {
            rollDeg = 0.0f;
            rollVel = 0.0f;
        }
        outX = class_3532.method_16439((float)0.35f, (float)outX, (float)acc.sumX);
        outY = class_3532.method_16439((float)0.35f, (float)outY, (float)acc.sumY);
        outRollDeg = class_3532.method_16439((float)0.35f, (float)outRollDeg, (float)(acc.sumRoll + rollDeg));
        active = Math.abs(outX) > 0.001f || Math.abs(outY) > 0.001f || Math.abs(outRollDeg) > 0.02f;
    }

    public static void kick(float intensity, int durationTicks) {
        KICKS.add(new Kick(intensity, durationTicks));
    }

    public static void kick(float intensity, int durationTicks, float rollImpulseDeg) {
        KICKS.add(new Kick(intensity, durationTicks));
        rollVel += rollImpulseDeg * 0.35f;
    }

    public static void kickFromEvent(double distanceSq, double radius, float minIntensity, float maxIntensity, int minTicks, int maxTicks, float maxRollImpulseDeg) {
        double r2 = radius * radius;
        if (distanceSq > r2) {
            return;
        }
        double d = Math.sqrt(distanceSq);
        float t = (float)(1.0 - d / radius);
        float intensity = class_3532.method_16439((float)t, (float)minIntensity, (float)maxIntensity);
        int dur = class_3532.method_15375((float)class_3532.method_48781((float)t, (int)minTicks, (int)maxTicks));
        float roll = (RNG.method_43056() ? 1.0f : -1.0f) * (maxRollImpulseDeg * t);
        ScreenShake.kick(intensity, Math.max(2, dur), roll);
    }

    public static boolean isShaking() {
        return active;
    }

    public static float getShakeX() {
        return outX;
    }

    public static float getShakeY() {
        return outY;
    }

    public static float getRollDeg() {
        return outRollDeg;
    }

    public static void reset() {
        lastWorldTick = Long.MIN_VALUE;
        KICKS.clear();
        outRollDeg = 0.0f;
        outY = 0.0f;
        outX = 0.0f;
        rollVel = 0.0f;
        rollDeg = 0.0f;
        active = false;
    }

    private ScreenShake() {
    }

    private static final class Accumulator {
        float sumX;
        float sumY;
        float sumRoll;

        private Accumulator() {
        }
    }

    private static final class Kick {
        int totalTicks;
        int leftTicks;
        float curX = 0.0f;
        float tgtX = 0.0f;
        float curY = 0.0f;
        float tgtY = 0.0f;
        float curR = 0.0f;
        float tgtR = 0.0f;
        final float alphaX;
        final float alphaY;
        final float alphaR;
        int sampleEveryTicks;
        int sampleCountdown;
        final float intensity;
        final float posScaleX;
        final float posScaleY;
        final float rollScale;

        Kick(float intensity, int durationTicks) {
            this.leftTicks = this.totalTicks = Math.max(2, durationTicks);
            this.intensity = class_3532.method_15363((float)intensity, (float)0.0f, (float)2.0f);
            this.posScaleX = 0.1f;
            this.posScaleY = 0.015f;
            this.rollScale = 1.2f;
            this.sampleEveryTicks = 2 + RNG.method_43048(3);
            this.sampleCountdown = 0;
            this.alphaX = 0.45f;
            this.alphaY = 0.35f;
            this.alphaR = 0.35f;
            this.reseedTargets();
            this.curX = this.tgtX * 0.6f;
            this.curY = this.tgtY * 0.6f;
            this.curR = this.tgtR * 0.6f;
        }

        private void reseedTargets() {
            this.tgtX = RNG.method_43057() * 2.0f - 1.0f;
            this.tgtY = (RNG.method_43057() * 2.0f - 1.0f) * 0.5f;
            this.tgtR = (RNG.method_43057() * 2.0f - 1.0f) * 0.6f;
        }

        boolean tickAndAccumulate(Accumulator acc) {
            if (this.leftTicks <= 0) {
                return false;
            }
            --this.leftTicks;
            float prog = 1.0f - (float)this.leftTicks / (float)this.totalTicks;
            float env = (float)Math.sin((double)prog * Math.PI);
            if (--this.sampleCountdown <= 0) {
                this.sampleCountdown = this.sampleEveryTicks;
                this.reseedTargets();
            }
            this.curX = ScreenShake.lerp(this.curX, this.tgtX, this.alphaX);
            this.curY = ScreenShake.lerp(this.curY, this.tgtY, this.alphaY);
            this.curR = ScreenShake.lerp(this.curR, this.tgtR, this.alphaR);
            float a = env * this.intensity;
            acc.sumX += this.curX * (a * this.posScaleX);
            acc.sumY += this.curY * (a * this.posScaleY);
            acc.sumRoll += this.curR * (a * this.rollScale);
            return this.leftTicks > 0;
        }
    }
}

