/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.api;

import java.util.function.BiConsumer;
import net.kronoz.odyssey.systems.cinematics.api.Easing;
import net.kronoz.odyssey.systems.cinematics.api.EasingUtil;

public final class RotationTweener {
    private final float startYaw;
    private final float startPitch;
    private final float endYaw;
    private final float endPitch;
    private final int durationTicks;
    private final Easing easing;
    private int age;

    public RotationTweener(float startYaw, float startPitch, float endYaw, float endPitch, int durationTicks, Easing easing) {
        this.startYaw = startYaw;
        this.startPitch = startPitch;
        this.endYaw = endYaw;
        this.endPitch = endPitch;
        this.durationTicks = Math.max(1, durationTicks);
        this.easing = easing;
        this.age = 0;
    }

    public boolean isDone() {
        return this.age >= this.durationTicks;
    }

    public void tick(BiConsumer<Float, Float> yawPitchSetter) {
        float t = Math.min(1.0f, (float)this.age / (float)this.durationTicks);
        float easedYaw = EasingUtil.easeAngleDeg(this.easing, this.startYaw, this.endYaw, t);
        float easedPitch = EasingUtil.easeAngleDeg(this.easing, this.startPitch, this.endPitch, t);
        yawPitchSetter.accept(Float.valueOf(easedYaw), Float.valueOf(easedPitch));
        ++this.age;
    }
}

