/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.cinematics.runtime;

import java.util.HashMap;
import java.util.Map;
import net.kronoz.odyssey.systems.cinematics.runtime.CameraOverrideController;
import net.kronoz.odyssey.systems.cinematics.runtime.Cutscene;
import net.kronoz.odyssey.systems.cinematics.runtime.CutscenePlayer;
import net.kronoz.odyssey.systems.cinematics.runtime.InputBlocker;
import net.minecraft.class_310;

public final class CutsceneManager {
    public static final CutsceneManager I = new CutsceneManager();
    private final Map<String, Cutscene> scenes = new HashMap<String, Cutscene>();
    private CutscenePlayer current;
    private String currentId = "";

    private CutsceneManager() {
    }

    public void register(Cutscene cs) {
        this.scenes.put(cs.id(), cs);
    }

    public boolean play(String id) {
        Cutscene cs = this.scenes.get(id);
        if (cs == null) {
            return false;
        }
        this.stop();
        InputBlocker.apply(cs.lockHud(), cs.lockInput());
        this.current = new CutscenePlayer(cs);
        this.currentId = id;
        this.current.play();
        return true;
    }

    public boolean setSpeed(double mult) {
        if (this.current == null) {
            return false;
        }
        this.current.setSpeed(mult);
        return true;
    }

    public void stop() {
        if (this.current != null) {
            boolean restore = this.scenes.getOrDefault(this.currentId, new Cutscene("", null, 0.0, true, true, true, Cutscene.CameraMode.ADDITIVE_FOLLOW, false)).restoreOnEnd();
            this.current.stop();
            this.current = null;
            this.currentId = "";
            CameraOverrideController.I.clear();
            if (restore) {
                InputBlocker.release();
            }
        } else {
            InputBlocker.release();
            CameraOverrideController.I.clear();
        }
    }

    public void clientTick() {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        if (this.current == null) {
            return;
        }
        Cutscene cs = this.scenes.get(this.currentId);
        if (cs != null) {
            InputBlocker.apply(cs.lockHud(), cs.lockInput());
        }
        double dtSec = (double)mc.method_60646().method_60636() / 20.0;
        this.current.tick(dtSec);
        if (!this.current.isPlaying()) {
            this.stop();
        }
    }
}

