/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.dialogue.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.kronoz.odyssey.systems.dialogue.data.DialogueChoice;
import net.kronoz.odyssey.systems.dialogue.data.DialogueLine;

public record DialogueNode(String key, List<DialogueLine> lines, List<DialogueChoice> choices, boolean allowMulti) {
    public static DialogueNode fromJson(JsonObject obj, String key) {
        ArrayList<DialogueLine> lines = new ArrayList<DialogueLine>();
        JsonArray arr = obj.getAsJsonArray("lines");
        if (arr != null) {
            for (int i = 0; i < arr.size(); ++i) {
                lines.add(DialogueLine.fromJson(arr.get(i).getAsJsonObject()));
            }
        }
        ArrayList<DialogueChoice> choices = new ArrayList<DialogueChoice>();
        JsonArray carr = obj.getAsJsonArray("choices");
        if (carr != null) {
            for (int i = 0; i < carr.size(); ++i) {
                choices.add(DialogueChoice.fromJson(carr.get(i).getAsJsonObject()));
            }
        }
        boolean multi = obj.has("allow_multi") && obj.get("allow_multi").getAsBoolean();
        return new DialogueNode(key, lines, choices, multi);
    }
}

