/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class JetpackSmokeField {
    private static final int FULL_BRIGHT = 0xF000F0;
    private static final int OVERLAY = class_4608.field_21444;
    private static final double CURL_EPS = 0.25;
    private static final double SAMPLE_STEP = 0.1;
    private final Random rng = new Random(2810142445L);
    public final Settings cfg;
    private final Node[] nodes;
    private int alive = 0;
    private int nextDead = 0;
    private double emitAcc = 0.0;

    public JetpackSmokeField(Settings s) {
        this.cfg = s;
        this.nodes = new Node[s.capacity];
        for (int i = 0; i < s.capacity; ++i) {
            this.nodes[i] = Node.dead();
        }
    }

    public void burst(double particles, class_243 pos, class_243 dir) {
        this.emitAcc += particles;
        while (this.emitAcc >= 1.0 && this.alive < this.nodes.length) {
            int start = this.nextDead;
            do {
                Node n = this.nodes[this.nextDead];
                if (!n.alive) {
                    this.spawnInto(n, pos, dir);
                    ++this.alive;
                    this.emitAcc -= 1.0;
                    this.nextDead = (this.nextDead + 1) % this.nodes.length;
                    break;
                }
                this.nextDead = (this.nextDead + 1) % this.nodes.length;
            } while (this.nextDead != start);
            if (start != this.nextDead) continue;
            break;
        }
    }

    private void spawnInto(Node n, class_243 origin, class_243 dir) {
        class_243 jetDir = JetpackSmokeField.sampleCone(dir.method_1029(), this.cfg.coneAngleRad);
        class_243 jitter = new class_243((this.rng.nextDouble() * 2.0 - 1.0) * this.cfg.spawnJitter, (this.rng.nextDouble() * 2.0 - 1.0) * this.cfg.spawnJitter, (this.rng.nextDouble() * 2.0 - 1.0) * this.cfg.spawnJitter);
        n.p = origin.method_1019(jitter);
        double sp = this.cfg.speedMin + this.rng.nextDouble() * (this.cfg.speedMax - this.cfg.speedMin);
        n.v = jetDir.method_1021(sp);
        n.life = this.cfg.lifeMin + this.rng.nextDouble() * (this.cfg.lifeMax - this.cfg.lifeMin);
        n.age = 0.0;
        n.size = this.cfg.sizeMin + this.rng.nextDouble() * (this.cfg.sizeMax - this.cfg.sizeMin);
        n.yaw = (float)(this.rng.nextDouble() * Math.PI * 2.0);
        n.pitch = (float)((this.rng.nextDouble() - 0.5) * 0.6);
        n.roll = (float)((this.rng.nextDouble() - 0.5) * 0.6);
        n.yawVel = (float)((this.rng.nextDouble() - 0.5) * 3.0);
        n.pitchVel = (float)((this.rng.nextDouble() - 0.5) * 3.0);
        n.rollVel = (float)((this.rng.nextDouble() - 0.5) * 3.0);
        n.alive = true;
    }

    public void update(double dt, class_1937 world, long time, class_243 attractUp) {
        if (dt <= 0.0) {
            return;
        }
        double t = (double)time * 0.02;
        for (int i = 0; i < this.nodes.length; ++i) {
            Node n = this.nodes[i];
            if (!n.alive) continue;
            n.age += dt;
            if (n.age >= n.life * this.cfg.linger) {
                n.alive = false;
                --this.alive;
                continue;
            }
            if (n.p.method_1025(class_243.field_1353) > this.cfg.worldRadius * this.cfg.worldRadius * 16.0) {
                n.alive = false;
                --this.alive;
                continue;
            }
            class_243 curl = this.curl3(n.p.field_1352 * 0.45 + t * 0.09 + (double)i * 0.0017, n.p.field_1351 * 0.45 + t * 0.09 + (double)i * 0.0021, n.p.field_1350 * 0.45 + t * 0.09 + (double)i * 0.0013).method_1021(this.cfg.curlForce);
            class_243 up = attractUp.method_1021(this.cfg.rise);
            class_243 g = new class_243(0.0, this.cfg.gravity, 0.0);
            n.v = n.v.method_1019(curl.method_1021(dt)).method_1019(up.method_1021(dt)).method_1019(g.method_1021(dt));
            n.v = new class_243(n.v.field_1352 * this.cfg.lateralVisc, n.v.field_1351 * this.cfg.drag, n.v.field_1350 * this.cfg.lateralVisc);
            class_243 next = n.p.method_1019(n.v.method_1021(dt));
            n.p = this.collideWorld(n.p, next, world);
            n.yaw = (float)((double)n.yaw + (double)n.yawVel * dt);
            n.yawVel = (float)((double)n.yawVel * 0.98);
            n.pitch = (float)((double)n.pitch + (double)n.pitchVel * dt);
            n.pitchVel = (float)((double)n.pitchVel * 0.98);
            n.roll = (float)((double)n.roll + (double)n.rollVel * dt);
            n.rollVel = (float)((double)n.rollVel * 0.98);
        }
    }

    public void render(class_4587 ms, class_4588 vc, class_243 camBase, float tickDelta, class_1937 world) {
        Matrix4f m4 = ms.method_23760().method_23761();
        for (Node n : this.nodes) {
            double lt;
            float a;
            if (!n.alive || camBase.method_1025(n.p) > this.cfg.lodCull * this.cfg.lodCull || (a = JetpackSmokeField.alphaOverLife((float)(lt = class_3532.method_15350((double)(n.age / n.life), (double)0.0, (double)this.cfg.linger)))) < 0.01f) continue;
            float hs = (float)n.size * 0.5f;
            float cx = (float)(n.p.field_1352 - camBase.field_1352);
            float cy = (float)(n.p.field_1351 - camBase.field_1351);
            float cz = (float)(n.p.field_1350 - camBase.field_1350);
            float cyw = (float)Math.cos(n.yaw);
            float syw = (float)Math.sin(n.yaw);
            float cpi = (float)Math.cos(n.pitch);
            float spi = (float)Math.sin(n.pitch);
            float cro = (float)Math.cos(n.roll);
            float sro = (float)Math.sin(n.roll);
            Vector3f X = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f Y = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f Z = new Vector3f(0.0f, 0.0f, 1.0f);
            X = new Vector3f(cyw * X.x - syw * X.z, X.y, syw * X.x + cyw * X.z);
            Y = new Vector3f(cyw * Y.x - syw * Y.z, Y.y, syw * Y.x + cyw * Y.z);
            Z = new Vector3f(cyw * Z.x - syw * Z.z, Z.y, syw * Z.x + cyw * Z.z);
            X = new Vector3f(X.x, cpi * X.y - spi * X.z, spi * X.y + cpi * X.z);
            Y = new Vector3f(Y.x, cpi * Y.y - spi * Y.z, spi * Y.y + cpi * Y.z);
            Z = new Vector3f(Z.x, cpi * Z.y - spi * Z.z, spi * Z.y + cpi * Z.z);
            X = new Vector3f(cro * X.x - sro * X.y, sro * X.x + cro * X.y, X.z);
            Y = new Vector3f(cro * Y.x - sro * Y.y, sro * Y.x + cro * Y.y, Y.z);
            Z = new Vector3f(cro * Z.x - sro * Z.y, sro * Z.x + cro * Z.y, Z.z);
            Vector3f RX = new Vector3f((Vector3fc)X).mul(hs);
            Vector3f RY = new Vector3f((Vector3fc)Y).mul(hs);
            Vector3f RZ = new Vector3f((Vector3fc)Z).mul(hs);
            float[] col = JetpackSmokeField.colorOverLife((float)lt);
            float r = col[0];
            float g = col[1];
            float b = col[2];
            Vector3f C = new Vector3f(cx, cy, cz);
            Vector3f p000 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p100 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p110 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p010 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).sub((Vector3fc)RZ);
            Vector3f p001 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p101 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).sub((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p111 = new Vector3f((Vector3fc)C).add((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            Vector3f p011 = new Vector3f((Vector3fc)C).sub((Vector3fc)RX).add((Vector3fc)RY).add((Vector3fc)RZ);
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p100, p101, p111, p110, X);
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p000, p010, p011, p001, new Vector3f((Vector3fc)X).negate());
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p010, p110, p111, p011, Y);
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p000, p001, p101, p100, new Vector3f((Vector3fc)Y).negate());
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p101, p001, p011, p111, Z);
            this.putQuad(m4, ms, vc, r, g, b, a, 0.0f, 1.0f, 1.0f, 0.0f, p100, p110, p010, p000, new Vector3f((Vector3fc)Z).negate());
        }
    }

    private static float smooth(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : Math.min(1.0f, v);
    }

    private static float[] colorOverLife(float t) {
        float len = 1.0f;
        float k0 = JetpackSmokeField.clamp01(t / 0.15f);
        float k1 = JetpackSmokeField.clamp01((t - 0.15f) / 0.35f);
        float k2 = JetpackSmokeField.clamp01((t - 0.5f) / (len - 0.5f));
        float r0 = 1.0f;
        float g0 = 0.78f;
        float b0 = 0.15f;
        float r1 = 0.6f;
        float g1 = 0.25f;
        float b1 = 0.9f;
        float r2 = 0.62f;
        float g2 = 0.62f;
        float b2 = 0.62f;
        float rA = r0 + (r1 - r0) * JetpackSmokeField.smooth(k1);
        float gA = g0 + (g1 - g0) * JetpackSmokeField.smooth(k1);
        float bA = b0 + (b1 - b0) * JetpackSmokeField.smooth(k1);
        float r = rA + (r2 - rA) * JetpackSmokeField.smooth(k2);
        float g = gA + (g2 - gA) * JetpackSmokeField.smooth(k2);
        float b = bA + (b2 - bA) * JetpackSmokeField.smooth(k2);
        return new float[]{r, g, b};
    }

    private static float alphaOverLife(float t) {
        float rise = JetpackSmokeField.clamp01(t / 0.12f);
        float fade = JetpackSmokeField.clamp01(1.0f - (float)Math.pow(Math.max(0.0f, t - 0.5f) / 0.5f, 1.1));
        return 0.1f + 0.9f * rise * fade;
    }

    private void putQuad(Matrix4f m4, class_4587 ms, class_4588 vc, float r, float g, float b, float a, float u0, float v1, float u1, float v0, Vector3f P0, Vector3f P1, Vector3f P2, Vector3f P3, Vector3f N) {
        int nx = (int)Math.signum(N.x());
        int ny = (int)Math.signum(N.y());
        int nz = (int)Math.signum(N.z());
        vc.method_22918(m4, P0.x, P0.y, P0.z).method_22915(r, g, b, a).method_22913(u0, v1).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P1.x, P1.y, P1.z).method_22915(r, g, b, a).method_22913(u1, v1).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P2.x, P2.y, P2.z).method_22915(r, g, b, a).method_22913(u1, v0).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
        vc.method_22918(m4, P3.x, P3.y, P3.z).method_22915(r, g, b, a).method_22913(u0, v0).method_22922(OVERLAY).method_60803(0xF000F0).method_60831(ms.method_23760(), (float)nx, (float)ny, (float)nz);
    }

    private class_243 collideWorld(class_243 cur, class_243 next, class_1937 world) {
        class_243 delta = next.method_1020(cur);
        int steps = Math.max(1, (int)Math.ceil(delta.method_1033() / 0.1));
        class_243 p = cur;
        for (int i = 1; i <= steps; ++i) {
            class_265 sh;
            double t = (double)i / (double)steps;
            class_243 probe = cur.method_35590(next, t);
            class_2338 bp = class_2338.method_49638((class_2374)probe);
            if (!world.method_22340(bp)) {
                p = probe;
                continue;
            }
            class_2680 st = world.method_8320(bp);
            if (!st.method_26215() && !(sh = st.method_26220((class_1922)world, bp)).method_1110()) {
                class_243 back = cur.method_35590(next, Math.max(0.0, t - 0.1));
                class_2350 face = JetpackSmokeField.nearestFace(probe, bp);
                class_243 nrm = new class_243((double)face.method_23955().x(), (double)face.method_23955().y(), (double)face.method_23955().z());
                class_243 slide = JetpackSmokeField.projectOntoPlane(next.method_1020(back), nrm).method_1021(this.cfg.collideSlide);
                return back.method_1019(slide).method_1019(nrm.method_1021(0.008));
            }
            p = probe;
        }
        return p;
    }

    private static class_243 projectOntoPlane(class_243 v, class_243 n) {
        double dot = v.field_1352 * n.field_1352 + v.field_1351 * n.field_1351 + v.field_1350 * n.field_1350;
        return new class_243(v.field_1352 - dot * n.field_1352, v.field_1351 - dot * n.field_1351, v.field_1350 - dot * n.field_1350);
    }

    private static class_2350 nearestFace(class_243 p, class_2338 bp) {
        double cx = (double)bp.method_10263() + 0.5;
        double cy = (double)bp.method_10264() + 0.5;
        double cz = (double)bp.method_10260() + 0.5;
        double dx = p.field_1352 - cx;
        double dy = p.field_1351 - cy;
        double dz = p.field_1350 - cz;
        double ax = Math.abs(dx);
        double ay = Math.abs(dy);
        double az = Math.abs(dz);
        if (ay >= ax && ay >= az) {
            return dy > 0.0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        if (ax >= az) {
            return dx > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        return dz > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    private static class_243 sampleCone(class_243 baseDir, double ang) {
        double u = Math.random();
        double v = Math.random();
        double theta = Math.PI * 2 * u;
        double cosAng = Math.cos(ang);
        double z = cosAng + (1.0 - cosAng) * v;
        double s = Math.sqrt(Math.max(0.0, 1.0 - z * z));
        class_243 local = new class_243(s * Math.cos(theta), z, s * Math.sin(theta));
        class_243 a = Math.abs(baseDir.field_1352) < 0.9 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 t1 = baseDir.method_1036(a).method_1029();
        class_243 t2 = t1.method_1036(baseDir).method_1029();
        return t1.method_1021(local.field_1352).method_1019(baseDir.method_1021(local.field_1351)).method_1019(t2.method_1021(local.field_1350)).method_1029();
    }

    private class_243 curl3(double x, double y, double z) {
        double e = 0.25;
        double Ny_z1 = this.noise3(x, y, z + e);
        double Ny_z0 = this.noise3(x, y, z - e);
        double Nz_y1 = this.noise3(x, y + e, z);
        double Nz_y0 = this.noise3(x, y - e, z);
        double Nz_x1 = this.noise3(x + e, y, z);
        double Nz_x0 = this.noise3(x - e, y, z);
        double Nx_z1 = this.noise3(x, y, z + e);
        double Nx_z0 = this.noise3(x, y, z - e);
        double Nx_y1 = this.noise3(x, y + e, z);
        double Nx_y0 = this.noise3(x, y - e, z);
        double Ny_x1 = this.noise3(x + e, y, z);
        double Ny_x0 = this.noise3(x - e, y, z);
        double cx = Nz_y1 - Nz_y0 - (Ny_z1 - Ny_z0);
        double cy = Nx_z1 - Nx_z0 - (Nz_x1 - Nz_x0);
        double cz = Ny_x1 - Ny_x0 - (Nx_y1 - Nx_y0);
        double L = Math.sqrt(cx * cx + cy * cy + cz * cz) + 1.0E-9;
        return new class_243(cx / L, cy / L, cz / L);
    }

    private static int fastFloor(double x) {
        int i = (int)x;
        return x < (double)i ? i - 1 : i;
    }

    private static double s(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    private static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static double hash(int x, int y, int z) {
        long v = (long)x * 374761393L + (long)y * 668265263L + (long)z * 700001L;
        v = (v ^ v >> 13) * 1274126177L;
        v ^= v >> 16;
        return (double)(v & 0xFFFFFFFFL) / 4.294967296E9;
    }

    private double noise3(double x, double y, double z) {
        int xi = JetpackSmokeField.fastFloor(x);
        int yi = JetpackSmokeField.fastFloor(y);
        int zi = JetpackSmokeField.fastFloor(z);
        double xf = x - (double)xi;
        double yf = y - (double)yi;
        double zf = z - (double)zi;
        double u = JetpackSmokeField.s(xf);
        double v = JetpackSmokeField.s(yf);
        double w = JetpackSmokeField.s(zf);
        double n000 = JetpackSmokeField.hash(xi, yi, zi);
        double n100 = JetpackSmokeField.hash(xi + 1, yi, zi);
        double n010 = JetpackSmokeField.hash(xi, yi + 1, zi);
        double n110 = JetpackSmokeField.hash(xi + 1, yi + 1, zi);
        double n001 = JetpackSmokeField.hash(xi, yi, zi + 1);
        double n101 = JetpackSmokeField.hash(xi + 1, yi, zi + 1);
        double n011 = JetpackSmokeField.hash(xi, yi + 1, zi + 1);
        double n111 = JetpackSmokeField.hash(xi + 1, yi + 1, zi + 1);
        double x00 = JetpackSmokeField.lerp(u, n000, n100);
        double x10 = JetpackSmokeField.lerp(u, n010, n110);
        double x01 = JetpackSmokeField.lerp(u, n001, n101);
        double x11 = JetpackSmokeField.lerp(u, n011, n111);
        double y0 = JetpackSmokeField.lerp(v, x00, x10);
        double y1 = JetpackSmokeField.lerp(v, x01, x11);
        return JetpackSmokeField.lerp(w, y0, y1) * 2.0 - 1.0;
    }

    public static final class Settings {
        public int capacity = 900;
        public double emitPerSecond = 480.0;
        public double lifeMin = 0.8;
        public double lifeMax = 2.0;
        public double sizeMin = 0.045;
        public double sizeMax = 0.085;
        public double speedMin = 0.9;
        public double speedMax = 2.2;
        public double drag = 0.92;
        public double lateralVisc = 0.96;
        public double curlForce = 1.35;
        public double gravity = -0.02;
        public double rise = 0.22;
        public double linger = 1.3;
        public double collideSlide = 0.75;
        public double coneAngleRad = Math.toRadians(16.0);
        public double spawnJitter = 0.04;
        public double worldRadius = 48.0;
        public double lodCull = 96.0;
    }

    private static final class Node {
        boolean alive;
        class_243 p;
        class_243 v;
        float yaw;
        float pitch;
        float roll;
        float yawVel;
        float pitchVel;
        float rollVel;
        double age;
        double life;
        double size;

        private Node() {
        }

        static Node dead() {
            Node n = new Node();
            n.alive = false;
            n.p = class_243.field_1353;
            n.v = class_243.field_1353;
            return n;
        }
    }
}

