/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kronoz.odyssey.systems.physics.jetpack.OdysseySmokeField;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class JetpackSmokeSystem {
    private static final class_2960 WHITE = class_2960.method_60655((String)"minecraft", (String)"textures/misc/white.png");
    private static final class_1921 LAYER = class_1921.method_23580((class_2960)WHITE);
    private static final Map<String, Emitter> EMITTERS = new LinkedHashMap<String, Emitter>();
    private static final double MAX_FPS = 120.0;
    private static final long MIN_STEP_NS = 8333333L;
    private static final double IDLE_TIMEOUT_S = 2.0;
    private static final double DIE_AFTER_S = 8.0;

    private JetpackSmokeSystem() {
    }

    public static void emit(String emitterId, class_243 originWS, class_243 axisWS) {
        long now = System.nanoTime();
        Emitter e = EMITTERS.get(emitterId);
        if (e == null) {
            e = new Emitter();
            e.field = new OdysseySmokeField(500);
            EMITTERS.put(emitterId, e);
        }
        e.lastEmitWorldPos = originWS;
        e.axisWS = axisWS;
        e.lastSeenNs = now;
        e.emitting = true;
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        long now = System.nanoTime();
        double worldTime = mc.field_1687.method_8510();
        Iterator<Map.Entry<String, Emitter>> it = EMITTERS.entrySet().iterator();
        while (it.hasNext()) {
            boolean tooOld;
            boolean recentlySeen;
            Emitter em = it.next().getValue();
            if (em.lastStepNs == 0L) {
                em.lastStepNs = now;
                continue;
            }
            long elapsed = now - em.lastStepNs;
            if (elapsed < 8333333L) continue;
            double dt = Math.min((double)elapsed / 1.0E9, 0.05);
            em.lastStepNs = now;
            em.emitting = recentlySeen = now - em.lastSeenNs < 2000000000L;
            if (em.emitting && em.lastEmitWorldPos != null && em.axisWS != null) {
                em.field.setEmitting(true);
                em.field.setAxis(em.axisWS);
                em.field.update(dt, em.lastEmitWorldPos, (class_1937)mc.field_1687, (long)worldTime);
            } else {
                em.field.setEmitting(false);
                if (em.lastEmitWorldPos != null) {
                    em.field.update(dt, em.lastEmitWorldPos, (class_1937)mc.field_1687, (long)worldTime);
                }
            }
            boolean empty = em.field.isEmpty();
            boolean bl = tooOld = now - em.lastSeenNs > 8000000000L;
            if (!empty || !tooOld) continue;
            it.remove();
        }
    }

    public static void renderAll(class_4587 ms, class_4597 vcp, float tickDelta) {
        if (EMITTERS.isEmpty()) {
            return;
        }
        class_4588 vc = vcp.getBuffer(LAYER);
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        for (Emitter e : EMITTERS.values()) {
            e.field.render(ms, vc, cam, tickDelta);
        }
    }

    private static final class Emitter {
        OdysseySmokeField field;
        class_243 lastEmitWorldPos;
        class_243 axisWS;
        long lastStepNs;
        long lastSeenNs;
        boolean emitting;

        private Emitter() {
        }
    }
}

