/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.lightning;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_243;

public class BoltBuilder {
    public static class_243[] buildMainPathLocalFractal(double totalLen, int depth, double roughness, Random rng) {
        class_243 top = new class_243(0.0, totalLen * 0.85, 0.0);
        class_243 bot = new class_243(0.0, 0.0, 0.0);
        List<class_243> pts = new ArrayList<class_243>();
        pts.add(top);
        pts.add(bot);
        for (int i = 0; i < depth; ++i) {
            ArrayList<class_243> next = new ArrayList<class_243>(pts.size() * 2);
            double amp = roughness * totalLen * Math.pow(0.5, i + 1);
            for (int s = 0; s < pts.size() - 1; ++s) {
                class_243 a = pts.get(s);
                class_243 b = pts.get(s + 1);
                class_243 mid = a.method_1019(b).method_1021(0.5);
                double jx = (rng.nextDouble() - 0.5) * amp;
                double jz = (rng.nextDouble() - 0.5) * amp;
                double jy = -rng.nextDouble() * (amp * 0.2);
                mid = mid.method_1031(jx, jy, jz);
                next.add(a);
                next.add(mid);
            }
            next.add(pts.get(pts.size() - 1));
            pts = next;
        }
        pts = BoltBuilder.smoothOnce(pts);
        return (class_243[])pts.toArray(class_243[]::new);
    }

    private static List<class_243> smoothOnce(List<class_243> p) {
        if (p.size() <= 2) {
            return p;
        }
        ArrayList<class_243> out = new ArrayList<class_243>(p.size());
        out.add(p.get(0));
        for (int i = 1; i < p.size() - 1; ++i) {
            class_243 a = p.get(i - 1);
            class_243 b = p.get(i);
            class_243 c = p.get(i + 1);
            class_243 s = a.method_1021(0.25).method_1019(b.method_1021(0.5)).method_1019(c.method_1021(0.25));
            out.add(s);
        }
        out.add(p.get(p.size() - 1));
        return out;
    }

    public static Branch[] buildBranchesLocal(class_243[] spine, int count, Random rng) {
        if (spine.length < 4) {
            return new Branch[0];
        }
        Branch[] out = new Branch[count];
        for (int i = 0; i < count; ++i) {
            int anchor = 1 + rng.nextInt(spine.length - 2);
            class_243 start = spine[anchor];
            double len = 10.5 + rng.nextDouble() * 3.0;
            double dx = (rng.nextDouble() - 0.5) * 1.2;
            double dz = (rng.nextDouble() - 0.5) * 1.2;
            double dy = -0.2 - rng.nextDouble() * 0.8;
            class_243 end = start.method_1031(dx * len, dy * len, dz * len);
            int depth = 1 + rng.nextInt(10);
            ArrayList<class_243> pts = new ArrayList<class_243>();
            pts.add(start);
            pts.add(end);
            for (int d = 0; d < depth; ++d) {
                ArrayList<class_243> next = new ArrayList<class_243>(pts.size() * 2);
                double amp = len * 0.4 * Math.pow(0.5, d + 1);
                for (int s = 0; s < pts.size() - 1; ++s) {
                    class_243 a = (class_243)pts.get(s);
                    class_243 b = (class_243)pts.get(s + 1);
                    class_243 m = a.method_1019(b).method_1021(0.5).method_1031((rng.nextDouble() - 0.5) * amp, (rng.nextDouble() - 0.5) * amp * 0.5, (rng.nextDouble() - 0.5) * amp);
                    next.add(a);
                    next.add(m);
                }
                next.add((class_243)pts.get(pts.size() - 1));
                pts = next;
            }
            out[i] = new Branch((class_243[])pts.toArray(class_243[]::new));
        }
        return out;
    }

    public record Branch(class_243[] points) {
    }
}

