/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.wire;

import net.kronoz.odyssey.systems.physics.wire.WireDef;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;

public final class WireSim {
    private final double halfWidth;
    private final WireDef def;
    private final Node[] nodes;
    private double targetLen;
    private boolean pinStart = true;
    private boolean pinEnd = true;
    private static final double CONTACT_SLOP = 0.0015;
    private static final double BAUMGARTE = 0.34;
    private static final double DYN_FRICTION = 0.3;

    public WireSim(WireDef def, class_243 a, class_243 b, double halfWidth) {
        this.def = def;
        this.nodes = new Node[def.segments + 1];
        for (int i = 0; i < this.nodes.length; ++i) {
            double t = (double)i / (double)(this.nodes.length - 1);
            this.nodes[i] = new Node(a.method_35590(b, t), 1.0f);
        }
        this.setEndpoints(a, b);
        double MIN_SCALE = 0.65;
        double scale = 0.65 + 0.35 * Math.random();
        this.halfWidth = Math.max(1.0E-6, (double)def.halfWidth * scale);
    }

    public void setPinned(boolean startPinned, boolean endPinned) {
        this.pinStart = startPinned;
        this.pinEnd = endPinned;
        this.nodes[0].invM = startPinned ? 0.0f : 1.0f;
        this.nodes[this.nodes.length - 1].invM = endPinned ? 0.0f : 1.0f;
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public void setEndpoints(class_243 a, class_243 b) {
        double base = Math.max(1.0E-5, a.method_1022(b));
        double slack = (double)this.def.baseSlack + (double)this.def.sagPerMeter * base;
        this.targetLen = base * (1.0 + slack);
        if (this.pinStart) {
            this.nodes[0].p = a;
            this.nodes[0].prev = a;
        }
        if (this.pinEnd) {
            int i = this.nodes.length - 1;
            this.nodes[i].p = b;
            this.nodes[i].prev = b;
        }
    }

    public Node[] nodes() {
        return this.nodes;
    }

    public void step(class_1937 world, class_243 a, class_243 b) {
        this.setEndpoints(a, b);
        double maxMove = 0.0;
        for (Node n : this.nodes) {
            double L2 = n.p.method_1020(n.prev).method_1027();
            if (!(L2 > maxMove)) continue;
            maxMove = L2;
        }
        double move = Math.sqrt(maxMove);
        int extra = move > (double)this.def.halfWidth * 0.6 ? 2 : 0;
        int totalSub = Math.min(6, this.def.substeps + extra);
        float h = 1.0f / (float)totalSub;
        for (int s = 0; s < totalSub; ++s) {
            this.integrate(h);
            for (int k = 0; k < this.def.iters; ++k) {
                this.distanceConstraints();
                this.lengthConstraint();
                this.bendSmoothing(this.def.bendK);
                if (this.pinStart) {
                    this.nodes[0].p = a;
                }
                if (!this.pinEnd) continue;
                this.nodes[this.nodes.length - 1].p = b;
            }
            this.collideBlocks(world);
        }
    }

    private void integrate(float dt) {
        double g = this.def.gravity * dt * dt;
        double damp = Math.min(0.98, (double)this.def.damping);
        for (Node n : this.nodes) {
            if (n.invM == 0.0f) continue;
            class_243 cur = n.p;
            class_243 v = cur.method_1020(n.prev).method_1021(1.0 - damp);
            n.prev = cur;
            n.p = cur.method_1031(v.field_1352, v.field_1351 - g, v.field_1350);
        }
    }

    private void distanceConstraints() {
        double segLen = this.targetLen / (double)(this.nodes.length - 1);
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            Node a = this.nodes[i];
            Node b = this.nodes[i + 1];
            class_243 d = b.p.method_1020(a.p);
            double L = d.method_1033();
            if (L <= 1.0E-9) continue;
            double diff = (L - segLen) / L;
            float wa = a.invM;
            float wb = b.invM;
            float ws = wa + wb;
            if (ws == 0.0f) continue;
            class_243 corr = d.method_1021(0.5 * diff);
            if (wa > 0.0f) {
                a.p = a.p.method_1019(corr.method_1021((double)(wa / ws * 2.0f)));
            }
            if (!(wb > 0.0f)) continue;
            b.p = b.p.method_1019(corr.method_1021((double)(-wb / ws * 2.0f)));
        }
    }

    private void lengthConstraint() {
        double total = 0.0;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            total += this.nodes[i].p.method_1022(this.nodes[i + 1].p);
        }
        if (total < 1.0E-9) {
            return;
        }
        double scale = this.targetLen / total;
        if (Math.abs(scale - 1.0) < 1.0E-6) {
            return;
        }
        class_243 s = this.nodes[0].p;
        class_243 e = this.nodes[this.nodes.length - 1].p;
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            Node n = this.nodes[i];
            if (n.invM == 0.0f) continue;
            double t = (double)i / (double)(this.nodes.length - 1);
            class_243 tgt = s.method_35590(e, t);
            class_243 cur = n.p;
            n.p = tgt.method_1019(cur.method_1020(tgt).method_1021(scale));
        }
    }

    private void bendSmoothing(float k) {
        if (k <= 0.0f) {
            return;
        }
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            Node a = this.nodes[i - 1];
            Node b = this.nodes[i];
            Node c = this.nodes[i + 1];
            if (b.invM == 0.0f) continue;
            class_243 mid = a.p.method_1019(c.p).method_1021(0.5);
            b.p = b.p.method_1021(1.0 - (double)k).method_1019(mid.method_1021((double)k));
        }
    }

    private void collideBlocks(class_1937 world) {
        if (world == null) {
            return;
        }
        double r = Math.max(0.008, (double)this.def.halfWidth * 0.95);
        for (int pass = 0; pass < this.def.collidePasses; ++pass) {
            for (Node n : this.nodes) {
                if (n.invM == 0.0f) continue;
                class_2338 base = class_2338.method_49638((class_2374)n.p);
                for (int by = -1; by <= 1; ++by) {
                    for (int bx = -1; bx <= 1; ++bx) {
                        for (int bz = -1; bz <= 1; ++bz) {
                            class_265 shape;
                            class_2338 p = base.method_10069(bx, by, bz);
                            class_2680 state = world.method_8320(p);
                            if (state.method_26215() || (shape = state.method_26194((class_1922)world, p, class_3726.method_16194())).method_1110()) continue;
                            WireSim.iterateShapeBoxes(shape, p, (ax0, ay0, az0, ax1, ay1, az1) -> this.resolve(n, ax0, ay0, az0, ax1, ay1, az1, r));
                        }
                    }
                }
            }
        }
    }

    private static void iterateShapeBoxes(class_265 shape, class_2338 pos, BoxConsumer consumer) {
        boolean success = false;
        try {
            shape.method_1089((x0, y0, z0, x1, y1, z1) -> consumer.accept((double)pos.method_10263() + x0, (double)pos.method_10264() + y0, (double)pos.method_10260() + z0, (double)pos.method_10263() + x1, (double)pos.method_10264() + y1, (double)pos.method_10260() + z1));
            success = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!success) {
            try {
                for (class_238 local : shape.method_1090()) {
                    class_238 bb = local.method_996(pos);
                    consumer.accept(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void resolve(Node n, double ax0, double ay0, double az0, double ax1, double ay1, double az1, double r) {
        double pen;
        double dist;
        boolean embedded;
        double cx = WireSim.clamp(n.p.field_1352, ax0, ax1);
        double cy = WireSim.clamp(n.p.field_1351, ay0, ay1);
        double cz = WireSim.clamp(n.p.field_1350, az0, az1);
        double nx = n.p.field_1352 - cx;
        double ny = n.p.field_1351 - cy;
        double nz = n.p.field_1350 - cz;
        double d2 = nx * nx + ny * ny + nz * nz;
        boolean bl = embedded = n.p.field_1352 > ax0 && n.p.field_1352 < ax1 && n.p.field_1351 > ay0 && n.p.field_1351 < ay1 && n.p.field_1350 > az0 && n.p.field_1350 < az1;
        if (d2 < 1.0E-12) {
            nx = 0.0;
            ny = 1.0;
            nz = 0.0;
            d2 = 1.0;
        }
        if ((dist = Math.sqrt(d2)) >= r && !embedded) {
            return;
        }
        double nmx = nx / dist;
        double nmy = ny / dist;
        double nmz = nz / dist;
        double d = pen = embedded ? r : r - dist;
        if (pen <= 0.0015) {
            return;
        }
        double corr = 0.34 * (pen - 0.0015);
        if (embedded) {
            nmx = 0.0;
            nmy = 1.0;
            nmz = 0.0;
            corr = Math.max(corr, r * 0.35);
        }
        n.p = n.p.method_1031(nmx * corr, nmy * corr, nmz * corr);
        class_243 vel = n.p.method_1020(n.prev);
        double vdotn = vel.field_1352 * nmx + vel.field_1351 * nmy + vel.field_1350 * nmz;
        if (vdotn < 0.0) {
            vel = vel.method_1023(nmx * vdotn, nmy * vdotn, nmz * vdotn);
        }
        n.prev = n.p.method_1020(vel.method_1021(0.7));
    }

    private static double clamp(double v, double lo, double hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    public static final class Node {
        public class_243 p;
        public class_243 prev;
        public float invM;

        Node(class_243 v, float inv) {
            this.p = v;
            this.prev = v;
            this.invM = inv;
        }
    }

    @FunctionalInterface
    private static interface BoxConsumer {
        public void accept(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

