/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.systems.physics.wire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.kronoz.odyssey.systems.physics.wire.WireDef;
import net.kronoz.odyssey.systems.physics.wire.WireManager;
import net.kronoz.odyssey.systems.physics.wire.WireSim;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public final class WireToolState {
    private static final List<Entry> WIRES = new ArrayList<Entry>();
    private static final WireDef DEF = WireDef.defaultCable(class_2960.method_60655((String)"odyssey", (String)"textures/effects/wire.png"));
    public static Entry.Pending pending = null;

    private WireToolState() {
    }

    public static void setPending(class_2338 pos, class_2350 face, class_2248 block) {
        pending = new Entry.Pending(pos.method_10062(), face, block);
    }

    public static boolean hasPending() {
        return pending != null;
    }

    public static void clearPending() {
        pending = null;
    }

    public static void spawnWire(class_2338 aPos, class_2350 aFace, class_2248 aBlock, class_2338 bPos, class_2350 bFace, class_2248 bBlock) {
        WIRES.add(new Entry(Anchor.blockFace(aPos, aFace, aBlock), Anchor.blockFace(bPos, bFace, bBlock)));
    }

    public static void renderAll(class_4587 ms, class_4597 buffers, int light) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        double REMOVE_AFTER_SECONDS = 6.0;
        long now = System.currentTimeMillis();
        Iterator<Entry> it = WIRES.iterator();
        while (it.hasNext()) {
            Entry e = it.next();
            boolean aAlive = e.a.isStillSameBlock((class_1937)mc.field_1687);
            boolean bAlive = e.b.isStillSameBlock((class_1937)mc.field_1687);
            class_243 a = e.a.world();
            class_243 b = e.b.world();
            WireManager.ensure(e.id, DEF, a, b);
            WireSim sim = WireManager.get(e.id);
            if (sim != null) {
                sim.setPinned(aAlive, bAlive);
            }
            WireManager.stepAndRender(e.id, a, aAlive, b, bAlive, ms, buffers, light, class_4608.field_21444);
            if (!aAlive || !bAlive) {
                if (e.detachedAt == 0L) {
                    e.detachedAt = now;
                }
                if (aAlive || bAlive || now - e.detachedAt <= 6000L) continue;
                it.remove();
                continue;
            }
            e.detachedAt = 0L;
        }
    }

    public static final class Entry {
        public final UUID id = UUID.randomUUID();
        public final Anchor a;
        public final Anchor b;
        public long detachedAt = 0L;

        public Entry(Anchor a, Anchor b) {
            this.a = a;
            this.b = b;
        }

        public static final class Pending {
            public final class_2338 pos;
            public final class_2350 face;
            public final class_2248 block;

            public Pending(class_2338 pos, class_2350 face, class_2248 block) {
                this.pos = pos;
                this.face = face;
                this.block = block;
            }
        }
    }

    public static final class Anchor {
        final Kind kind;
        final class_243 point;
        final class_2338 pos;
        final class_2350 face;
        final class_2248 originalBlock;

        private Anchor(class_243 p) {
            this.kind = Kind.FREE;
            this.point = p;
            this.pos = null;
            this.face = null;
            this.originalBlock = null;
        }

        private Anchor(class_2338 pos, class_2350 face, class_2248 block) {
            this.kind = Kind.BLOCK_FACE;
            this.pos = pos;
            this.face = face;
            this.originalBlock = block;
            this.point = null;
        }

        public static Anchor free(class_243 p) {
            return new Anchor(p);
        }

        public static Anchor blockFace(class_2338 pos, class_2350 face, class_2248 block) {
            return new Anchor(pos, face, block);
        }

        public boolean isStillSameBlock(class_1937 world) {
            if (this.kind == Kind.FREE) {
                return true;
            }
            return world.method_8320(this.pos).method_26204() == this.originalBlock;
        }

        public class_243 world() {
            if (this.kind == Kind.FREE) {
                return this.point;
            }
            return class_243.method_24953((class_2382)this.pos).method_1031((double)this.face.method_10148() * 0.501, (double)this.face.method_10164() * 0.501, (double)this.face.method_10165() * 0.501);
        }

        static enum Kind {
            FREE,
            BLOCK_FACE;

        }
    }
}

