/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.world;

import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kronoz.odyssey.world.FixedStructurePlacerOverworld;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class FixedStructureCenterSpawn {
    private FixedStructureCenterSpawn() {
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(FixedStructureCenterSpawn::applyWorldSpawnIfSaved);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 p = handler.field_14140;
            FixedStructureCenterSpawn.teleportToSavedCenter(server, p, true);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldP, newP, alive) -> {
            MinecraftServer server = newP.method_5682();
            if (server != null) {
                FixedStructureCenterSpawn.teleportToSavedCenter(server, newP, true);
            }
        });
    }

    private static void applyWorldSpawnIfSaved(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return;
        }
        class_26 psm = overworld.method_17983();
        FixedStructurePlacerOverworld.StructuresPlacedState state = (FixedStructurePlacerOverworld.StructuresPlacedState)psm.method_17924(FixedStructurePlacerOverworld.StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        if (state.hasSpawn()) {
            overworld.method_8554(new class_2338(state.spawnX, state.spawnY, state.spawnZ), 0.0f);
        }
    }

    private static void teleportToSavedCenter(MinecraftServer server, class_3222 player, boolean giveLevitation) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return;
        }
        class_26 psm = overworld.method_17983();
        FixedStructurePlacerOverworld.StructuresPlacedState state = (FixedStructurePlacerOverworld.StructuresPlacedState)psm.method_17924(FixedStructurePlacerOverworld.StructuresPlacedState.TYPE, "odyssey_fixed_structures");
        if (!state.hasSpawn()) {
            return;
        }
        double x = (double)state.spawnX + 0.5;
        double y = (double)state.spawnY + 0.1;
        double z = (double)state.spawnZ + 0.5;
        player.field_6017 = 0.0f;
        player.method_14251(overworld, x, y, z, player.method_36454(), player.method_36455());
        if (giveLevitation) {
            player.method_6092(new class_1293(class_1294.field_5902, 50, 0, false, false));
        }
    }
}

