/*
 * Decompiled with CFR 0.152.
 */
package net.kronoz.odyssey.world;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.slf4j.Logger;

final class HugeNbtPlacer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean DUMPED = false;

    private HugeNbtPlacer() {
    }

    static Optional<class_2487> loadNbt(class_3218 world, class_2960 idBare) {
        class_3300 rm = world.method_8503().method_34864();
        HugeNbtPlacer.dumpOnce(rm);
        List<class_2960> candidates = List.of(class_2960.method_60655((String)idBare.method_12836(), (String)("structure/" + idBare.method_12832() + ".nbt")), class_2960.method_60655((String)idBare.method_12836(), (String)("structures/" + idBare.method_12832() + ".nbt")), class_2960.method_60655((String)idBare.method_12836(), (String)("structure/" + idBare.method_12832())), class_2960.method_60655((String)idBare.method_12836(), (String)("structures/" + idBare.method_12832())));
        for (class_2960 path : candidates) {
            try {
                Optional opt = rm.method_14486(path);
                LogUtils.getLogger().info("[Odyssey] probe {} present={}", (Object)path, (Object)opt.isPresent());
                if (opt.isEmpty()) continue;
                Path tmp = Files.createTempFile("odyssey_tmp_", ".nbt", new FileAttribute[0]);
                try (InputStream in = ((class_3298)opt.get()).method_14482();){
                    Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
                }
                class_2487 nbt = class_2507.method_10633((Path)tmp);
                Files.deleteIfExists(tmp);
                return Optional.of(nbt);
            }
            catch (Exception e) {
                LogUtils.getLogger().warn("[Odyssey] read fail {}: {}", (Object)path, (Object)e.toString());
            }
        }
        return Optional.empty();
    }

    private static void dumpOnce(class_3300 rm) {
        if (DUMPED) {
            return;
        }
        DUMPED = true;
        try {
            Map found = rm.method_14488("structure", id -> id.method_12832().endsWith(".nbt"));
            Map found2 = rm.method_14488("structures", id -> id.method_12832().endsWith(".nbt"));
            LogUtils.getLogger().info("[Odyssey] namespaces={}", (Object)rm.method_14487());
            LogUtils.getLogger().info("[Odyssey] list data/odyssey/structure/*.nbt -> {}", found.keySet());
            LogUtils.getLogger().info("[Odyssey] list data/odyssey/structures/*.nbt -> {}", found2.keySet());
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("[Odyssey] dumpOnce error: {}", (Object)e.toString());
        }
    }

    static Optional<Plan> planFromNbt(class_2487 nbt, class_2338 origin) {
        if (!nbt.method_10573("size", 11)) {
            return Optional.empty();
        }
        int[] sz = nbt.method_10561("size");
        if (sz.length < 3) {
            return Optional.empty();
        }
        class_2382 size = new class_2382(sz[0], sz[1], sz[2]);
        if (!nbt.method_10573("palette", 9)) {
            return Optional.empty();
        }
        class_2499 paletteList = nbt.method_10554("palette", 10);
        ArrayList<class_2680> palette = new ArrayList<class_2680>(paletteList.size());
        for (int i = 0; i < paletteList.size(); ++i) {
            class_2680 st = HugeNbtPlacer.readState(paletteList.method_10602(i));
            if (st == null) {
                st = class_2246.field_10124.method_9564();
            }
            palette.add(st);
        }
        if (!nbt.method_10573("blocks", 9)) {
            return Optional.empty();
        }
        class_2499 blocks = nbt.method_10554("blocks", 10);
        Plan plan = new Plan(size);
        for (int i = 0; i < blocks.size(); ++i) {
            class_2487 be = blocks.method_10602(i);
            int[] pos = be.method_10561("pos");
            if (pos.length < 3) continue;
            int idx = be.method_10550("state");
            class_2680 st = idx >= 0 && idx < palette.size() ? (class_2680)palette.get(idx) : class_2246.field_10124.method_9564();
            class_2338 wp = origin.method_10069(pos[0], pos[1], pos[2]);
            class_1923 c = new class_1923(wp);
            plan.byChunk.computeIfAbsent(c, k -> new ArrayList()).add(new class_3545((Object)wp, (Object)st));
        }
        return Optional.of(plan);
    }

    private static class_2680 readState(class_2487 entry) {
        String name = entry.method_10558("Name");
        if (name == null || name.isEmpty()) {
            return class_2246.field_10124.method_9564();
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)name));
        class_2680 state = block.method_9564();
        if (entry.method_10573("Properties", 10)) {
            class_2487 props = entry.method_10562("Properties");
            for (String key : props.method_10541()) {
                class_2769 prop = state.method_28501().stream().filter(p -> p.method_11899().equals(key)).findFirst().orElse(null);
                if (prop == null) continue;
                String val = props.method_10558(key);
                state = HugeNbtPlacer.withParsed(state, prop, val);
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> class_2680 withParsed(class_2680 state, class_2769<T> prop, String val) {
        Optional parsed = prop.method_11900(val);
        return parsed.map(t -> (class_2680)state.method_11657(prop, t)).orElse(state);
    }

    static void forceChunks(class_3218 world, Plan plan) {
        for (class_1923 c : plan.byChunk.keySet()) {
            world.method_14178().method_12121(c.field_9181, c.field_9180, class_2806.field_12803, true);
        }
    }

    static final class Plan {
        final class_2382 size;
        final Map<class_1923, List<class_3545<class_2338, class_2680>>> byChunk = new HashMap<class_1923, List<class_3545<class_2338, class_2680>>>();

        Plan(class_2382 size) {
            this.size = size;
        }
    }
}

