/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkcwk.darkhud.listener;

import com.github.darkcwk.darkhud.api.Data;
import com.github.darkcwk.darkhud.util.ConfigUtil;
import com.github.darkcwk.darkhud.util.Constant;
import com.github.darkcwk.darkhud.util.DataUtil;
import com.github.darkcwk.darkhud.util.ErrorUtil;
import com.github.darkcwk.darkhud.util.FreemarkerUtil;
import com.github.darkcwk.darkhud.util.HudRenderUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_332;

public enum HudRenderListener implements HudRenderCallback
{
    HUD_RENDER_LISTENER;

    private static final class_310 client;
    private long ltErrorTime = -1L;
    private HudRenderUtil.CalcPositionInfoFn ltFn = (_1, _2, w, h, i) -> new HudRenderUtil.PositionInfo(0, h * i, w, h * (i + 1));
    private long rtErrorTime = -1L;
    private HudRenderUtil.CalcPositionInfoFn rtFn = (ww, _2, w, h, i) -> new HudRenderUtil.PositionInfo(ww - w, h * i, ww, h * (i + 1));
    private long lbErrorTime = -1L;
    private HudRenderUtil.CalcPositionInfoFn lbFn = (_1, wh, w, h, i) -> new HudRenderUtil.PositionInfo(0, wh - h * (i + 1), w, wh - h * i);
    private long rbErrorTime = -1L;
    private HudRenderUtil.CalcPositionInfoFn rbFn = (ww, wh, w, h, i) -> new HudRenderUtil.PositionInfo(ww - w, wh - h * (i + 1), ww, wh - h * i);

    public void onHudRender(class_332 drawContext, float tickDelta) {
        if (HudRenderListener.client.field_1690.field_1866) {
            return;
        }
        Map<String, Data> data = DataUtil.getLatestData();
        if (ConfigUtil.getAsBoolean("lt.enabled")) {
            try {
                if (this.ltErrorTime == -1L || this.ltErrorTime < Constant.LT_FILE_PATH.toFile().lastModified()) {
                    HudRenderUtil.render(FreemarkerUtil.process("lt.ftl", data), drawContext, this.ltFn);
                    this.ltErrorTime = -1L;
                }
            }
            catch (TemplateException | IOException e) {
                ErrorUtil.sendError("\u65e0\u6cd5\u52a0\u8f7d lt.ftl!", e);
                this.ltErrorTime = System.currentTimeMillis();
            }
        }
        if (ConfigUtil.getAsBoolean("rt.enabled")) {
            try {
                if (this.rtErrorTime == -1L || this.rtErrorTime < Constant.RT_FILE_PATH.toFile().lastModified()) {
                    HudRenderUtil.render(FreemarkerUtil.process("rt.ftl", data), drawContext, this.rtFn);
                    this.rtErrorTime = -1L;
                }
            }
            catch (TemplateException | IOException e) {
                ErrorUtil.sendError("\u65e0\u6cd5\u52a0\u8f7d rt.ftl!", e);
                this.rtErrorTime = System.currentTimeMillis();
            }
        }
        if (ConfigUtil.getAsBoolean("lb.enabled")) {
            try {
                if (this.lbErrorTime == -1L || this.lbErrorTime < Constant.LB_FILE_PATH.toFile().lastModified()) {
                    HudRenderUtil.render(FreemarkerUtil.process("lb.ftl", data), drawContext, this.lbFn);
                    this.lbErrorTime = -1L;
                }
            }
            catch (TemplateException | IOException e) {
                ErrorUtil.sendError("\u65e0\u6cd5\u52a0\u8f7d lb.ftl!", e);
                this.lbErrorTime = System.currentTimeMillis();
            }
        }
        if (ConfigUtil.getAsBoolean("rb.enabled")) {
            try {
                if (this.rbErrorTime == -1L || this.rbErrorTime < Constant.RB_FILE_PATH.toFile().lastModified()) {
                    HudRenderUtil.render(FreemarkerUtil.process("rb.ftl", data), drawContext, this.rbFn);
                    this.rbErrorTime = -1L;
                }
            }
            catch (TemplateException | IOException e) {
                ErrorUtil.sendError("\u65e0\u6cd5\u52a0\u8f7d rb.ftl!", e);
                this.rbErrorTime = System.currentTimeMillis();
            }
        }
    }

    static {
        client = class_310.method_1551();
    }
}

