/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkcwk.darkhud.util;

import com.github.darkcwk.darkhud.util.Constant;
import com.github.darkcwk.darkhud.util.ErrorUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;

public class ConfigUtil {
    private static final Properties config;

    public static void setAndSave(String key, String value) throws IOException {
        String originValue = config.getProperty(key);
        config.setProperty(key, value);
        try {
            config.store(Files.newBufferedWriter(Constant.CONFIG_FILE_PATH, new OpenOption[0]), "Darkhud \u914d\u7f6e\u6587\u4ef6");
        }
        catch (IOException e) {
            config.setProperty(key, originValue);
            throw e;
        }
    }

    public static boolean getAsBoolean(String key) {
        return Boolean.parseBoolean(config.getProperty(key));
    }

    static {
        try {
            ErrorUtil.existsFileOrDefault(Constant.CONFIG_FILE_PATH, "default/darkhud.properties");
        }
        catch (IOException e) {
            ErrorUtil.sendErrorWithStop("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6!", e);
        }
        try {
            ErrorUtil.existsFileOrDefault(Constant.LT_FILE_PATH, "default/template/lt.ftl");
            ErrorUtil.existsFileOrDefault(Constant.RT_FILE_PATH, "default/template/rt.ftl");
            ErrorUtil.existsFileOrDefault(Constant.LB_FILE_PATH, "default/template/lb.ftl");
            ErrorUtil.existsFileOrDefault(Constant.RB_FILE_PATH, "default/template/rb.ftl");
        }
        catch (IOException e) {
            ErrorUtil.sendErrorWithStop("\u672a\u627e\u5230\u6a21\u677f\u6587\u4ef6!", e);
        }
        config = new Properties();
        try {
            config.load(Files.newBufferedReader(Constant.CONFIG_FILE_PATH, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            ErrorUtil.sendErrorWithStop("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6!", e);
        }
    }
}

