/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.menu;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ShyMenu
extends AbstractContainerMenu {
    protected final Container container;
    protected final Inventory inv;
    protected final int inventoryX;
    protected final int inventoryY;
    protected final int index;
    final boolean withHotbar;
    public final Player player;

    protected ShyMenu(MenuType<?> type, int id, Inventory inv, Container container, int inventoryX, int inventoryY, boolean withHotbar) {
        super(type, id);
        this.inv = inv;
        this.container = container;
        this.inventoryX = inventoryX;
        this.inventoryY = inventoryY;
        this.withHotbar = withHotbar;
        this.player = inv.player;
        if (withHotbar) {
            this.addPlayerHotbar(inv);
        }
        this.addPlayerInventory(inv);
        this.index = this.slots.size();
    }

    protected void addSlotRange(Container cont, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new Slot(cont, index + i, x + i * dx, y));
        }
    }

    protected void addSlotBox(Container cont, int index, int x, int y, int horAmount, int verAmount, int dx, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(cont, index + j * horAmount, x, y + j * dy, horAmount, dx);
        }
    }

    private void addPlayerInventory(Inventory inv) {
        this.addSlotBox((Container)inv, 9, this.inventoryX, this.inventoryY, 9, 3, 18, 18);
    }

    private void addPlayerHotbar(Inventory inv) {
        this.addSlotRange((Container)inv, 0, this.inventoryX, this.inventoryY + 58, 9, 18);
    }

    public int getContainerSlotCount() {
        return this.slots.size() - this.index;
    }

    public Slot getSlotAt(int index) {
        return index >= 0 && index < this.slots.size() ? (Slot)this.slots.get(index) : null;
    }

    public Slot getContainerSlot(int containerIndex) {
        int absoluteIndex = this.index + containerIndex;
        return absoluteIndex < this.slots.size() ? (Slot)this.slots.get(absoluteIndex) : null;
    }

    public List<Slot> getContainerSlots() {
        return this.slots.subList(this.index, this.slots.size());
    }

    public List<Slot> getPlayerSlots() {
        return this.slots.subList(0, this.index);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack original = slot.getItem();
        ItemStack copy = original.copy();
        if (index >= this.index ? !this.moveToPlayerInventory(original, true) : !this.moveToContainer(original) && (index < 9 ? !this.moveItemStackTo(original, 9, 36, false) : !this.moveItemStackTo(original, 0, 9, false))) {
            return ItemStack.EMPTY;
        }
        if (original.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, original);
        return copy;
    }

    protected boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    protected boolean moveToContainer(ItemStack stack) {
        return this.moveItemStackTo(stack, this.index, this.slots.size(), false);
    }

    protected boolean canInsertIntoContainer(ItemStack stack) {
        return true;
    }

    protected boolean moveItemStackTo(ItemStack stack, int start, int end, boolean reverse) {
        if (start == this.index && end == this.slots.size() && !this.canInsertIntoContainer(stack)) {
            return false;
        }
        return super.moveItemStackTo(stack, start, end, reverse);
    }

    public void clearContainer() {
        for (int i = this.index; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (!slot.hasItem()) continue;
            slot.set(ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        for (int i = this.index; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (!slot.hasItem()) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid(Player player) {
        return this.container == null || this.container.stillValid(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

