/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mw.nullcore.client.particle.GenericParticleOptions;
import com.mw.nullcore.client.particle.data.ColorParticleData;
import com.mw.nullcore.client.particle.data.GenericParticleData;
import com.mw.nullcore.client.particle.data.SpinParticleData;
import com.mw.nullcore.client.particle.data.SpriteParticleData;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.Vec3;

public final class GenericParticle
extends TextureSheetParticle {
    public static final Random random = new Random();
    public RenderType renderType;
    public ParticleRenderType particleRenderType;
    public ColorParticleData colorData;
    public GenericParticleData transparencyData;
    public GenericParticleData scaleData;
    public SpinParticleData spinData;
    public SpriteParticleData spriteData;
    public Collection<Consumer<GenericParticle>> tickActors;
    public Collection<Consumer<GenericParticle>> renderActors;
    public GenericParticleOptions.DiscardFunctionType discardFunctionType;
    public boolean reachedPositiveAlpha;
    public boolean reachedPositiveScale;
    public boolean shouldCull;
    public boolean shouldRenderTraits;
    public ParticleEngine.MutableSpriteSet spriteSet;
    public float st;
    public float mt;
    public float et;
    public float ss;
    public float ms;
    public float es;
    public float sr;
    public float mr;
    public float er;
    public float randomSpin;
    public float uo;
    public float vo;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericParticle(ClientLevel level, GenericParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double z, double vx, double vy, double vz) {
        super(level, x, y, z, vx, vy, vz);
        this.setPos(x, y, z);
        this.colorData = options.colorData;
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.spriteData = options.spriteData;
        this.tickActors = options.tickActors;
        this.renderActors = options.renderActors;
        this.discardFunctionType = options.discardFunctionType;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.setLifetime(options.lifetime + random.nextInt(options.additionalLifetime + 1));
        this.gravity = options.gravity;
        if (options.additionalGravity > 0.0f) {
            this.gravity += random.nextFloat(options.additionalGravity);
        }
        this.friction = options.friction;
        if (options.additionalFriction > 0.0f) {
            this.friction += random.nextFloat(options.additionalFriction);
        }
        this.shouldCull = options.shouldCull;
        this.shouldRenderTraits = options.shouldRenderTraits;
        this.hasPhysics = options.hasPhysics;
        this.spriteSet = spriteSet;
        this.roll = this.spinData.spinOffset + this.spinData.startingValue;
        this.randomSpin = GenericParticle.pickRandomValue(0.0f, this.spinData.rsp1, this.spinData.rsp2);
        if (random.nextBoolean()) {
            this.randomSpin = -this.randomSpin;
        }
        this.roll += GenericParticle.pickRandomRollValue(0.0f, this.spinData.rso1, this.spinData.rso2);
        float r1 = GenericParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        this.st = GenericParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        this.mt = GenericParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        this.et = GenericParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        this.ss = GenericParticle.pickRandomValue(this.scaleData.startingValue, this.scaleData.rs1, this.scaleData.rs2);
        this.ms = GenericParticle.pickRandomValue(this.scaleData.middleValue, this.scaleData.rm1, this.scaleData.rm2);
        this.es = GenericParticle.pickRandomValue(this.scaleData.endingValue, this.scaleData.re1, this.scaleData.re2);
        this.sr = GenericParticle.pickRandomValue(this.spinData.startingValue, this.spinData.rs1, this.spinData.rs2);
        this.mr = GenericParticle.pickRandomValue(this.spinData.middleValue, this.spinData.rm1, this.spinData.rm2);
        this.er = GenericParticle.pickRandomValue(this.spinData.endingValue, this.spinData.re1, this.spinData.re2);
        this.uo = random.nextFloat();
        this.vo = random.nextFloat();
        options.spawnActors.forEach(actor -> actor.accept(this));
        this.updateTraits();
    }

    public static float pickRandomValue(float value, float value1, float value2) {
        if (value1 >= 0.0f && value2 >= 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public static float pickRandomRollValue(float value, float value1, float value2) {
        if (value1 != 0.0f || value2 != 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public void pickColor(float coeff) {
    }

    public void updateTraits() {
        boolean shouldAttemptRemoval;
        this.pickColor(this.colorData.colorCurveEasing.apply(this.colorData.getProgress(this.age, this.lifetime)));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime, this.ss, this.ms, this.es);
        this.alpha = this.transparencyData.getValue(this.age, this.lifetime, this.st, this.mt, this.et);
        this.oRoll = this.roll;
        this.roll = this.roll + this.spinData.getValue(this.age, this.lifetime, this.sr, this.mr, this.er) + this.randomSpin;
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == GenericParticleOptions.DiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == GenericParticleOptions.DiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.age, this.lifetime) > 0.5f || this.transparencyData.getProgress(this.age, this.lifetime) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.alpha <= 0.0f || this.reachedPositiveScale && this.quadSize <= 0.0f)) {
            this.remove();
            return;
        }
        if (!this.reachedPositiveAlpha && this.alpha > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.quadSize > 0.0f) {
            this.reachedPositiveScale = true;
        }
    }

    public void tick() {
        this.updateTraits();
        super.tick();
        this.tickActors.forEach(a -> a.accept(this));
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        if (this.shouldRenderTraits) {
            this.updateRenderTraits(partialTicks);
        }
        this.renderActors.forEach(actor -> actor.accept(this));
    }

    public void updateRenderTraits(float partialTicks) {
        float time = (float)this.age + partialTicks;
        this.pickColor(this.colorData.colorCurveEasing.apply(this.colorData.getProgress(time, this.lifetime)));
        this.quadSize = this.scaleData.getValue(time, this.lifetime, this.ss, this.ms, this.es);
        this.alpha = this.transparencyData.getValue(time, this.lifetime, this.st, this.mt, this.et);
    }

    public ParticleRenderType getRenderType() {
        return this.particleRenderType;
    }

    public int getLightColor(float partialTicks) {
        return -1;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getORoll() {
        return this.oRoll;
    }

    public float getRed() {
        return this.rCol;
    }

    public float getGreen() {
        return this.gCol;
    }

    public float getBlue() {
        return this.bCol;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getSize() {
        return this.quadSize;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getXOld() {
        return this.xo;
    }

    public double getYOld() {
        return this.yo;
    }

    public double getZOld() {
        return this.zo;
    }

    public double getXMotion() {
        return this.xd;
    }

    public double getYMotion() {
        return this.yd;
    }

    public double getZMotion() {
        return this.zd;
    }

    public Vec3 getPosition() {
        return new Vec3(this.getX(), this.getY(), this.getZ());
    }

    public void setPosition(Vec3 pos) {
        this.setPos(pos.x, pos.y, pos.z);
    }

    public Vec3 getSpeed() {
        return new Vec3(this.getXMotion(), this.getYMotion(), this.getZMotion());
    }

    public void setSpeed(Vec3 speed) {
        this.setParticleSpeed(speed.x, speed.y, speed.z);
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getAge() {
        return this.age;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.sprites.size() && spriteIndex >= 0) {
            this.setSprite((TextureAtlasSprite)this.spriteSet.sprites.get(spriteIndex));
        }
    }
}

