/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.particle.data;

import com.mw.nullcore.client.particle.data.Easing;
import net.minecraft.util.Mth;

public class GenericParticleData {
    public final float startingValue;
    public final float middleValue;
    public final float endingValue;
    public final float rs1;
    public final float rs2;
    public final float rm1;
    public final float rm2;
    public final float re1;
    public final float re2;
    public final float coefficient;
    public final Easing startToMiddleEasing;
    public final Easing middleToEndEasing;
    public float valueMultiplier = 1.0f;
    public float coefficientMultiplier = 1.0f;

    public GenericParticleData(float startingValue, float middleValue, float endingValue, float rs1, float rs2, float rm1, float rm2, float re1, float re2, float coefficient, Easing startToMiddleEasing, Easing middleToEndEasing) {
        this.startingValue = startingValue;
        this.middleValue = middleValue;
        this.endingValue = endingValue;
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.rm1 = rm1;
        this.rm2 = rm2;
        this.re1 = re1;
        this.re2 = re2;
        this.coefficient = coefficient;
        this.startToMiddleEasing = startToMiddleEasing;
        this.middleToEndEasing = middleToEndEasing;
    }

    public GenericParticleData copy() {
        return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing).overrideValueMultiplier(this.valueMultiplier).overrideCoefficientMultiplier(this.coefficientMultiplier);
    }

    public GenericParticleData bake() {
        return new GenericParticleData(this.startingValue * this.valueMultiplier, this.middleValue * this.valueMultiplier, this.endingValue * this.valueMultiplier, this.rs1 * this.valueMultiplier, this.rs2 * this.valueMultiplier, this.rm1 * this.valueMultiplier, this.rm2 * this.valueMultiplier, this.re1 * this.valueMultiplier, this.re2 * this.valueMultiplier, this.coefficient * this.coefficientMultiplier, this.startToMiddleEasing, this.middleToEndEasing);
    }

    public GenericParticleData multiplyCoefficient(float coefficientMultiplier) {
        this.coefficientMultiplier *= coefficientMultiplier;
        return this;
    }

    public GenericParticleData multiplyValue(float valueMultiplier) {
        this.valueMultiplier *= valueMultiplier;
        return this;
    }

    public GenericParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        this.coefficientMultiplier = coefficientMultiplier;
        return this;
    }

    public GenericParticleData overrideValueMultiplier(float valueMultiplier) {
        this.valueMultiplier = valueMultiplier;
        return this;
    }

    public boolean isTrinary() {
        return this.endingValue != -1.0f;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.clamp((float)(age * this.coefficient * this.coefficientMultiplier / lifetime), (float)0.0f, (float)1.0f);
    }

    public float getValue(float age, float lifetime, float startingValue, float middleValue, float endingValue) {
        float progress = this.getProgress(age, lifetime);
        float result = this.isTrinary() ? (progress >= 0.5f ? Mth.lerp((float)this.middleToEndEasing.apply((progress - 0.5f) / 0.5f), (float)middleValue, (float)endingValue) : Mth.lerp((float)this.startToMiddleEasing.apply(progress / 0.5f), (float)startingValue, (float)middleValue)) : Mth.lerp((float)this.startToMiddleEasing.apply(progress), (float)startingValue, (float)middleValue);
        return result * this.valueMultiplier;
    }

    public float getValue(float age, float lifetime) {
        return this.getValue(age, lifetime, this.startingValue, this.middleValue, this.endingValue);
    }

    public static GenericParticleDataBuilder create() {
        return new GenericParticleDataBuilder(-1.0f, -1.0f, -1.0f);
    }

    public static GenericParticleDataBuilder create(float value) {
        return new GenericParticleDataBuilder(value, value, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static class GenericParticleDataBuilder {
        public float startingValue;
        public float middleValue;
        public float endingValue;
        public float rs1 = -1.0f;
        public float rs2 = -1.0f;
        public float rm1 = -1.0f;
        public float rm2 = -1.0f;
        public float re1 = -1.0f;
        public float re2 = -1.0f;
        public float coefficient = 1.0f;
        public Easing startToMiddleEasing = Easing.linear;
        public Easing middleToEndEasing = Easing.linear;

        public GenericParticleDataBuilder(float startingValue, float middleValue, float endingValue) {
            this.startingValue = startingValue;
            this.middleValue = middleValue;
            this.endingValue = endingValue;
        }

        public GenericParticleDataBuilder setCoefficient(float coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        public GenericParticleDataBuilder setEasing(Easing easing) {
            this.startToMiddleEasing = easing;
            return this;
        }

        public GenericParticleDataBuilder setEasing(Easing easing, Easing middleToEndEasing) {
            this.startToMiddleEasing = easing;
            this.middleToEndEasing = easing;
            return this;
        }

        public GenericParticleDataBuilder setRandomValue(float v1, float v2) {
            this.setRandomValue(v1, v2, -1.0f, -1.0f);
            return this;
        }

        public GenericParticleDataBuilder setRandomValue(float rs1, float rs2, float rm1, float rm2) {
            this.setRandomValue(rs1, rs2, rm1, rm2, -1.0f, -1.0f);
            return this;
        }

        public GenericParticleDataBuilder setRandomValue(float rs1, float rs2, float rm1, float rm2, float re1, float re2) {
            this.rs1 = rs1;
            this.rs2 = rs2;
            this.rm1 = rm1;
            this.rm2 = rm2;
            this.re1 = re1;
            this.re2 = re2;
            return this;
        }

        public GenericParticleData build() {
            return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing);
        }
    }
}

