/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.entities.ShyItemEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ShyItemRender
extends ItemEntityRenderer {
    public ShyItemRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ItemEntityRenderState state, PoseStack ps, MultiBufferSource mBuffer, int light) {
        super.render(state, ps, mBuffer, light);
        if (state instanceof ShyItemState) {
            ShyItemState aState = (ShyItemState)state;
            if (!state.item.isEmpty() && aState.raysEnabled) {
                float yOffset = Mth.sin((float)(state.ageInTicks / 10.0f + state.bobOffset)) * 0.1f + 0.1f;
                float speed = state.item.transform().scale.y();
                ps.pushPose();
                ps.translate(0.0f, yOffset + (aState.item.usesBlockLight() ? 1.0f : 0.5f) * speed, 0.0f);
                NcUtils.Render.renderRays(ps, mBuffer.getBuffer(RenderType.dragonRays()), aState.color, 1.0f, aState.pTick);
                ps.popPose();
            }
        }
    }

    public void extractRenderState(ItemEntity entity, ItemEntityRenderState state, float pTick) {
        if (state instanceof ShyItemState) {
            ShyItemState aState = (ShyItemState)state;
            if (entity instanceof ShyItemEntity) {
                ShyItemEntity aEntity = (ShyItemEntity)entity;
                aState.raysEnabled = (Boolean)aEntity.getRays().getFirst();
                aState.color = (Integer)aEntity.getRays().getSecond();
                aState.pTick = pTick;
            }
        }
        super.extractRenderState(entity, state, pTick);
    }

    @NotNull
    public ItemEntityRenderState createRenderState() {
        return new ShyItemState();
    }

    public static class ShyItemState
    extends ItemEntityRenderState {
        public boolean raysEnabled;
        public int color;
        public float pTick;
    }
}

