/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public record Transform(PoseStack ps) {
    public static Transform create(PoseStack ps, Consumer<Transform> transform) {
        Transform tr = new Transform(ps);
        transform.accept(tr);
        return tr;
    }

    public void start() {
        this.ps.pushPose();
    }

    public void stop() {
        this.ps.popPose();
    }

    public void autoPose(Runnable action) {
        this.start();
        action.run();
        this.stop();
    }

    public void rotate(float pX, float pY, float pZ, Quaternionf angel) {
        this.move(pX, pY, pZ);
        this.ps.mulPose(angel);
        this.move(-pX, -pY, -pZ);
    }

    public void rotate(float pX, float pY, Quaternionf angel) {
        this.rotate(pX, pY, 0.0f, angel);
    }

    public void scale(float pX, float pY, float pZ, float sX, float sY, float sZ) {
        this.move(pX, pY, pZ);
        this.ps.scale(sX, sY, sZ);
        this.move(-pX, -pY, -pZ);
    }

    public void scale(float pX, float pY, float sX, float sY) {
        this.scale(pX, pY, 0.0f, sX, sY, 0.0f);
    }

    public void move(float pX, float pY, float pZ) {
        this.ps.translate(pX, pY, pZ);
    }

    public void move(float pX, float pY) {
        this.move(pX, pY, 0.0f);
    }
}

