/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.client.render.ShyModel;
import com.mw.nullcore.core.blocks.type.ContainerBlockEntity;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class NcUtils {
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static final Minecraft mc = Minecraft.getInstance();
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static final Font font = NcUtils.mc.font;
    @OnlyIn(value=Dist.CLIENT)
    public static final float partialTick = mc.getDeltaTracker().getGameTimeDeltaPartialTick(false);
    @OnlyIn(value=Dist.CLIENT)
    public static int clientTick;
    public static final RandomSource rand;

    static {
        rand = RandomSource.create((long)1L);
    }

    public static final class Reader {
        public static Object parseJsonValue(JsonElement element, Object defaultValue) {
            if (defaultValue instanceof Boolean) {
                return element.getAsBoolean();
            }
            if (defaultValue instanceof Integer) {
                return element.getAsInt();
            }
            if (defaultValue instanceof Byte) {
                return element.getAsByte();
            }
            if (defaultValue instanceof Short) {
                return element.getAsShort();
            }
            if (defaultValue instanceof Long) {
                return element.getAsLong();
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(element.getAsFloat());
            }
            if (defaultValue instanceof String) {
                return element.getAsString();
            }
            if (defaultValue instanceof Character) {
                return Character.valueOf(element.getAsCharacter());
            }
            if (defaultValue instanceof List) {
                return Reader.parseList(element.getAsJsonArray(), (List)defaultValue);
            }
            return null;
        }

        public static void addValueToJson(JsonObject json, String key, Object value) {
            if (value instanceof Boolean) {
                Boolean v = (Boolean)value;
                json.addProperty(key, v);
            } else if (value instanceof Number) {
                Number v = (Number)value;
                json.addProperty(key, v);
            } else if (value instanceof String) {
                String v = (String)value;
                json.addProperty(key, v);
            } else if (value instanceof Character) {
                Character v = (Character)value;
                json.addProperty(key, v);
            } else if (value instanceof List) {
                List list = (List)value;
                JsonArray array = new JsonArray();
                for (Object item : list) {
                    Reader.addItemToJsonArray(array, item);
                }
                json.add(key, (JsonElement)array);
            }
        }

        public static List<Object> parseList(JsonArray array, List<?> list) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (array == null || array.isEmpty()) {
                return result;
            }
            if (!list.isEmpty()) {
                Object firstElement = list.getFirst();
                for (JsonElement element : array) {
                    result.add(Reader.parseJsonValue(element, firstElement));
                }
            } else {
                for (JsonElement element : array) {
                    if (element.isJsonPrimitive()) {
                        JsonPrimitive primitive = element.getAsJsonPrimitive();
                        if (primitive.isBoolean()) {
                            result.add(primitive.getAsBoolean());
                            continue;
                        }
                        if (primitive.isNumber()) {
                            result.add(primitive.getAsNumber());
                            continue;
                        }
                        if (!primitive.isString()) continue;
                        result.add(primitive.getAsString());
                        continue;
                    }
                    result.add(element.toString());
                }
            }
            return result;
        }

        public static void addItemToJsonArray(JsonArray array, Object item) {
            if (item instanceof Boolean) {
                Boolean v = (Boolean)item;
                array.add(v);
            } else if (item instanceof Number) {
                Number v = (Number)item;
                array.add(v);
            } else if (item instanceof String) {
                String v = (String)item;
                array.add(v);
            } else if (item instanceof Character) {
                Character v = (Character)item;
                array.add(v);
            } else if (item instanceof List) {
                List v = (List)item;
                JsonArray nestedArray = new JsonArray();
                for (Object nestedItem : v) {
                    Reader.addItemToJsonArray(nestedArray, nestedItem);
                }
                array.add((JsonElement)nestedArray);
            }
        }

        public static <T> void applyComponents(ItemStack stack, JsonObject json) {
            DataComponentPatch.Builder patch = DataComponentPatch.builder();
            json.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                ResourceLocation componentId = ResourceLocation.tryParse((String)key);
                if (componentId == null) {
                    return;
                }
                DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(componentId);
                if (type == null) {
                    NullCore.LOGGER.warn("Unknown DataComponent: {}", (Object)key);
                    return;
                }
                type.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)value).result().ifPresent(parsedValue -> patch.set(type, parsedValue));
            });
            stack.applyComponents(patch.build());
        }
    }

    public static final class Level {
        public static void setBiome(ServerLevel level, ResourceKey<Biome> biome, BlockPos from, BlockPos to) {
            FillBiomeCommand.fill((ServerLevel)level, (BlockPos)from, (BlockPos)to, Level.getBiome((net.minecraft.world.level.Level)level, biome));
        }

        public static void setBiome(ServerLevel level, ResourceKey<Biome> biome, BlockPos pos) {
            Level.setBiome(level, biome, pos, pos);
        }

        public static Holder<Biome> getBiome(net.minecraft.world.level.Level level, ResourceKey<Biome> biome) {
            return level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(biome);
        }

        public static ResourceLocation getBiome(net.minecraft.world.level.Level level, Biome biome) {
            return level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
        }

        public static List<ResourceLocation> getStructuresAt(ServerLevel level, BlockPos pos) {
            Registry structureRegistry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            return level.structureManager().getAllStructuresAt(pos).keySet().stream().map(arg_0 -> ((Registry)structureRegistry).getKey(arg_0)).filter(Objects::nonNull).toList();
        }

        public static boolean isStructure(net.minecraft.world.level.Level level, BlockPos pos, ResourceLocation structureId) {
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel sl = (ServerLevel)level;
            Registry registry = sl.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Structure structure = (Structure)registry.getValue(structureId);
            if (structure == null) {
                return false;
            }
            return sl.structureManager().getStructureAt(pos, structure).isValid();
        }

        public static List<Entity> getEntities(net.minecraft.world.level.Level level, BlockPos startPos, double radius) {
            return level.getEntities(null, new AABB((double)startPos.getX() - radius, (double)startPos.getY() - radius, (double)startPos.getZ() - radius, (double)startPos.getX() + radius, (double)startPos.getY() + radius, (double)startPos.getZ() + radius));
        }
    }

    public static final class Text {
        public static void addTooltipWithKey(int button, int colorButton, List<Component> adder, Component ... components) {
            if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)button)) {
                for (Component cm : components) {
                    if (cm == null) continue;
                    adder.add(cm);
                }
            } else {
                adder.add((Component)Component.translatable((String)"tooltip.nullcore.info", (Object[])new Object[]{Component.translatable((String)InputConstants.getKey((int)button, (int)0).toString()).withColor(colorButton)}));
            }
        }

        public static String formatNum(float amount) {
            float scaledNumber;
            String[] sufx = new String[]{"", "K", "M", "B", "T", "Qa", "Qt", "Sx", "Sp", "Oc", "N", "D"};
            int suffixIndex = 0;
            for (scaledNumber = amount; scaledNumber >= 1000.0f && suffixIndex < sufx.length - 1; scaledNumber /= 1000.0f, ++suffixIndex) {
            }
            DecimalFormat df = new DecimalFormat("#.#");
            return df.format(scaledNumber) + sufx[suffixIndex];
        }

        public static Component addLinerTextGradient(Object text, float speed, boolean toRight, int ... colors) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            RandomSource rand = RandomSource.create((long)1L);
            float offset = (toRight ? -(Render.getAnimationTick() * rand.nextFloat() + 0.5f) : Render.getAnimationTick() * rand.nextFloat() + 0.5f) * speed;
            MutableComponent component = Component.empty();
            int length = str.length();
            if (length == 0 || colors.length == 0) {
                return component;
            }
            if ((offset %= 1.0f) < 0.0f) {
                offset += 1.0f;
            }
            for (int i = 0; i < length; ++i) {
                float pos = (float)i / (float)length + offset;
                float colorPos = (pos %= 1.0f) * (float)(colors.length - 1);
                int colorIndex = (int)colorPos;
                float lerp = colorPos - (float)colorIndex;
                int color1 = colors[colorIndex % colors.length];
                int color2 = colors[(colorIndex + 1) % colors.length];
                int color = Color.lerpColors(lerp, color1, color2);
                component.append((Component)Component.literal((String)String.valueOf(str.charAt(i))).withStyle(style -> style.withColor(color)));
            }
            return component;
        }

        public static Component addTextGradient(Object text, float speed, int ... colors) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            int color = Color.getCyclingColor(speed, colors);
            return Component.literal((String)str).withColor(TextColor.fromRgb((int)(color & 0xFFFFFF)).getValue());
        }

        public static void addPositionTooltip(List<Component> tooltip, BlockPos pos, Component key, int colorPos, int colorData) {
            if (pos != null) {
                tooltip.add((Component)key.copy().withColor(colorPos));
                tooltip.add((Component)Component.literal((String)String.format("X: %d, Y: %d, Z: %d", pos.getX(), pos.getY(), pos.getZ())).withColor(colorData));
            }
        }

        public static void addTooltipEffects(List<Component> tooltip, MutableComponent component, List<ArmorMaterialBuilder.ShyEffect> list) {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    MobEffect effect = (MobEffect)list.get(i).effect().value();
                    String effectName = effect.getDisplayName().getString();
                    component.append((Component)Component.literal((String)effectName).withColor(effect.getColor()));
                    if (i >= list.size() - 1) continue;
                    component.append((Component)Component.literal((String)", ").withStyle(component.getStyle()));
                }
                tooltip.add((Component)component);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Render {
        private static final int U0 = 0;
        private static final int U1 = 1;
        private static final int V0 = 2;
        private static final int V1 = 3;
        public static final MultiBufferSource mBuffer = mc.renderBuffers().bufferSource();

        public static void drawTexture(GuiGraphics gg, ResourceLocation texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height, int color) {
            gg.blit(RenderType::guiTextured, texture, x, y, (float)u, (float)v, pixelWidth, pixelHeight, width, height, color);
        }

        public static void drawTexture(GuiGraphics gg, ResourceLocation texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height) {
            Render.drawTexture(gg, texture, x, y, u, v, pixelWidth, pixelHeight, width, height, -1);
        }

        public static void drawFullTexture(GuiGraphics gui, ResourceLocation texture, float x, float y, float size, int color) {
            gui.blit(RenderType::guiTextured, texture, (int)x, (int)y, 0.0f, 0.0f, (int)size, (int)size, (int)size, (int)size, color);
        }

        public static void drawFullTexture(GuiGraphics gui, ResourceLocation texture, float x, float y, float size) {
            Render.drawFullTexture(gui, texture, x, y, size, -1);
        }

        public static void drawLine(GuiGraphics gg, RenderType type, float startX, float startY, float endX, float endY, int color, float thickness) {
            float dx = endX - startX;
            float dy = endY - startY;
            float length = (float)Math.sqrt(dx * dx + dy * dy);
            if (length < 0.5f) {
                return;
            }
            float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
            PoseStack pose = gg.pose();
            pose.pushPose();
            pose.translate(startX, startY, 0.0f);
            pose.mulPose(Axis.ZP.rotationDegrees(angle));
            int half = (int)(thickness / 2.0f);
            gg.fill(type, 0, -half, (int)length, half + (thickness % 2.0f == 0.0f ? 0 : 1), color);
            pose.popPose();
        }

        public static void drawLine(GuiGraphics gg, float startX, float startY, float endX, float endY, int color, float thickness) {
            Render.drawLine(gg, RenderType.gui(), startX, startY, endX, endY, color, thickness);
        }

        public static void drawText(GuiGraphics gg, Object text, int x, int y, int color, boolean shadow) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            gg.drawString(font, str, x, y, color, shadow);
        }

        public static void drawText(GuiGraphics gg, Object text, int x, int y, int color) {
            Render.drawText(gg, text, x, y, color, false);
        }

        public static void renderRays(PoseStack ps, VertexConsumer buffer, int color, float time, float pTick) {
            ps.pushPose();
            RandomSource rand = RandomSource.create((long)1L);
            float rotationTime = (((float)clientTick + pTick) * rand.nextFloat() + 0.5f) * time;
            float[] rgb = Color.unpack(color, false);
            int count = rand.nextInt(10, 25);
            Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);
            for (int l = 0; l < count; ++l) {
                float length = rand.nextFloat();
                float width = rand.nextFloat() * 0.3f;
                Vector3f left = new Vector3f(-0.866f * width, length, -0.5f * width);
                Vector3f right = new Vector3f(0.866f * width, length, -0.5f * width);
                Vector3f front = new Vector3f(0.0f, length, width);
                Quaternionf rotate = new Quaternionf().rotationXYZ(rand.nextFloat() * ((float)Math.PI * 2) + rotationTime * 0.05f, (float)Math.PI * 2 + rotationTime * 0.08f, rand.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(rand.nextFloat() * ((float)Math.PI * 2), rand.nextFloat() * ((float)Math.PI * 2), rand.nextFloat() * ((float)Math.PI * 2) + rotationTime * 0.06f);
                ps.mulPose(rotate);
                PoseStack.Pose pose = ps.last();
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, left).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, right).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, right).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, front).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, front).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, left).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                ps.mulPose(rotate.invert());
            }
            ps.popPose();
        }

        public static void renderItem(PoseStack ps, ItemDisplayContext ctx, MultiBufferSource bufferSource, ItemStack stack, net.minecraft.world.level.Level level, BlockPos pos, Direction lightFacing) {
            if (stack.isEmpty()) {
                return;
            }
            int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockState)level.getBlockState(pos), (BlockPos)pos.relative(lightFacing));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ctx, light, OverlayTexture.NO_OVERLAY, ps, bufferSource, level, 0);
        }

        public static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
            return switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new Vector3f(value, vector.y(), vector.z());
                case Direction.Axis.Y -> new Vector3f(vector.x(), value, vector.z());
                case Direction.Axis.Z -> new Vector3f(vector.x(), vector.y(), value);
            };
        }

        public static double getValue(Vec3 vector, Direction.Axis axis) {
            return switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> vector.x;
                case Direction.Axis.Y -> vector.y;
                case Direction.Axis.Z -> vector.z;
            };
        }

        public static void renderCube(ShyModel cube, PoseStack ps, VertexConsumer buffer, int argb, int light, int overlay) {
            float red = Color.getRed(argb);
            float green = Color.getGreen(argb);
            float blue = Color.getBlue(argb);
            float alpha = Color.getAlpha(argb);
            Vec3 size = new Vec3((double)cube.sizeX(), (double)cube.sizeY(), (double)cube.sizeZ());
            ps.pushPose();
            ps.translate(cube.getMinX(), cube.getMinY(), cube.getMinZ());
            PoseStack.Pose pose = ps.last();
            Matrix4f mat = pose.pose();
            for (Direction originalFace : Direction.values()) {
                TextureAtlasSprite sprite;
                if (!cube.shouldSideRender(originalFace) || (sprite = cube.textures[originalFace.ordinal()]) == null) continue;
                Direction.Axis axis = originalFace.getAxis();
                Direction.Axis u = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
                Direction.Axis v = axis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
                float other = originalFace.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (float)Render.getValue(size, axis) : 0.0f;
                Direction face = originalFace.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? originalFace : originalFace.getOpposite();
                Direction opposite = face.getOpposite();
                float minU = sprite.getU0();
                float maxU = sprite.getU1();
                float minV = sprite.getV1();
                float maxV = sprite.getV0();
                double sizeU = Render.getValue(size, u);
                double sizeV = Render.getValue(size, v);
                int uIndex = 0;
                while ((double)uIndex < sizeU) {
                    float u0 = minU;
                    float u1 = maxU;
                    double addU = Math.min(1.0, sizeU - (double)uIndex);
                    if (addU < 1.0) {
                        u1 = u0 + (u1 - u0) * (float)addU;
                    }
                    int vIndex = 0;
                    while ((double)vIndex < sizeV) {
                        float v0 = minV;
                        float v1 = maxV;
                        double addV = Math.min(1.0, sizeV - (double)vIndex);
                        if (addV < 1.0) {
                            v1 = v0 + (v1 - v0) * (float)addV;
                        }
                        float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                        float[] uv = new float[]{u0, u1, v0, v1};
                        Render.renderPoint(mat, pose, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                        Render.renderPoint(mat, pose, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                        ++vIndex;
                    }
                    ++uIndex;
                }
            }
            ps.popPose();
        }

        private static void addVertex(VertexConsumer buffer, Matrix4f mat, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int light, int overlay, PoseStack.Pose pose, Vector3f norm) {
            float adj = 2.5f;
            Vector3f adjustedNorm = new Vector3f(norm.x() + adj, norm.y() + adj, norm.z() + adj);
            adjustedNorm.normalize();
            buffer.addVertex(mat, x, y, z).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(pose, adjustedNorm.x(), adjustedNorm.y(), adjustedNorm.z());
        }

        public static void renderSphere(ShyModel sphere, PoseStack ps, VertexConsumer buffer, int argb, int light, int overlay) {
            float red = Color.getRed(argb);
            float green = Color.getGreen(argb);
            float blue = Color.getBlue(argb);
            float alpha = Color.getAlpha(argb);
            float radius = (float)((double)(sphere.sizeX() + sphere.sizeY() + sphere.sizeZ()) / 6.0);
            int stacks = Math.max(8, (int)sphere.sizeY());
            int sectors = Math.max(8, (int)Math.max(sphere.sizeX(), sphere.sizeZ()));
            TextureAtlasSprite sprite = sphere.textures[0];
            if (sprite == null) {
                return;
            }
            ps.pushPose();
            ps.translate(sphere.getMinX() + radius, sphere.getMinY() + radius, sphere.getMinZ() + radius);
            PoseStack.Pose pose = ps.last();
            Matrix4f mat = pose.pose();
            for (int i = 0; i < stacks; ++i) {
                float phi1 = (float)(Math.PI * (double)i / (double)stacks);
                float phi2 = (float)(Math.PI * (double)(i + 1) / (double)stacks);
                float sinPhi1 = (float)Math.sin(phi1);
                float cosPhi1 = (float)Math.cos(phi1);
                float sinPhi2 = (float)Math.sin(phi2);
                float cosPhi2 = (float)Math.cos(phi2);
                float v1 = phi1 / (float)Math.PI;
                float v2 = phi2 / (float)Math.PI;
                for (int j = 0; j < sectors; ++j) {
                    float theta1 = (float)(Math.PI * 2 * (double)j / (double)sectors);
                    float theta2 = (float)(Math.PI * 2 * (double)(j + 1) / (double)sectors);
                    float u1 = (float)j / (float)sectors;
                    float u2 = (float)(j + 1) / (float)sectors;
                    Vector3f p1 = new Vector3f((float)((double)(radius * sinPhi1) * Math.cos(theta1)), radius * cosPhi1, (float)((double)(radius * sinPhi1) * Math.sin(theta1)));
                    Vector3f n1 = new Vector3f((Vector3fc)p1);
                    n1.normalize();
                    Vector3f p2 = new Vector3f((float)((double)(radius * sinPhi1) * Math.cos(theta2)), radius * cosPhi1, (float)((double)(radius * sinPhi1) * Math.sin(theta2)));
                    Vector3f n2 = new Vector3f((Vector3fc)p2);
                    n2.normalize();
                    Vector3f p3 = new Vector3f((float)((double)(radius * sinPhi2) * Math.cos(theta2)), radius * cosPhi2, (float)((double)(radius * sinPhi2) * Math.sin(theta2)));
                    Vector3f n3 = new Vector3f((Vector3fc)p3);
                    n3.normalize();
                    Vector3f p4 = new Vector3f((float)((double)(radius * sinPhi2) * Math.cos(theta1)), radius * cosPhi2, (float)((double)(radius * sinPhi2) * Math.sin(theta1)));
                    Vector3f n4 = new Vector3f((Vector3fc)p4);
                    n4.normalize();
                    Render.addVertex(buffer, mat, p1.x(), p1.y(), p1.z(), sprite.getU(u1), sprite.getV(v1), red, green, blue, alpha, light, overlay, pose, n1);
                    Render.addVertex(buffer, mat, p2.x(), p2.y(), p2.z(), sprite.getU(u2), sprite.getV(v1), red, green, blue, alpha, light, overlay, pose, n2);
                    Render.addVertex(buffer, mat, p3.x(), p3.y(), p3.z(), sprite.getU(u2), sprite.getV(v2), red, green, blue, alpha, light, overlay, pose, n3);
                    Render.addVertex(buffer, mat, p4.x(), p4.y(), p4.z(), sprite.getU(u1), sprite.getV(v2), red, green, blue, alpha, light, overlay, pose, n4);
                    Render.addVertex(buffer, mat, p4.x(), p4.y(), p4.z(), sprite.getU(u1), sprite.getV(v2), red, green, blue, alpha, light, overlay, pose, n4.mul(-1.0f));
                    Render.addVertex(buffer, mat, p3.x(), p3.y(), p3.z(), sprite.getU(u2), sprite.getV(v2), red, green, blue, alpha, light, overlay, pose, n3.mul(-1.0f));
                    Render.addVertex(buffer, mat, p2.x(), p2.y(), p2.z(), sprite.getU(u2), sprite.getV(v1), red, green, blue, alpha, light, overlay, pose, n2.mul(-1.0f));
                    Render.addVertex(buffer, mat, p1.x(), p1.y(), p1.z(), sprite.getU(u1), sprite.getV(v1), red, green, blue, alpha, light, overlay, pose, n1.mul(-1.0f));
                }
            }
            ps.popPose();
        }

        public static void renderPoint(Matrix4f matrix4f, PoseStack.Pose pose, VertexConsumer buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light, int overlay) {
            int uArr = minU ? 0 : 1;
            int vArr = minV ? 2 : 3;
            Vector3f vertex = Render.withValue(Mth.VZERO, u, xyz[uArr]);
            vertex = Render.withValue(vertex, v, xyz[vArr]);
            vertex = Render.withValue(vertex, face.getAxis(), other);
            Vec3i normalVec = face.getUnitVec3i();
            float adj = 2.5f;
            Vector3f norm = new Vector3f((float)normalVec.getX() + adj, (float)normalVec.getY() + adj, (float)normalVec.getZ() + adj);
            norm.normalize();
            buffer.addVertex(matrix4f, vertex.x(), vertex.y(), vertex.z()).setColor(red, green, blue, alpha).setUv(uv[uArr], uv[vArr]).setOverlay(overlay).setLight(light).setNormal(pose, norm.x(), norm.y(), norm.z());
        }

        public static void renderBillboard(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float size, int light, int color) {
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            poseStack.mulPose(Axis.YP.rotationDegrees(-camera.getYRot()));
            poseStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
            float half = size / 2.0f;
            poseStack.translate(-half, -half, 0.0f);
            Matrix4f matrix = poseStack.last().pose();
            buffer.addVertex(matrix, 0.0f, size, 0.0f).setColor(color).setUv(0.0f, 1.0f).setLight(light);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(color).setUv(0.0f, 0.0f).setLight(light);
            buffer.addVertex(matrix, size, 0.0f, 0.0f).setColor(color).setUv(1.0f, 0.0f).setLight(light);
            buffer.addVertex(matrix, size, size, 0.0f).setColor(color).setUv(1.0f, 1.0f).setLight(light);
            poseStack.popPose();
        }

        public static void rotateToFacing(PoseStack ps, Direction facing) {
            switch (facing) {
                case NORTH: {
                    ps.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case SOUTH: {
                    ps.mulPose(Axis.YP.rotationDegrees(0.0f));
                    break;
                }
                case WEST: {
                    ps.mulPose(Axis.YP.rotationDegrees(270.0f));
                    break;
                }
                case EAST: {
                    ps.mulPose(Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case UP: {
                    ps.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case DOWN: {
                    ps.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
            }
        }

        public static void rotateMoveToFacing(PoseStack ps, Direction facing, float offset) {
            ps.translate(0.5f, 0.5f, 0.5f);
            float rotationY = switch (facing) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 270.0f;
                case Direction.EAST -> 90.0f;
                default -> 0.0f;
            };
            ps.mulPose(Axis.YP.rotationDegrees(rotationY));
            float distanceFromCenter = 0.5f - offset;
            ps.translate(0.0f, 0.0f, -distanceFromCenter);
        }

        public static float getAnimationTick(float pTick) {
            return pTick + (float)clientTick;
        }

        public static float getAnimationTick() {
            return Render.getAnimationTick(partialTick);
        }

        public static TextureAtlasSprite getSprite(ResourceLocation texture) {
            TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
            return atlas.getSprite(texture);
        }

        public static TextureAtlasSprite getSpriteOf(ResourceLocation texture) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
        }
    }

    public static final class Particle {
        public static void forParticleSpawn(net.minecraft.world.level.Level level, ParticleOptions particle, float pX, float pY, float pZ, float xSpeed, float ySpeed, float zSpeed, int count) {
            RandomSource rand = level.random;
            for (int i = 0; i < count; ++i) {
                double oX = (rand.nextDouble() - 0.5) * 0.5;
                double oY = (rand.nextDouble() - 0.5) * 0.5;
                double oZ = (rand.nextDouble() - 0.5) * 0.5;
                level.addParticle(particle, (double)pX + oX, (double)pY + oY, (double)pZ + oZ, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
        }

        public static void forParticleSpawn(net.minecraft.world.level.Level level, ParticleOptions particle, float pX, float pY, float pZ, int count) {
            Particle.forParticleSpawn(level, particle, pX, pY, pZ, 0.0f, 0.0f, 0.0f, count);
        }

        public static void forAxisParticle(BlockPos pos, ParticleOptions particle) {
            ClientLevel level = NcUtils.mc.level;
            RandomSource rand = level.random;
            for (Direction direction : Direction.values()) {
                BlockPos dirPos = pos.relative(direction);
                if (level.getBlockState(dirPos).isSolidRender()) continue;
                Direction.Axis axis = direction.getAxis();
                float d1 = axis == Direction.Axis.X ? 0.5f + 0.5625f * (float)direction.getStepX() : rand.nextFloat();
                float d2 = axis == Direction.Axis.Y ? 0.5f + 0.5625f * (float)direction.getStepY() : rand.nextFloat();
                float d3 = axis == Direction.Axis.Z ? 0.5f + 0.5625f * (float)direction.getStepZ() : rand.nextFloat();
                level.addParticle(particle, (double)((float)pos.getX() + d1), (double)((float)pos.getY() + d2), (double)((float)pos.getZ() + d3), 0.0, 0.0, 0.0);
            }
        }

        public static <T extends ParticleOptions> boolean sendPlayerParticles(ServerPlayer player, T particle, double posX, double posY, double posZ, int count, double xDist, double yDist, double zDist, double maxSpeed) {
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particle, false, false, posX, posY, posZ, (float)xDist, (float)yDist, (float)zDist, (float)maxSpeed, count);
            BlockPos playerPos = player.blockPosition();
            if (playerPos.closerToCenterThan((Position)new Vec3(posX, posY, posZ), 32.0)) {
                player.connection.send((Packet)packet);
                return true;
            }
            return false;
        }

        public static void writeParticle(CompoundTag tag, ParticleOptions particle) {
            CompoundTag pTag = new CompoundTag();
            ResourceLocation loc = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)particle.getType());
            pTag.putString("namespace", loc.getNamespace());
            pTag.putString("path", loc.getPath());
            tag.put("particle", (Tag)pTag);
        }

        public static ParticleOptions readParticle(CompoundTag tag) {
            CompoundTag pTag = (CompoundTag)tag.get("particle");
            return (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.getOptional(ResourceLocation.fromNamespaceAndPath((String)pTag.getString("namespace"), (String)pTag.getString("path"))).get();
        }
    }

    public static final class Mth {
        public static final Vector3f VZERO = new Vector3f(0.0f, 0.0f, 0.0f);

        public static boolean chance(float chance) {
            return rand.nextFloat() < net.minecraft.util.Mth.clamp((float)chance, (float)0.0f, (float)1.0f);
        }

        public static String formatRealTime(long gameTime) {
            long totalSeconds = gameTime / 20L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            long seconds = totalSeconds % 60L;
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }

        public static float perlinNoise(float x, float y, float z, float frequency, float amplitude) {
            float noise = 0.0f;
            for (int i = 0; i < 3; ++i) {
                noise += (float)(Math.sin(x * frequency) * Math.cos(y * frequency) * (z != 0.0f ? Math.sin(z * frequency) : 1.0) * (double)amplitude);
                frequency *= 2.0f;
                amplitude *= 0.4f;
            }
            return noise;
        }

        public static int secondTick(int seconds) {
            return seconds * 20;
        }

        public static int minuteTick(int minutes) {
            return Mth.secondTick(minutes * 60);
        }

        public static int hourTick(int hours) {
            return Mth.minuteTick(hours * 60);
        }

        public static int dayTick(int days) {
            return Mth.hourTick(days * 24);
        }

        public static float calculateProgress(float current, float max, float minOutput, float maxOutput) {
            if (max <= 0.0f) {
                return minOutput;
            }
            float progress = current / max;
            progress = net.minecraft.util.Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
            return net.minecraft.util.Mth.lerp((float)progress, (float)minOutput, (float)maxOutput);
        }
    }

    public static final class Color {
        public static float[] unpack(int color, boolean asARGB) {
            float[] fArray;
            if (asARGB) {
                float[] fArray2 = new float[4];
                fArray2[0] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray2[1] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray2[2] = (float)(color & 0xFF) / 255.0f;
                fArray = fArray2;
                fArray2[3] = (float)(color >> 24 & 0xFF) / 255.0f;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = (float)(color >> 24 & 0xFF) / 255.0f;
                fArray3[1] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray3[2] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray = fArray3;
                fArray3[3] = (float)(color & 0xFF) / 255.0f;
            }
            return fArray;
        }

        public static int pack(float r, float g, float b, float a, boolean asARGB) {
            return asARGB ? (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) : (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
        }

        public static int hexPack(String hexColor) {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }

        public static int lerpColors(float progress, int ... colors) {
            float segment = progress * (float)(colors.length - 1);
            int index = (int)segment;
            float factor = segment - (float)index;
            if (index >= colors.length - 1) {
                index = colors.length - 2;
                factor = 1.0f;
            }
            float[] c1 = Color.unpack(colors[index], false);
            float[] c2 = Color.unpack(colors[index + 1], false);
            return Color.pack(net.minecraft.util.Mth.lerp((float)factor, (float)c1[0], (float)c2[0]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[1], (float)c2[1]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[2], (float)c2[2]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[3], (float)c2[3]), false);
        }

        public static int getCyclingColor(float speed, int ... colors) {
            float time = Render.getAnimationTick() * speed;
            return Color.lerpColors((net.minecraft.util.Mth.sin((float)time) + 1.0f) / 2.0f, colors);
        }

        public static int getRainbow(float speed) {
            int[] rainbow = new int[36];
            for (int i = 0; i < rainbow.length; ++i) {
                rainbow[i] = java.awt.Color.HSBtoRGB((float)i / 36.0f, 1.0f, 1.0f) & 0xFFFFFF;
            }
            return Color.getCyclingColor(speed, rainbow);
        }

        public static float getRed(int color) {
            return (float)(color >> 16 & 0xFF) / 255.0f;
        }

        public static float getGreen(int color) {
            return (float)(color >> 8 & 0xFF) / 255.0f;
        }

        public static float getBlue(int color) {
            return (float)(color & 0xFF) / 255.0f;
        }

        public static float getAlpha(int color) {
            return (float)(color >> 24 & 0xFF) / 255.0f;
        }
    }

    public static final class Client {
        @OnlyIn(value=Dist.CLIENT)
        public static void setSafeScreen(Screen screen) {
            try {
                if (!mc.isSameThread()) {
                    mc.execute(() -> Client.setSafeScreen(screen));
                    return;
                }
                if (NcUtils.mc.level == null || NcUtils.mc.player == null) {
                    return;
                }
                if (!NcUtils.mc.level.isClientSide()) {
                    return;
                }
                mc.setScreen(screen);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static boolean hasAdvancement(ServerPlayer player, ResourceLocation id) {
            AdvancementHolder advancement = player.server.getAdvancements().get(id);
            return advancement != null && player.getAdvancements().getOrStartProgress(advancement).isDone();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void sendMessage(Player player, Component key) {
            if (key != null) {
                player.displayClientMessage(key, true);
            }
        }
    }

    public static final class Item {
        public static boolean insertItem(ContainerBlockEntity be, Player player, int slot, int maxTransfer) {
            SimpleContainer inv = be.getInventory();
            ItemStack slotStack = inv.getItem(slot);
            ItemStack heldStack = player.getMainHandItem();
            int actualMax = Math.min(maxTransfer, be.maxInSlot);
            if (heldStack.isEmpty()) {
                if (slotStack.isEmpty()) {
                    return false;
                }
                int transferAmount = Math.min(slotStack.getCount(), actualMax);
                player.setItemInHand(InteractionHand.MAIN_HAND, slotStack.copy());
                slotStack.shrink(transferAmount);
                inv.setItem(slot, slotStack.isEmpty() ? ItemStack.EMPTY : slotStack);
                return true;
            }
            if (slotStack.isEmpty()) {
                int transferAmount = Math.min(heldStack.getCount(), actualMax);
                ItemStack insert = heldStack.copyWithCount(transferAmount);
                inv.setItem(slot, insert);
                heldStack.shrink(transferAmount);
                return true;
            }
            if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)heldStack)) {
                int spaceAvailable = Math.min(be.maxInSlot, slotStack.getMaxStackSize()) - slotStack.getCount();
                int transferAmount = Math.min(Math.min(heldStack.getCount(), spaceAvailable), actualMax);
                if (transferAmount <= 0) {
                    return false;
                }
                slotStack.grow(transferAmount);
                heldStack.shrink(transferAmount);
                inv.setItem(slot, slotStack);
                return true;
            }
            inv.setItem(slot, heldStack.copy());
            player.setItemInHand(InteractionHand.MAIN_HAND, slotStack.copy());
            return true;
        }

        public static LootTable getLootTable(ServerLevel level, ResourceKey<LootTable> id) {
            return level.getServer().reloadableRegistries().getLootTable(id);
        }

        public static LootParams getGiftParams(ServerLevel level, Vec3 pos, Entity entity, float luck) {
            return new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)pos).withLuck(luck).create(LootContextParamSets.GIFT);
        }

        public static LootParams getParamsWithPlayer(ServerLevel level, Vec3 pos, Entity entity, float luck, ContextKeySet param) {
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)level);
            return new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)pos).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack((Player)fakePlayer)).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withLuck(luck).create(param);
        }

        public static List<ItemStack> createLoot(ResourceKey<LootTable> id, LootParams params) {
            LootTable loot = Item.getLootTable(params.getLevel(), id);
            if (loot == LootTable.EMPTY) {
                return Lists.newArrayList();
            }
            return loot.getRandomItems(params);
        }

        public static void giveLoot(Player player, List<ItemStack> items) {
            for (ItemStack stack : items) {
                if (player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
        }

        public static void spawnLoot(net.minecraft.world.level.Level level, BlockPos pPos, Collection<ItemStack> items) {
            if (!level.isClientSide()) {
                for (ItemStack stack : items) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pPos.getX() + 0.5f), (double)((float)pPos.getY() + 0.5f), (double)((float)pPos.getZ() + 0.5f), stack));
                }
            }
        }

        public static <T> Optional<DataComponentType<T>> hasComponent(ItemStack stack, Supplier<DataComponentType<T>> comp, Consumer<T> cons) {
            if (stack.has(comp)) {
                cons.accept(stack.get(comp.get()));
                return Optional.of(comp.get());
            }
            return Optional.empty();
        }

        public static <T> void instanceOf(net.minecraft.world.item.Item item, Class<T> targetClass, Consumer<T> action) {
            net.minecraft.world.item.Item target;
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                v0 = bi.getBlock();
            } else {
                v0 = target = item;
            }
            if (targetClass.isInstance(target)) {
                action.accept(targetClass.cast(target));
            }
        }
    }

    public static final class Block {
        public static void forEachCube(BlockPos center, int radius, Consumer<BlockPos> action) {
            Block.forEachInVolume(center, radius, radius, radius, pos -> true, action);
        }

        public static void forEachSphere(BlockPos center, int radius, Consumer<BlockPos> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, radius, radius, pos -> {
                int dz;
                int dy;
                int dx = pos.getX() - center.getX();
                return dx * dx + (dy = pos.getY() - center.getY()) * dy + (dz = pos.getZ() - center.getZ()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachCircle(BlockPos center, int radius, int height, Consumer<BlockPos> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, height, radius, pos -> {
                int dz;
                int dx = pos.getX() - center.getX();
                return dx * dx + (dz = pos.getZ() - center.getZ()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachDiamond(BlockPos center, int radius, int height, Consumer<BlockPos> action) {
            if (radius <= 0 || height <= 0) {
                return;
            }
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int y = 0; y <= height; ++y) {
                int currentRadius = radius * (height - y) / height;
                for (int x = -currentRadius; x <= currentRadius; ++x) {
                    for (int z = -currentRadius; z <= currentRadius; ++z) {
                        if (Math.abs(x) + Math.abs(z) > currentRadius) continue;
                        mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        action.accept((BlockPos)mutablePos);
                        if (y == 0) continue;
                        mutablePos.setY(center.getY() - y);
                        action.accept((BlockPos)mutablePos);
                    }
                }
            }
        }

        public static void forEachNeighbor(BlockPos pos, Consumer<BlockPos> action) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (Direction dir : Direction.values()) {
                action.accept((BlockPos)mutablePos.setWithOffset((Vec3i)pos, dir));
            }
        }

        public static ToIntFunction<BlockState> lightLit(int value, int baseValue) {
            return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? value : baseValue;
        }

        public static boolean isFluid(BlockState state) {
            return state.getFluidState().isSource();
        }

        private static void forEachInVolume(BlockPos center, int xRad, int yRad, int zRad, Predicate<BlockPos> filter, Consumer<BlockPos> action) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int x = -xRad; x <= xRad; ++x) {
                for (int y = -yRad; y <= yRad; ++y) {
                    for (int z = -zRad; z <= zRad; ++z) {
                        mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        if (!filter.test((BlockPos)mutablePos)) continue;
                        action.accept((BlockPos)mutablePos);
                    }
                }
            }
        }

        public static boolean isFullVoxel(BlockState state, boolean inHeight) {
            VoxelShape shape = state.getCollisionShape(null, null);
            return inHeight ? shape.bounds().minY == 0.0 && shape.bounds().maxY == 1.0 : shape.bounds().minX == 0.0 && shape.bounds().maxX == 1.0 && shape.bounds().minY == 0.0 && shape.bounds().maxY == 1.0 && shape.bounds().minZ == 0.0 && shape.bounds().maxZ == 1.0;
        }

        public static void updateBlockEntity(BlockEntity be) {
            if (be.getLevel() == null) {
                return;
            }
            be.setChanged();
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        }

        public static boolean createLootableChest(LevelAccessor level, BlockPos pos, ResourceLocation loot) {
            return Block.createLootableChest(Blocks.CHEST, level, pos, loot);
        }

        public static boolean createLootableChest(net.minecraft.world.level.block.Block chest, LevelAccessor level, BlockPos pos, ResourceLocation loot) {
            level.setBlock(pos, chest.defaultBlockState(), 3);
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity r = (RandomizableContainerBlockEntity)be;
                r.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)loot));
                return true;
            }
            return false;
        }

        public static net.minecraft.world.level.block.Block[] getClassBlocks(Class<?> ... classes) {
            DefaultedRegistry blocks = BuiltInRegistries.BLOCK;
            ArrayList<net.minecraft.world.level.block.Block> matchingBlocks = new ArrayList<net.minecraft.world.level.block.Block>();
            for (net.minecraft.world.level.block.Block block : blocks) {
                if (!Arrays.stream(classes).anyMatch(b -> b.isInstance(block))) continue;
                matchingBlocks.add(block);
            }
            return matchingBlocks.toArray(new net.minecraft.world.level.block.Block[0]);
        }
    }
}

