/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.mixin;

import com.mw.nullcore.client.audio.ServerTracker;
import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import com.mw.nullcore.core.items.armor.SuitItem;
import com.mw.nullcore.core.managers.LockableManager;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.equipment.ArmorMaterial;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public final class PlayerMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void nc$onTick(CallbackInfo ci) {
        Player self = (Player)this;
        if (self.level().getGameTime() % 40L == 0L) {
            if (self.isSilent()) {
                return;
            }
            if (self instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)self;
                ServerTracker.tick(sp);
            }
            for (Map.Entry<ArmorMaterial, ArmorMaterialBuilder.ShyEffect[]> effect : ArmorMaterialBuilder.effects.entrySet()) {
                if (!SuitItem.hasArmorSet(self, effect.getKey())) continue;
                for (ArmorMaterialBuilder.ShyEffect shyEffect : effect.getValue()) {
                    if (!shyEffect.condition().test(self)) continue;
                    self.addEffect(new MobEffectInstance(shyEffect.effect(), shyEffect.time(), shyEffect.level(), shyEffect.visible(), shyEffect.visible()));
                }
            }
            for (ResourceLocation id : LockableManager.selfLockable.keySet()) {
                LockableManager.LockableEntry entry = LockableManager.selfLockable.get(id);
                if (entry.effects() == null) {
                    return;
                }
                if (!NcUtils.Level.isStructure(self.level(), self.blockPosition(), id) && !self.level().getBiome(self.blockPosition()).is(id) || !entry.lock() && (entry.required() == null || NcUtils.Client.hasAdvancement((ServerPlayer)self, entry.required().advancement()))) continue;
                for (Holder<MobEffect> effect : entry.effects()) {
                    self.addEffect(new MobEffectInstance(effect, 45));
                }
            }
        }
    }
}

