/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.multiblocks;

import com.ibm.icu.impl.Pair;
import com.mw.nullcore.core.entities.ShyItemEntity;
import com.mw.nullcore.core.multiblocks.Blueprint;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseSingleBlock
implements Blueprint {
    private final Blueprint.ResultEntry required;
    private final Item activator;
    private final Consumer<ShyItemEntity> entity;
    private BiPredicate<Player, ItemStack> condition;
    private Pair<SoundEvent, ParticleOptions> effects;

    public BaseSingleBlock(Blueprint.ResultEntry required, Item activator, Consumer<ShyItemEntity> entity) {
        this.required = required;
        this.activator = activator;
        this.entity = entity;
    }

    public BaseSingleBlock(Blueprint.ResultEntry required, Item activator) {
        this(required, activator, null);
    }

    @Override
    public Direction getDirectionStructure(Level level, BlockPos centerPos) {
        BlockState state = level.getBlockState(centerPos);
        if (state.getBlock() == this.required.required()) {
            if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                return (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            }
            return Direction.NORTH;
        }
        return null;
    }

    @Override
    public Blueprint.Structure getStructure(Level level, BlockPos pos) {
        Direction direction = this.getDirectionStructure(level, pos);
        if (direction != null) {
            return new Blueprint.Structure(0, 0, 0, direction);
        }
        return null;
    }

    @Override
    public void onBuilt(Level level, BlockPos startPos, Blueprint.Structure structure) {
        if (structure == null) {
            return;
        }
        this.applyEffects(level, startPos);
        this.applyResult(level, startPos, this.required.result(), structure.facing());
    }

    @Override
    public boolean canActivate(Player player, Level level, ItemStack stack) {
        boolean flag = stack.is(this.activator);
        return this.condition != null ? this.condition.test(player, stack) && flag : flag;
    }

    @Override
    public final BaseSingleBlock condition(BiPredicate<Player, ItemStack> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public final BaseSingleBlock effects(SoundEvent sound, ParticleOptions particle) {
        this.effects = Pair.of((Object)sound, (Object)particle);
        return this;
    }

    @Override
    public Consumer<ShyItemEntity> getEntity() {
        return this.entity;
    }

    @Override
    public Item getActivator() {
        return this.activator;
    }

    @Override
    public Pair<SoundEvent, ParticleOptions> getEffects() {
        return this.effects;
    }
}

