/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.multiblocks;

import com.ibm.icu.impl.Pair;
import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.entities.ShyItemEntity;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface Blueprint {
    public Direction getDirectionStructure(Level var1, BlockPos var2);

    public void onBuilt(Level var1, BlockPos var2, Structure var3);

    public Structure getStructure(Level var1, BlockPos var2);

    default public boolean canActivate(Player player, Level level, ItemStack stack) {
        return false;
    }

    public Blueprint condition(BiPredicate<Player, ItemStack> var1);

    default public void applyResult(Level level, BlockPos pos, Object result, Direction facing) {
        if (result instanceof Block) {
            Block block = (Block)result;
            BlockState state = block.defaultBlockState();
            if (facing != null && state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                state = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
            }
            level.setBlock(pos, state, 2);
        } else if (result instanceof Item) {
            Item item = (Item)result;
            ItemStack stack = new ItemStack((ItemLike)item);
            ShyItemEntity entity = new ShyItemEntity(level, (float)((double)pos.getX() + 0.5), (float)((double)pos.getY() + 0.5), (float)((double)pos.getZ() + 0.5), stack);
            this.getEntity().accept(entity);
            entity.setNoGravity(true);
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            level.addFreshEntity((Entity)entity);
        }
    }

    default public void applyEffects(Level level, BlockPos pos) {
        level.removeBlock(pos, false);
        if (this.getEffects() == null || !level.isClientSide()) {
            return;
        }
        if (this.getEffects().first != null) {
            Minecraft.getInstance().player.playSound((SoundEvent)this.getEffects().first);
        }
        if (this.getEffects().second != null) {
            NcUtils.Particle.forAxisParticle(pos, (ParticleOptions)this.getEffects().second);
        } else {
            level.addDestroyBlockEffect(pos, level.getBlockState(pos));
        }
    }

    default public Consumer<ShyItemEntity> getEntity() {
        return null;
    }

    default public Item getActivator() {
        return null;
    }

    default public Pair<SoundEvent, ParticleOptions> getEffects() {
        return null;
    }

    public Blueprint effects(SoundEvent var1, ParticleOptions var2);

    public static class Rotation {
        int rows;
        int cols;
        Object[][] matrix;

        Rotation(Object[][] matrix) {
            this.rows = matrix.length;
            this.cols = matrix[0].length;
            this.matrix = new Object[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(matrix[i], 0, this.matrix[i], 0, this.cols);
            }
        }

        void rotateRight(int times) {
            for (int a = 0; a < times; ++a) {
                Object[][] newMatrix = new Object[this.cols][this.rows];
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.cols; ++j) {
                        newMatrix[j][this.rows - i - 1] = this.matrix[i][j];
                    }
                }
                this.matrix = newMatrix;
                int tmp = this.rows;
                this.rows = this.cols;
                this.cols = tmp;
            }
        }
    }

    public record ResultEntry(ItemLike required, ItemLike result) {
    }

    public record Structure(int xOffset, int yOffset, int zOffset, Direction facing) {
    }
}

