/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.client.audio.Track;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public final class TracksManager
extends class_4080<Map<class_2960, HashSet<Track>>> {
    public static final Map<class_2960, HashSet<Track>> selfTracks = new HashMap<class_2960, HashSet<Track>>();

    public Map<class_2960, HashSet<Track>> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, HashSet<Track>> allTracks = new HashMap<class_2960, HashSet<Track>>();
        Map resources = manager.method_14488("level", id -> id.method_12832().endsWith("tracks.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String jsonContent = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    Map<class_2960, HashSet<Track>> parsedTracks = TracksManager.parseTracks(jsonContent);
                    parsedTracks.forEach((id, tracks) -> allTracks.merge((class_2960)id, (HashSet<Track>)tracks, (oldTracks, newTracks) -> {
                        HashSet merged = new HashSet(oldTracks);
                        merged.addAll(newTracks);
                        return merged;
                    }));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load tracks from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return allTracks;
    }

    public void apply(@NotNull Map<class_2960, HashSet<Track>> allTracks, class_3300 manager, class_3695 profiler) {
        selfTracks.clear();
        selfTracks.putAll(allTracks);
    }

    public static Map<class_2960, HashSet<Track>> parseTracks(String json) {
        HashMap<class_2960, HashSet<Track>> tracks = new HashMap<class_2960, HashSet<Track>>();
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                class_2960 id = class_2960.method_12829((String)((String)entry.getKey()));
                if (id == null) {
                    NullCore.LOG.warn("Invalid element ID: {}", entry.getKey());
                    continue;
                }
                HashSet<Track> selfTracks = TracksManager.parseTrackList(((JsonElement)entry.getValue()).getAsJsonArray());
                tracks.put(class_2960.method_60655((String)id.method_12836(), (String)id.method_12832()), selfTracks);
            }
        }
        catch (Exception e) {
            NullCore.LOG.error("Failed to parse tracks JSON: {}", (Object)e.getMessage());
        }
        return tracks;
    }

    private static HashSet<Track> parseTrackList(JsonArray array) {
        HashSet<Track> tracks = new HashSet<Track>();
        for (JsonElement element : array) {
            try {
                DataResult result = Track.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (!result.result().isPresent()) continue;
                tracks.add((Track)result.result().get());
            }
            catch (Exception e) {
                NullCore.LOG.warn("Failed to parse track element: {}", (Object)element, (Object)e);
            }
        }
        return tracks;
    }
}

