/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.multiblocks;

import com.mw.nullcore.core.multiblocks.Blueprint;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BaseMultiBlock
implements Blueprint {
    final Object[][][] structure;
    final int xSize;
    final int ySize;
    final int zSize;
    final class_1792 activator;
    BiPredicate<class_1657, class_1799> condition = null;

    public BaseMultiBlock(Object[][][] structure, class_1792 activator) {
        this.structure = structure;
        this.ySize = structure.length;
        this.xSize = structure[0].length;
        this.zSize = structure[0][0].length;
        this.activator = activator;
    }

    @Override
    @Nullable
    public class_2350 validateStructure(class_1937 level, class_2338 centerPos) {
        class_2350[] horizontals;
        for (class_2350 face : horizontals = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new)) {
            boolean matches = true;
            for (int y = 0; y < this.ySize; ++y) {
                Blueprint.Rotation rotation = new Blueprint.Rotation(this.structure[y]);
                rotation.rotateRight(3 - face.method_10161());
                for (int x = 0; x < rotation.rows; ++x) {
                    for (int z = 0; z < rotation.cols; ++z) {
                        class_2248 requiredBlock;
                        Object element = rotation.matrix[x][z];
                        if (element == null) continue;
                        class_2338 checkPos = centerPos.method_10069(x, -y + (this.ySize - 1), z);
                        class_2680 worldState = level.method_8320(checkPos);
                        class_1935 value = null;
                        if (element instanceof Blueprint.Result) {
                            Blueprint.Result result = (Blueprint.Result)element;
                            Object object = result.required();
                            if (object instanceof class_1935) {
                                class_1935 l;
                                value = l = (class_1935)object;
                            }
                        } else if (element instanceof class_1935) {
                            class_1935 l;
                            value = l = (class_1935)element;
                        }
                        if (value == null || (requiredBlock = class_2248.method_9503((class_1792)value.method_8389())) == class_2246.field_10124 || worldState.method_27852(requiredBlock)) continue;
                        matches = false;
                    }
                }
            }
            if (!matches) continue;
            return face;
        }
        return null;
    }

    @Override
    public Blueprint.Structure getStructure(class_1937 level, class_2338 pos) {
        for (int yy = -this.ySize; yy <= 0; ++yy) {
            for (int xx = -this.xSize; xx <= 0; ++xx) {
                for (int zz = -this.zSize; zz <= 0; ++zz) {
                    class_2338 p2 = pos.method_10069(xx, yy, zz);
                    class_2350 d = this.validateStructure(level, p2);
                    if (d == null) continue;
                    return new Blueprint.Structure(xx, yy, zz, d);
                }
            }
        }
        return null;
    }

    @Override
    public void onBuilt(class_1937 level, class_2338 startPos, Blueprint.Structure structure) {
        if (structure == null) {
            return;
        }
        class_2338 p2 = startPos.method_10069(structure.xOffset(), structure.yOffset(), structure.zOffset());
        for (int y = 0; y < this.ySize; ++y) {
            Blueprint.Rotation rot = new Blueprint.Rotation(this.structure[y]);
            rot.rotateRight(3 - structure.facing().method_10161());
            for (int x = 0; x < rot.rows; ++x) {
                for (int z = 0; z < rot.cols; ++z) {
                    class_2338 p3 = p2.method_10069(x, -y + (this.ySize - 1), z);
                    level.method_22352(p3, false);
                    Object object = rot.matrix[x][z];
                    if (!(object instanceof Blueprint.Result)) continue;
                    Blueprint.Result result = (Blueprint.Result)object;
                    this.applyResult(level, p3, result.result(), structure.facing());
                }
            }
        }
    }

    @Override
    public boolean canActivate(class_1657 player, class_1937 level, class_1799 stack) {
        boolean flag = stack.method_31574(this.activator);
        return this.condition != null ? this.condition.test(player, stack) && flag : flag;
    }

    @Override
    public final BaseMultiBlock condition(BiPredicate<class_1657, class_1799> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public class_1792 getActivator() {
        return this.activator;
    }
}

