/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ConfigManager {
    private static Initialize INSTANCE;
    public static Map<String, Set<Initialize.Unit<?>>> variables;

    public static void register(String modid, Path configDir, Runnable registers) {
        Path configPath = configDir.resolve(modid + ".json");
        INSTANCE = new Initialize(configPath, modid);
        registers.run();
        INSTANCE.load();
    }

    public static <V> Initialize.Unit<V> create(String key, String comment, V defaultValue) {
        Initialize.Unit<V> unit = Initialize.Unit.of(key, comment, defaultValue);
        ConfigManager.INSTANCE.config.put(key, unit);
        variables.put(ConfigManager.INSTANCE.modid, Set.of(unit));
        return unit;
    }

    public static <V> Initialize.Unit<V> getUnit(String key) {
        return ConfigManager.INSTANCE.config.get(key);
    }

    public static <V> void set(String key, V value) {
        Initialize.Unit<V> unit = ConfigManager.getUnit(key);
        if (unit != null) {
            ConfigManager.INSTANCE.config.put(key, Initialize.Unit.of(key, unit.comment(), value));
            unit.set(value);
        }
    }

    static {
        variables = new HashMap();
    }

    public static final class Initialize {
        public final Map<String, Unit<?>> config = new LinkedHashMap();
        private final Path configPath;
        public final String modid;

        public Initialize(Path configPath, String modid) {
            this.configPath = configPath;
            this.modid = modid;
        }

        void load() {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                this.save();
                return;
            }
            try {
                String content = Files.readString(this.configPath);
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith("_")) continue;
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!this.config.containsKey(key)) continue;
                    this.updateConfig(key, element);
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load config: {}", (Object)e.getMessage());
            }
        }

        private void updateConfig(String key, JsonElement element) {
            Unit<?> unit = this.config.get(key);
            Object newValue = Utils.Reader.parseJsonValue(element, unit.get());
            if (newValue != null) {
                ConfigManager.set(key, newValue);
            }
        }

        void save() {
            JsonObject json = new JsonObject();
            this.config.forEach((key, unit) -> {
                json.addProperty("_" + key + "_comment", unit.comment());
                Utils.Reader.addValueToJson(json, key, unit.get());
            });
            try {
                Files.writeString(this.configPath, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json), new OpenOption[0]);
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to save config: {}", (Object)e.getMessage());
            }
        }

        public static class Unit<V> {
            final String comment;
            final String name;
            V value;

            private Unit(String name, String comment, V value) {
                this.value = value;
                this.name = name;
                this.comment = comment;
            }

            public static <V> Unit<V> of(String name, String comment, V value) {
                return new Unit<V>(name, comment, value);
            }

            public V get() {
                return this.value;
            }

            public void set(V value) {
                this.value = value;
            }

            public void setParse(String value) {
                this.value = this.parseValue(value);
            }

            public String comment() {
                return this.comment;
            }

            public String name() {
                return this.name;
            }

            private V parseValue(String value) {
                if (this.get() instanceof Boolean) {
                    return (V)Boolean.valueOf(value);
                }
                if (this.get() instanceof Byte) {
                    return (V)Byte.valueOf(value);
                }
                if (this.get() instanceof Integer) {
                    return (V)Integer.valueOf(value);
                }
                if (this.get() instanceof Float) {
                    return (V)Float.valueOf(value);
                }
                if (this.get() instanceof Double) {
                    return (V)Double.valueOf(value);
                }
                if (this.get() instanceof String) {
                    return (V)value;
                }
                return null;
            }
        }
    }
}

