/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mw.nullcore.Utils;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GuiRenderBuilder {
    public static final ResourceLocation BLOCK_ATLAS = ResourceLocation.tryParse((String)"textures/atlas/blocks.png");
    protected final MultiBufferSource mBuffer = Utils.Render.mBuffer;
    protected float u0;
    protected float v0;
    protected float u1;
    protected float v1;
    protected float a = 1.0f;
    protected float[] color;
    protected VertexConsumer vertex;
    protected PoseStack ps;
    protected PoseStack.Pose pose;
    protected ResourceLocation texture;
    protected TextureAtlasSprite sprite;

    public static GuiRenderBuilder builder() {
        return new GuiRenderBuilder();
    }

    public GuiRenderBuilder renderType(Function<ResourceLocation, RenderType> type, ResourceLocation texture) {
        this.vertex = this.mBuffer.getBuffer(type.apply(texture));
        this.texture = texture;
        return this;
    }

    public GuiRenderBuilder renderType(ResourceLocation texture) {
        return this.renderType(RenderType::guiTextured, texture);
    }

    public GuiRenderBuilder pose(PoseStack ps) {
        this.ps = ps;
        this.pose = ps.last();
        return this;
    }

    public GuiRenderBuilder rotate(float angel) {
        this.ps.mulPose(new Quaternionf().rotateZ(angel));
        return this;
    }

    public GuiRenderBuilder spinner(float mSpeed) {
        float rotationTime = Utils.Render.getAnimationTick() * mSpeed + 0.5f;
        return this.rotate(rotationTime);
    }

    public GuiRenderBuilder scale(float scale) {
        this.ps.scale(scale, scale, 0.5f);
        return this;
    }

    public GuiRenderBuilder pulseScale(float min, float max, float mSpeed) {
        float pulse = Mth.sin((float)(Utils.Render.getAnimationTick() * mSpeed)) * 0.5f + 0.5f;
        float scale = min + (min - max) * pulse;
        return this.scale(scale);
    }

    public GuiRenderBuilder moveBefore(float x, float y) {
        this.ps.translate(x, y, 100.0f);
        return this;
    }

    public GuiRenderBuilder moveAfter(float x, float y) {
        this.ps.translate(x, y, 159.0f);
        return this;
    }

    public GuiRenderBuilder color(int color) {
        this.color = Utils.Color.unpack(color, false);
        return this;
    }

    public GuiRenderBuilder color(float r, float g, float b) {
        this.color = new float[]{r, g, b, this.a};
        return this;
    }

    public GuiRenderBuilder color(float speed, int ... color) {
        this.color = Utils.Color.unpack(Utils.Color.getCyclingColor(speed, color), false);
        return this;
    }

    public GuiRenderBuilder alpha(float a) {
        this.a = a;
        return this;
    }

    public GuiRenderBuilder pulseAlpha(float mSpeed) {
        float pulse = Mth.sin((float)(Utils.Render.getAnimationTick() * mSpeed)) * 0.5f + 0.5f;
        return this.alpha(pulse);
    }

    public GuiRenderBuilder buildOverlay(float size) {
        return this.buildOverlay(size, size);
    }

    public GuiRenderBuilder buildOverlay(float width, float height) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        return this.renderQuad(positions, width, height);
    }

    private GuiRenderBuilder renderQuad(Vector3f[] positions, float width, float height) {
        if (this.vertex == null || this.ps == null) {
            return this;
        }
        for (Vector3f position : positions) {
            position.mul(width, height, width);
        }
        this.addVertex(positions[0], this.u0, this.v1);
        this.addVertex(positions[1], this.u1, this.v1);
        this.addVertex(positions[2], this.u1, this.v0);
        this.addVertex(positions[3], this.u0, this.v0);
        return this;
    }

    private void addVertex(Vector3f pos, float u, float v) {
        this.vertex.addVertex(this.pose, pos.x(), pos.y(), pos.z()).setColor(this.color[0], this.color[1], this.color[2], this.a).setUv(u, v);
    }
}

