/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.multiblocks;

import com.mw.nullcore.core.multiblocks.Blueprint;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BaseMultiBlock
implements Blueprint {
    final Object[][][] structure;
    final int xSize;
    final int ySize;
    final int zSize;
    final Item activator;
    BiPredicate<Player, ItemStack> condition = null;

    public BaseMultiBlock(Object[][][] structure, Item activator) {
        this.structure = structure;
        this.ySize = structure.length;
        this.xSize = structure[0].length;
        this.zSize = structure[0][0].length;
        this.activator = activator;
    }

    @Override
    @Nullable
    public Direction validateStructure(Level level, BlockPos centerPos) {
        Direction[] horizontals;
        for (Direction face : horizontals = (Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new)) {
            boolean matches = true;
            for (int y = 0; y < this.ySize; ++y) {
                Blueprint.Rotation rotation = new Blueprint.Rotation(this.structure[y]);
                rotation.rotateRight(3 - face.get2DDataValue());
                for (int x = 0; x < rotation.rows; ++x) {
                    for (int z = 0; z < rotation.cols; ++z) {
                        Block requiredBlock;
                        Object element = rotation.matrix[x][z];
                        if (element == null) continue;
                        BlockPos checkPos = centerPos.offset(x, -y + (this.ySize - 1), z);
                        BlockState worldState = level.getBlockState(checkPos);
                        ItemLike value = null;
                        if (element instanceof Blueprint.Result) {
                            Blueprint.Result result = (Blueprint.Result)element;
                            Object object = result.required();
                            if (object instanceof ItemLike) {
                                ItemLike l;
                                value = l = (ItemLike)object;
                            }
                        } else if (element instanceof ItemLike) {
                            ItemLike l;
                            value = l = (ItemLike)element;
                        }
                        if (value == null || (requiredBlock = Block.byItem((Item)value.asItem())) == Blocks.AIR || worldState.is(requiredBlock)) continue;
                        matches = false;
                    }
                }
            }
            if (!matches) continue;
            return face;
        }
        return null;
    }

    @Override
    public Blueprint.Structure getStructure(Level level, BlockPos pos) {
        for (int yy = -this.ySize; yy <= 0; ++yy) {
            for (int xx = -this.xSize; xx <= 0; ++xx) {
                for (int zz = -this.zSize; zz <= 0; ++zz) {
                    BlockPos p2 = pos.offset(xx, yy, zz);
                    Direction d = this.validateStructure(level, p2);
                    if (d == null) continue;
                    return new Blueprint.Structure(xx, yy, zz, d);
                }
            }
        }
        return null;
    }

    @Override
    public void onBuilt(Level level, BlockPos startPos, Blueprint.Structure structure, Object ... other) {
        if (structure == null) {
            return;
        }
        BlockPos p2 = startPos.offset(structure.xOffset(), structure.yOffset(), structure.zOffset());
        for (int y = 0; y < this.ySize; ++y) {
            Blueprint.Rotation rot = new Blueprint.Rotation(this.structure[y]);
            rot.rotateRight(3 - structure.facing().get2DDataValue());
            for (int x = 0; x < rot.rows; ++x) {
                for (int z = 0; z < rot.cols; ++z) {
                    BlockPos p3 = p2.offset(x, -y + (this.ySize - 1), z);
                    level.destroyBlock(p3, false);
                    Object object = rot.matrix[x][z];
                    if (!(object instanceof Blueprint.Result)) continue;
                    Blueprint.Result result = (Blueprint.Result)object;
                    this.applyResult(level, p3, result.result(), structure.facing());
                }
            }
        }
    }

    @Override
    public boolean canActivate(Player player, Level level, ItemStack stack) {
        boolean flag = stack.is(this.activator);
        return this.condition != null ? this.condition.test(player, stack) && flag : flag;
    }

    @Override
    public final BaseMultiBlock condition(BiPredicate<Player, ItemStack> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public Item getActivator() {
        return this.activator;
    }
}

