/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class NullMenu
extends AbstractContainerMenu {
    protected final int startIndex;
    protected final Container container;

    protected NullMenu(@Nullable MenuType<?> menuType, int id, Container container) {
        super(menuType, id);
        this.container = container;
        this.startIndex = this.slots.size();
        this.addPlayerInventory(container);
        this.addMenuSlots(container);
    }

    protected abstract void addMenuSlots(Container var1);

    private void addPlayerInventory(Container playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot(playerInv, col, 8 + col * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            stack = itemstack1.copy();
            if (index < this.startIndex ? !this.moveItemStackTo(itemstack1, this.startIndex, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.startIndex, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

