/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public final class SearchBox
extends EditBox {
    private List<String> searchList = new ArrayList<String>();
    private Map<String, Object> searchMap = new HashMap<String, Object>();
    private Consumer<List<String>> consumerResult;
    private final List<String> result = new ArrayList<String>();
    private boolean searchInMapKeys;

    public SearchBox(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.setResponder(text -> this.search());
    }

    public SearchBox searchList(List<String> items) {
        this.searchList = new ArrayList<String>(items);
        this.searchInMapKeys = false;
        return this;
    }

    public SearchBox searchMap(Map<String, Object> map, boolean searchKeys) {
        this.searchMap = new HashMap<String, Object>(map);
        this.searchInMapKeys = searchKeys;
        this.searchList = searchKeys ? new ArrayList<String>(map.keySet()) : new ArrayList();
        return this;
    }

    public void searchResult(Consumer<List<String>> consumer) {
        this.consumerResult = consumer;
    }

    public List<String> getResult() {
        return this.result;
    }

    private void search() {
        String searchText = this.getValue().toLowerCase();
        ArrayList results = new ArrayList();
        if (!this.searchMap.isEmpty()) {
            this.searchMap.forEach((key, value) -> {
                if (this.searchInMapKeys && key.toLowerCase().contains(searchText)) {
                    results.add(key);
                } else if (!this.searchInMapKeys && value.toString().toLowerCase().contains(searchText)) {
                    results.add(value.toString());
                }
            });
        } else {
            this.searchList.stream().filter(obj -> obj.toLowerCase().contains(searchText)).forEach(results::add);
        }
        if (this.consumerResult != null) {
            this.consumerResult.accept(results);
        }
        this.result.addAll(results);
    }
}

