/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.holders;

import com.mw.nullcore.NullCore;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class OuterCreativeTab
extends DeferredRegister<CreativeModeTab> {
    private OuterCreativeTab(String modid) {
        super(Registries.CREATIVE_MODE_TAB, modid);
    }

    public static OuterCreativeTab create(String modid) {
        return new OuterCreativeTab(modid);
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> registerTab(String id, Component title, Supplier<ItemStack> icon, ResourceLocation background, ItemLike ... items) {
        return this.register(id, () -> CreativeModeTab.builder().title(title).icon(icon).displayItems((p, o) -> {
            for (ItemLike item : items) {
                if (item == null) continue;
                o.accept(item);
            }
        }).backgroundTexture(background).build());
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> registerSearchTab(String id, Component title, Supplier<ItemStack> icon, ResourceLocation background, ItemLike ... items) {
        return this.register(id, () -> CreativeModeTab.builder().title(title).icon(icon).displayItems((p, o) -> {
            for (ItemLike item : items) {
                if (item != null) {
                    o.accept(item);
                }
                NullCore.LOG.info("Register creative tab id {}", (Object)id);
            }
        }).backgroundTexture(background).withSearchBar().build());
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> registerTab(String id, Component title, Supplier<ItemStack> icon, ItemLike ... items) {
        return this.registerTab(id, title, icon, CreativeModeTab.createTextureLocation((String)"items"), items);
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> registerSearchTab(String id, Component title, Supplier<ItemStack> icon, ItemLike ... items) {
        return this.registerSearchTab(id, title, icon, CreativeModeTab.createTextureLocation((String)"items"), items);
    }

    public <S extends CreativeModeTab> DeferredHolder<CreativeModeTab, S> register(String name, Supplier<? extends S> sup) {
        return this.register(name, key -> (CreativeModeTab)sup.get());
    }

    protected <S extends CreativeModeTab> DeferredHolder<CreativeModeTab, S> createHolder(ResourceKey<? extends Registry<CreativeModeTab>> registryKey, ResourceLocation key) {
        return DeferredHolder.create((ResourceKey)ResourceKey.create(registryKey, (ResourceLocation)key));
    }
}

