/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.mixin;

import com.mw.nullcore.core.managers.BiomeRulesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public final class LevelMixin {
    @Inject(method={"getDayTime"}, at={@At(value="HEAD")}, cancellable=true)
    private void nc$getTime(CallbackInfoReturnable<Long> cir) {
        Level level = (Level)this;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Holder biome = level.getBiome(player.blockPosition());
        ResourceLocation id = biome.unwrapKey().map(ResourceKey::location).orElse(null);
        BiomeRulesManager.getRules(id).flatMap(r -> r.getRule("fixed_time", Long.class)).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getRainLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void nc$getRain(CallbackInfoReturnable<Float> cir) {
        Level level = (Level)this;
        if (!level.isClientSide()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Holder biome = level.getBiome(player.blockPosition());
        ResourceLocation id = biome.unwrapKey().map(ResourceKey::location).orElse(null);
        BiomeRulesManager.getRules(id).flatMap(r -> r.getRule("rain_force", Float.class)).ifPresent(intensity -> cir.setReturnValue((Object)Float.valueOf(Mth.clamp((float)intensity.floatValue(), (float)0.0f, (float)1.0f))));
    }
}

