/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.mixin;

import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import com.mw.nullcore.core.items.armor.SuitItem;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.equipment.ArmorMaterial;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public final class PlayerMixin {
    @Unique
    private int nc$tick;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void nc$onTick(CallbackInfo ci) {
        if (this.nc$tick % 40 == 0) {
            Player player = (Player)this;
            if (player.level().isClientSide()) {
                return;
            }
            for (Map.Entry<ArmorMaterial, ArmorMaterialBuilder.ShyEffect[]> effect : ArmorMaterialBuilder.effects.entrySet()) {
                if (!SuitItem.hasArmorSet(player, effect.getKey())) continue;
                for (ArmorMaterialBuilder.ShyEffect shyEffect : effect.getValue()) {
                    if (!shyEffect.condition().test(player)) continue;
                    player.addEffect(new MobEffectInstance(shyEffect.effect(), shyEffect.time(), shyEffect.level(), shyEffect.visible(), shyEffect.visible()));
                }
            }
        }
        ++this.nc$tick;
    }
}

