/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.items.armor;

import com.mw.nullcore.Utils;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.ItemLike;

public class SuitItem
extends ArmorItem {
    final ArmorMaterial material;
    final ArmorType type;
    final boolean useTooltip;

    public SuitItem(Item.Properties prop, ArmorType type, ArmorMaterial material, boolean useTooltip) {
        super(material, type, prop);
        this.material = material;
        this.type = type;
        this.useTooltip = useTooltip;
    }

    public SuitItem(Item.Properties prop, ArmorType type, ArmorMaterial material) {
        this(prop, type, material, true);
    }

    public static Map<ArmorType, ItemStack> getSet(ArmorMaterial material) {
        EnumMap<ArmorType, ItemStack> set = new EnumMap<ArmorType, ItemStack>(ArmorType.class);
        for (Item item : BuiltInRegistries.ITEM) {
            SuitItem aItem;
            if (!(item instanceof SuitItem) || (aItem = (SuitItem)item).getMaterial() != material) continue;
            ArmorType type = aItem.getType();
            set.put(type, new ItemStack((ItemLike)aItem));
        }
        return set;
    }

    public static boolean hasArmorSet(Player player, ArmorMaterial material) {
        for (Map.Entry<ArmorType, ItemStack> entry : SuitItem.getSet(material).entrySet()) {
            ArmorType type = entry.getKey();
            ItemStack actualStack = entry.getValue();
            ItemStack armorStack = player.getInventory().getArmor(type.getSlot().getIndex());
            if (ItemStack.isSameItemSameComponents((ItemStack)armorStack, (ItemStack)actualStack)) continue;
            return false;
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!this.useTooltip) {
            return;
        }
        ArmorMaterialBuilder.ShyEffect[] effects = ArmorMaterialBuilder.effects.get(this.getMaterial());
        Utils.Text.addTooltipEffects(tooltip, Component.translatable((String)"tooltip.nullcore.suitinfo1").withStyle(ChatFormatting.GRAY), Arrays.stream(effects).toList());
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    public ArmorType getType() {
        return this.type;
    }
}

